package com.metro.auth.platform.service;

/**
 * .::::.
 * .::::::::.
 * :::::::::::    佛主保佑、永无Bug
 * ..:::::::::::'
 * '::::::::::::'
 * .::::::::::
 * '::::::::::::::..
 * ..::::::::::::.
 * ``::::::::::::::::
 * ::::``:::::::::'        .:::.
 * ::::'   ':::::'       .::::::::.
 * .::::'      ::::     .:::::::'::::.
 * .:::'       :::::  .:::::::::' ':::::.
 * .::'        :::::.:::::::::'      ':::::.
 * .::'         ::::::::::::::'         ``::::.
 * ...:::           ::::::::::::'              ``::.
 * ```` ':.          ':::::::::'                  ::::..
 * '.:::::'                    ':'````..
 */

import com.metro.auth.platform.domain.auth.*;
import com.metro.auth.platform.domain.dto.RoleFunctionDTO;
import com.metro.auth.platform.mapper.*;
import com.metro.auth.platform.utils.EmptyUtilHelper;
import com.metro.auth.platform.utils.JwtUtils;
import com.metro.auth.platform.utils.StrUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;

import javax.annotation.Resource;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

/**
 * @ClassName: PlatformMenuServiceImpl
 * @Description: ${description}  
 * @Authror zhouy
 * @Date 2019-09-09 17:17
 */
@Slf4j
@Service
public class PlatformMenuServiceImpl implements PlatformMenuService {

    @Resource
    PlatformSysMenuMapper platformSysMenuMapper;

    @Resource
    PlatformRoleMenuMapper platformRoleMenuMapper;

    @Resource
    PlatformSysButtonMapper platformSysButtonMapper;

    @Resource
    PlatformPersonnelMapper platformPersonnelMapper;
    @Resource
    PlatformSysRoleMapper platformSysRoleMapper;
    private final JwtUtils jwtTokenUtil;

    public PlatformMenuServiceImpl(JwtUtils jwtTokenUtil) {
        this.jwtTokenUtil = jwtTokenUtil;
    }


    /**
     * 功能描述: <br>查询当前用户可见菜单
     * 〈〉
     * @Param: [token]
     * @Return: [token]
     * @Author: zhouy
     * @Date: 2019-09-10 22:37
     */

    @Override
    public List<PlatformSysMenu> selectPlatformSysmenu(String token) {
        UserDetail userDetail = jwtTokenUtil.getUserFromToken(token);
        //获得用户信息
        PlatformPersonnel platformPersonnel = platformPersonnelMapper.findByUsername(userDetail.getUsername());
        int isAdmin = platformPersonnel.getIsadmin();

        PlatformSysMenuExample platformSysMenuExample = new PlatformSysMenuExample();
        List<PlatformSysMenu> allMenulist = platformSysMenuMapper.selectByExample(platformSysMenuExample);

        if(isAdmin==1){
            return this.makeTree(allMenulist,"0");
        }else{
//            List<PlatformSysMenu> platformRoleMenu = platformRoleMenuMapper.selectPlatformRoleMenu(platformPersonnel.getRole());
            List<String> names= new ArrayList<>();
            try{
                int intuser=platformPersonnel.getId();
                List<PlatformSysRole> idealist = platformSysRoleMapper.selectByUserId(intuser);

                for (int i=0;i<idealist.size();i++){
                    names.add(idealist.get(i).getId());
                }
            }catch (Exception ex){
                ex.printStackTrace();
            }
            List<PlatformSysMenu> platformRoleMenu = platformRoleMenuMapper.selectPlatformRoleListMenu(names);
            List<PlatformSysMenu> menuList = this.forEachToRoleMenu(allMenulist,platformRoleMenu);
            return  this.makeTree(menuList,"0");
        }
    }
    /**
     * 功能描述: <br>遍历可见菜单
     * 〈〉
     * @Param: []
     * @Return: []
     * @Author: zhouy
     * @Date: 2019-09-17 14:07
     */
    List<PlatformSysMenu> forEachToRoleMenu(List<PlatformSysMenu> allMenulist,List<PlatformSysMenu> platformRoleMenu) {
        List<PlatformSysMenu> menuList = new ArrayList<PlatformSysMenu>();
        List<PlatformSysMenu> findmenuList = new ArrayList<PlatformSysMenu>();
        if (platformRoleMenu != null) {
            allMenulist.forEach(a -> {
                platformRoleMenu.stream().forEach(s -> {
                    if (s.getId().equals(a.getId()) || s.getParentid().equals(a.getId())) {
                        menuList.add(a);
                    }
                });
            });
        }
        if (menuList != null) {
            for (int a = 0; a < menuList.size(); a++) {
                for (int s = 0; s < allMenulist.size(); s++) {
                    if (menuList.get(a).getParentid().equals(allMenulist.get(s).getId())) {
                        menuList.add(allMenulist.get(s));
                    }
                }
            }
        }
        findmenuList = removeDuplicateWithOrder(menuList);

        return  findmenuList;
    }
    // 删除ArrayList中重复元素，保持顺序
    public static List removeDuplicateWithOrder(List list) {
        Set set = new HashSet();
        List newList = new ArrayList();
        for (Iterator iter = list.iterator(); iter.hasNext();) {
            Object element = iter.next();
            if (set.add(element)){
                newList.add(element);
            }
        }
        list.clear();
        list.addAll(newList);
        return list;
    }
    /**
     * 功能描述: <br>查询所有菜单
     * 〈〉
     * @Param: []
     * @Return: []
     * @Author: zhouy
     * @Date: 2019-09-10 22:28
     */

    @Override
    public List<PlatformSysMenu> selectAllMenu() {
        PlatformSysMenuExample platformSysMenuExample = new PlatformSysMenuExample();
        List<PlatformSysMenu> list = platformSysMenuMapper.selectByExample(platformSysMenuExample);
        return this.makeTree(list,"0");
    }

    /**
     * 功能描述: <br>保存菜单信息
     * 〈〉
     * @Param: [platformSysMenu]
     * @Return: [platformSysMenu]
     * @Author: zhouy
     * @Date: 2019-09-10 23:23
     */

    @Override
    public void saveMenu(PlatformSysMenu platformSysMenu) {
        if(platformSysMenu!=null&& !EmptyUtilHelper.isEmpty(platformSysMenu.getId())){
            //更新
            PlatformSysMenuExample platformSysMenuExample =new PlatformSysMenuExample();
            platformSysMenuExample.createCriteria().andIdEqualTo(platformSysMenu.getId());
            platformSysMenuMapper.updateByExample(platformSysMenu,platformSysMenuExample);
        }else {
            //主键
            platformSysMenu.setId(StrUtil.makePramykey());
            platformSysMenuMapper.insert(platformSysMenu);
        }
    }

    /**
     * 功能描述: <br>树结构递归
     * 〈〉
     * @Param: [collect, treeMenuNode]
     * @Return: [collect, treeMenuNode]
     * @Author: zhouy
     * @Date: 2019-09-10 14:09
     */
    private void forEach(Map<String, List<PlatformSysMenu>> collect, PlatformSysMenu treeMenuNode) {
        List<PlatformSysMenu> treeMenuNodes = collect.get(treeMenuNode.getId());
        if(collect.get(treeMenuNode.getId())!=null){
            treeMenuNodes.stream().sorted(Comparator.comparing(PlatformSysMenu::getSort)).collect(Collectors.toList());
            treeMenuNode.setChildren(treeMenuNodes);
            treeMenuNode.getChildren().forEach(t->{
                forEach(collect,t);
            });
        }
    }
    /**
     * 功能描述: <br>树结构封装--
     * 〈〉
     * @Param: []
     * @Return: []
     * @Author: zhouy
     * @Date: 2019-09-10 22:35
     */

    private List<PlatformSysMenu> makeTree(List<PlatformSysMenu> list,String parentId){

        Map<String, List<PlatformSysMenu>> collect = list.stream().collect(Collectors.groupingBy(PlatformSysMenu::getParentid));
        //树形结构 肯定有一个根部，我的这个根部的就是parentId.euqal("0"),而且只有一个就get（"0"）
        List<PlatformSysMenu> treeMenuNode = collect.get("0")==null?collect.get(parentId):collect.get("0");
        if(treeMenuNode!=null&&treeMenuNode.size()>0){
            treeMenuNode.stream().forEach(item->{
                this.forEach(collect,item);
            });
        }
        return treeMenuNode;
    }

    /**
     * 功能描述: <br>根据ROLEID和MOUDELID查询按钮信息
     * 〈〉
     * @Param: [platformRoleMenu]
     * @Return: [platformRoleMenu]
     * @Author: zhouy
     * @Date: 2019-09-16 10:17
     */

    @Override
    public RoleFunctionDTO menuFunctions(PlatformRoleMenu platformRoleMenu){

        PlatformSysMenuExample platformSysMenuExample = new PlatformSysMenuExample();
        PlatformSysMenuExample.Criteria criteria =  platformSysMenuExample.createCriteria();
        criteria.andIdEqualTo(platformRoleMenu.getModuleid());
        List<PlatformSysMenu> list = platformSysMenuMapper.selectByExample(platformSysMenuExample);
        list = this.makeMenuChildren(list.get(0));
        //功能
        PlatformSysButtonExample platformSysButtonExample = new PlatformSysButtonExample();
        //权限
        PlatformRoleMenuExample platformRoleMenuExample = new PlatformRoleMenuExample();
        List<PlatformRoleMenu> rolelist =new ArrayList<PlatformRoleMenu>();
        if(list.size()>0){
            list.stream().forEach(s->{
                platformSysButtonExample.or().andModuleidEqualTo(s.getId());
                platformRoleMenuExample.or().andModuleidEqualTo(s.getId()).andRoleidEqualTo(platformRoleMenu.getRoleid());
            });
            //根据菜单id查询菜单信息
            List<PlatformSysButton> blist = platformSysButtonMapper.selectByExample(platformSysButtonExample);
            rolelist = platformRoleMenuMapper.selectByExample(platformRoleMenuExample);
            if (list!=null){
                for(PlatformSysMenu pmenu:list){
                    List<PlatformSysButton> functions= new ArrayList<PlatformSysButton>();
                    for(PlatformSysButton platformSysButton:blist){
                        if(pmenu.getId().equals(platformSysButton.getModuleid())){
                            functions.add(platformSysButton);
                        }
                    }
                    pmenu.setFunctions(functions);
                }
            }

        }

        return new RoleFunctionDTO(list,rolelist);
    }

    /*
     * 功能描述: <br>根据父节点构建子节点
     * 〈〉
     * @Param:
     * @Return:
     * @Author: zhouy
     * @Date: 2019-09-17 20:39
     */
    List<PlatformSysMenu> makeMenuChildren(PlatformSysMenu platformSysMenu){
        log.info("死循环测试。。。。。。。。。。。。");

        PlatformSysMenuExample platformSysMenuExample = new PlatformSysMenuExample();
        List<PlatformSysMenu> allMenulist = platformSysMenuMapper.selectByExample(platformSysMenuExample);
        //定义预返回集合
        List<PlatformSysMenu> menuList = new ArrayList<PlatformSysMenu>();
        class forEach{
            //递归处理子节点
            void forEachChildren(String parentId){
                allMenulist.stream().forEach(s->{
                    if(s.getParentid().equals(parentId)){
                        menuList.add(s);
                        forEachChildren(s.getId());
                    }
                });
            }
        }
        new forEach().forEachChildren(platformSysMenu.getId());
        //如果遍历子节点为空时说明当前节点即为子节点
        if(menuList.size()==0){
            menuList.add(platformSysMenu);
        }
        return menuList;
    }

}
