package com.metro.auth.platform.service;

import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageHelper;
import com.metro.auth.platform.domain.dto.TodoNumDTO;
import com.metro.auth.platform.domain.entity.Todo;
import com.metro.auth.platform.domain.entity.TodoExample;
import com.metro.auth.platform.mapper.TodoMapper;
import com.metro.auth.platform.utils.DateUtil;
import com.metro.auth.platform.utils.EmptyUtilHelper;
import com.metro.auth.platform.viewformat.DataDictClass;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;

import javax.annotation.Resource;
import java.util.List;
import java.util.UUID;

@Service
public class TodoService {
    @Resource
    private TodoMapper todoMapper;

    // 批量已读
    public Integer batchRead(@RequestBody TodoNumDTO todoNumDTO) throws Exception {
        if (null == todoNumDTO.getTodoIdList() || todoNumDTO.getTodoIdList().size() == 0) {
            throw new Exception("待办id不能为空");
        }
        return todoMapper.batchRead(todoNumDTO);
    }

    //一键已读
    public Integer oneClickRead(@RequestBody TodoNumDTO todoNumDTO) throws Exception {
        if (StringUtils.isEmpty(todoNumDTO.getAccount()) || StringUtils.isEmpty(todoNumDTO.getType())) {
            throw new Exception("员工工号，系统待办标识不能为空");
        }
        return todoMapper.oneClickRead(todoNumDTO);
    }

    public List<TodoNumDTO> countByaccount(String account){
        return todoMapper.countByaccount(account);
    }

    public List<Todo> getToDoList(String type , String account,String status){
        TodoExample example = new TodoExample();
        TodoExample.Criteria cr = example.createCriteria();
        if (!StringUtils.isEmpty(type)) {
            cr.andTypeEqualTo(type);
        }
        if (!StringUtils.isEmpty(account)) {
            cr.andAccountEqualTo(account);
        }
        if (!StringUtils.isEmpty(status)) {
            cr.andStatusEqualTo(status);
        }
        return todoMapper.selectByExample(example);
    }

    public int insert(Todo record){
        int r = 0;
        String account = record.getAccount();
        String buid = record.getBuid();
        if(EmptyUtilHelper.isEmpty(buid)){
            //当消息没有buid时候，给默认值处理避免不执行insert方法
            buid="no buidid";
        }

        Todo todo  =todoMapper.selectByAccountAndBuid(account,buid);
        if(todo==null){//避免重复
            record.setId(UUID.randomUUID().toString().replace("-",""));
            record.setStatus("0");
            record.setCtime(DateUtil.getCurTime());
            r=todoMapper.insert(record);

        }else if(DateUtil.compare_date_result(DateUtil.getCurTime(),todo.getCtime())>60000){//30分钟
            record.setId(UUID.randomUUID().toString().replace("-",""));
            record.setStatus("0");
            record.setCtime(DateUtil.getCurTime());
            r=todoMapper.insert(record);
        }
        return r;
    }


    public int updatetodo(String buildid){
        Todo todo = new Todo();
        todo.setBuid(buildid);
        todo.setOptime(DateUtil.getCurTime());
        todo.setStatus("1");
       return todoMapper.updateByBuid(todo);
    }


    public int updateTodoById(String id){
        Todo todo = new Todo();
        todo.setId(id);
        todo.setOptime(DateUtil.getCurTime());
        todo.setStatus("1");
        return todoMapper.updateById(todo);
    }


    public List<Todo> queryTodoList(String status,String type, String account){return todoMapper.queryTodoList(status,type, account);}

}
