package com.metro.auth.platform.service;

import com.metro.auth.platform.domain.ResultCode;
import com.metro.auth.platform.domain.ResultJson;
import com.metro.auth.platform.domain.auth.PlatformApplications;
import com.metro.auth.platform.domain.auth.PlatformApplicationsGroup;
import com.metro.auth.platform.exception.CustomException;
import com.metro.auth.platform.mapper.PlatformApplicationsGroupMapper;
import com.metro.auth.platform.mapper.PlatformApplicationsMapper;
import com.metro.auth.platform.utils.DateUtil;
import com.metro.auth.platform.utils.StrUtil;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

@Service
public class PlatformApplicationsGroupServiceImpl implements PlatformApplicationsGroupService {

    @Resource
    private PlatformApplicationsGroupMapper platformApplicationsGroupMapper;
    @Resource
    private PlatformApplicationsMapper platformApplicationsMapper;

    @Override
    public int deleteByPrimaryKey(Integer id) {
        PlatformApplicationsGroup platformApplicationsGroup = selectByPrimaryKey(id);
        List<PlatformApplications> platformApplicationsList = platformApplicationsMapper.getPlatformApplicationsList();
      if (!CollectionUtils.isEmpty(platformApplicationsList) &&
              platformApplicationsList.stream().anyMatch(app -> platformApplicationsGroup.getGroupCode().equals(app.getGroupCode()))) {
            throw new CustomException(ResultJson.failure(ResultCode.BUSINESS_ERROR,"该分组下存在应用，不能删除！"));
      }
        return platformApplicationsGroupMapper.deleteByPrimaryKey(id);
    }

    @Override
    public int insert(PlatformApplicationsGroup record) {
        List<PlatformApplicationsGroup> platformApplicationsGroups = platformApplicationsGroupMapper.selectList(new PlatformApplicationsGroup());
        String newGroupCode;
        if (platformApplicationsGroups.isEmpty()) {
            newGroupCode = "GRP001";
            record.setSortIndex(1);
        } else {
            platformApplicationsGroups.sort((a, b) -> b.getGroupCode().compareTo(a.getGroupCode()));
            String maxGroupCode = platformApplicationsGroups.get(0).getGroupCode();
            int numericPart = Integer.parseInt(maxGroupCode.substring(3));
            newGroupCode = "GRP" + StrUtil.padLeftZeros(numericPart + 1, 3);
            record.setSortIndex(numericPart + 1);
        }
        record.setGroupCode(newGroupCode);
        record.setCreateTime(new Date());
        return platformApplicationsGroupMapper.insert(record);
    }

    @Override
    public int insertSelective(PlatformApplicationsGroup record) {
        return platformApplicationsGroupMapper.insertSelective(record);
    }

    @Override
    public PlatformApplicationsGroup selectByPrimaryKey(Integer id) {
        return platformApplicationsGroupMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<PlatformApplicationsGroup> selectList(PlatformApplicationsGroup record) {
        return platformApplicationsGroupMapper.selectList(record);
    }

    @Override
    public int updateByPrimaryKeySelective(PlatformApplicationsGroup record) {
        return platformApplicationsGroupMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public int updateByPrimaryKey(PlatformApplicationsGroup record) {
        return platformApplicationsGroupMapper.updateByPrimaryKey(record);
    }

    @Override
    public int batchUpdateByPrimaryKey(List<PlatformApplicationsGroup> list){
        return platformApplicationsGroupMapper.batchUpdateByPrimaryKey(list);
    }
}
