package com.metro.auth.platform.controller;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.domain.PageResult;
import com.metro.auth.platform.domain.ResultCode;
import com.metro.auth.platform.domain.ResultJson;
import com.metro.auth.platform.domain.auth.PlatformDepartment;
import com.metro.auth.platform.domain.auth.PlatformPersonnel;
import com.metro.auth.platform.domain.auth.PlatformSysRole;
import com.metro.auth.platform.domain.auth.User;
import com.metro.auth.platform.domain.dto.DepartmentPersonneDTO;
import com.metro.auth.platform.generallog.LogAnnotation;
import com.metro.auth.platform.service.PlatformPersonnelService;
import com.metro.auth.platform.utils.DateUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * @author jennifer
 */
@Slf4j
@RestController
@RequestMapping("/user")
@Api(tags = "人员相关接口")
public class PlatformPersonnelController {
    @Resource
    private PlatformPersonnelService platformPersonnelService;
    @Value("${jwt.header}")
    private String tokenHeader;
    /**
     * 功能描述: <br>获得所有用户信息
     * 〈〉
     * @Param: []
     * @Return: []
     * @Author: zhouy
     * @Date: 2019-09-11 18:43
     */
    public ResultJson getUserList(){

        List<PlatformPersonnel> list = platformPersonnelService.getUserList();
        return ResultJson.ok(list);
    }

    /**
     * 功能描述: <br>查询用户列表
     * 〈〉
     * @Param: [pageNum, pageSize, platformPersonnel]
     * @Return: [pageNum, pageSize, platformPersonnel]
     * @Author: zhouy
     * @Date: 2019-09-11 18:03
     */

    @GetMapping("/pagedlist")
    public ResultJson pagedlist(@RequestParam(required=true,value="pageNum",defaultValue="1") int pageNum,
                                @RequestParam(required=true,value="pageSize",defaultValue="15") int pageSize,
                                PlatformPersonnel platformPersonnel,HttpServletRequest request){
        String token = request.getHeader(tokenHeader);
        PageInfo<PlatformPersonnel> page =  platformPersonnelService.pagedlist(platformPersonnel,pageNum,pageSize,token);
        return ResultJson.ok(page);
    }

    @GetMapping("/pagedlistByToken")
    public ResultJson pagedlistByToken(@RequestParam(required=true,value="pageNum",defaultValue="1") int pageNum,
                                @RequestParam(required=true,value="pageSize",defaultValue="15") int pageSize,
                                PlatformPersonnel platformPersonnel,HttpServletRequest request){
        String token = request.getHeader(tokenHeader);
        PageInfo<PlatformPersonnel> page =  platformPersonnelService.pagedlistByToken(platformPersonnel,pageNum,pageSize,token);
        return ResultJson.ok(page);
    }

    /**
     * 功能描述: <br>删除用户
     * 〈〉
     * @Param: []
     * @Return: []
     * @Author: zhouy
     * @Date: 2019-09-11 18:05
     */
    @LogAnnotation(operateContent="人员管理",operateType="删除")
    @PostMapping("/del")
    public ResultJson delUser(String id){
        int count = platformPersonnelService.delUser(id);
        if(count>0){
            return ResultJson.ok();
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }

    /**
     * 功能描述: <br>批量删除用户
     * 〈〉
     * @Param: []
     * @Return: []
     * @Author: zhouy
     * @Date: 2019-09-11 18:05
     */
    @LogAnnotation(operateContent="人员管理",operateType="批量删除")
    @PostMapping("/batchdel/{ids}")
    public ResultJson delUsers(@PathVariable String ids){

        platformPersonnelService.delUsers(ids);

        //需对接企业微信接口
        return ResultJson.ok();
    }
    @LogAnnotation(operateContent="人员管理",operateType="更新状态")
    @PostMapping("/updateUsersStatus")
    public ResultJson updateUsersStatus(String ids,String status){
        platformPersonnelService.updateUsersStatus(status,ids);
        //需对接企业微信接口
        return ResultJson.ok();
    }
    /**
     * 功能描述: <br>保存
     * 〈〉
     * @Param: [platformPersonnel]
     * @Return: [platformPersonnel]
     * @Author: zhouy
     * @Date: 2019-09-11 18:24
     */
    @LogAnnotation(operateContent="人员管理",operateType="新增")
    @PostMapping("/save")
    public ResultJson saveUser(@RequestBody PlatformPersonnel platformPersonnel){
        int count = platformPersonnelService.savaUser(platformPersonnel);
        //需对接企业微信接口

        if(count>0){
            return ResultJson.ok();
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }

    /**
     * 功能描述: <br>保存-不更新密码
     * 〈〉
     * @Param: [platformPersonnel]
     * @Return: [platformPersonnel]
     * @Author: zhouy
     * @Date: 2019-09-11 18:24
     */
    @LogAnnotation(operateContent="人员管理",operateType="新增")
    @PostMapping("/savenopassword")
    public ResultJson savenopassword(@RequestBody PlatformPersonnel platformPersonnel){
            int count = platformPersonnelService.savenopassword(platformPersonnel);
            if(count>0){
            return ResultJson.ok();
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }
    @GetMapping("/weixin/list")
    public  ResultJson addwxuserinfo(){
            platformPersonnelService.getUserinfoListFromWeixin("1","1");
            return ResultJson.ok();

    }
    @GetMapping("/synchronousAvatar")
    public  ResultJson synchronousAvatar(){
        //用临时表与企业微信对比，返回对比结果
        PageInfo<PlatformPersonnel> pageInfo = platformPersonnelService.getPlatformPersonnelpagedlist_Weixin("1","1",1,1);
        List<PlatformPersonnel> list = pageInfo.getList();
        //如果有变更批量更新人员信息，并执行部门更新操作
        if(list!=null && list.size()>0){
            platformPersonnelService.updatePlatformpersonnel(list);
            log.info("手动同步微信人员信息"+ DateUtil.getCurTime());
            //记录更新时间

        }else{
            platformPersonnelService.insertWeixinUserUpdateInfo();
            log.info("本次无信息更新");
        }


        //批量更新人员部门
        //        platformPersonnelService.synchronousAvatar();
        return ResultJson.ok();

    }

    @GetMapping("/getDeltetList")
    public  ResultJson getDeltetList(){
        //用临时表与企业微信对比，返回对比结果
        PageInfo<PlatformPersonnel> pageInfo = platformPersonnelService.getPlatformPersonnelpagedlist_WeixinDelete("1","1",1,1);
        List<PlatformPersonnel> list = pageInfo.getList();
        //如果有变更批量更新人员信息，并执行部门更新操作
        if(list!=null && list.size()>0){
            //处理异常用户
            platformPersonnelService.updatePlatformpersonnel_del(list);
            log.info("筛查异常账户信息"+ DateUtil.getCurTime());
            //记录更新时间

        }else{
//            platformPersonnelService.insertWeixinUserUpdateInfo();
//            log.info("本次无信息更新");
        }


        //批量更新人员部门
        //        platformPersonnelService.synchronousAvatar();
        return ResultJson.ok();

    }
    @GetMapping("/synchronousDept")
    public  ResultJson synchronousDept(){
        //批量更新人员部门
                platformPersonnelService.synchronousAvatar();
        return ResultJson.ok();

    }

    /**
     * 同步微信新增人员
     * @return
     */
    @GetMapping("/synchronousPersonal")
    public  ResultJson synchronousPersonal(){
        platformPersonnelService.getUserinfoListFromWeixin("1","1");
        return ResultJson.ok();

    }
    @GetMapping("/getPlatformPersonnelBybirthday")
    public  ResultJson getPlatformPersonnelBybirthday(){

        List<PlatformPersonnel> list = platformPersonnelService.getPlatformPersonnelBybirthday();
        return ResultJson.ok(list);
    }

    /**
     * 拉取微信信息到本地
     * @param userid
     * @param request
     * @return
     */
    @PostMapping("/updateWxPlatformPersonnelByUserid")
    public  ResultJson getWxPlatformPersonnelByUserid(String userid,HttpServletRequest request){
        return ResultJson.ok(platformPersonnelService.updateUserinfoByUserid(userid, null));
    }

    @PostMapping("/updateWxPlatformPersonnelByAccount")
    public  ResultJson updateWxPlatformPersonnelByAccount(String account, HttpServletRequest request){

        PlatformPersonnel personal = platformPersonnelService.selectByAccount(account);
        if(personal!=null){
            return ResultJson.ok(platformPersonnelService.updateUserinfoByUserid(personal.getId().toString(), null));
        }
        return null;
    }

    /**
     * 密码修改：验证原始密码准确性
     */
    @GetMapping("/checkpassword")
    public  ResultJson checkpassword(String password,HttpServletRequest request){
        String token = request.getHeader(tokenHeader);
        boolean flag=platformPersonnelService.checkpassword(password,token);
        return  ResultJson.ok(flag);
    }
    /**
     * 保存新密码
     */
    @PostMapping("/updatepassword")
    public  ResultJson updatepassword(String password,HttpServletRequest request){
        String token = request.getHeader(tokenHeader);
        boolean flag=platformPersonnelService.updatepassword(password,token);
        return  ResultJson.ok(flag);
    }
    /**
     * 重置密码synchronousAvatar
     */
    @PostMapping("/resetPassword")
    public  ResultJson updatepassword(String id){
        boolean flag=platformPersonnelService.updatePasswordByUserid("!QAZ2wsx#EDC2022",id);
        return  ResultJson.ok(flag);
    }
    /**
     * 保存新密码
     */
    @PostMapping("/updatepasswordpc")
    public  ResultJson updatepasswordpc(@RequestBody PlatformPersonnel platformPersonnel,HttpServletRequest request){
        String token = request.getHeader(tokenHeader);
        boolean flag=platformPersonnelService.updatepassword(platformPersonnel.getPassword(),token);
        return  ResultJson.ok(flag);
    }
    /**
     * 批量同步微信信息
     */
    @GetMapping("getweixinisleaderindeptByaccount")
    public  ResultJson getweixinisleaderindeptByaccount(){
        boolean flag=platformPersonnelService.getweixinisleaderindeptByaccount();
        return  ResultJson.ok(flag);
    }
    /**
     * 批量生成所属部门和负责部门关系表
     */
    @GetMapping("getUserDepartmentStatus")
    public  ResultJson getUserDepartmentStatus(){
      platformPersonnelService. getUserDepartmentStatus();
        return  ResultJson.ok();
    }

//    @GetMapping("/dept_all")
//    public ResultJson<DepartmentPersonneDTO> getDepartmentPersonneDTO2(){
//        DepartmentPersonneDTO entity = platformPersonnelService.getDepartmentPersonneDTO2("");
//        return ResultJson.ok(entity);
//    }

    /**
     * zhouhaifeng 20200307 组织人员树
     * @return
     */
    @GetMapping(value = "/view_deptall")
    public ResultJson<DepartmentPersonneDTO> getDepartmentPersonneDTO(){
        DepartmentPersonneDTO entity = platformPersonnelService.getDepartmentPersonneDTO();
        return ResultJson.ok(entity);
    }

    /**
     * @周海峰
     * 本地和微信比较
     * @param pageNum
     * @param pageSize
     * @param platformPersonnel
     * @param request
     * @return
     */
    @GetMapping("/pagedlist_weixin")
    public ResultJson getPlatformPersonnelpagedlist_Weixin(
            @RequestParam(required=true,value="pageNum",defaultValue="1") int pageNum,
            @RequestParam(required=true,value="pageSize",defaultValue="15") int pageSize,
            PlatformPersonnel platformPersonnel,HttpServletRequest request){
        PageInfo<PlatformPersonnel> page =  platformPersonnelService.
                getPlatformPersonnelpagedlist_Weixin(platformPersonnel.getDepartmentid(),"0",pageNum,pageSize);
        return ResultJson.ok(page);
    }

    /**
     * zhf
     * 根据同微信的对比，去更新用户活新增用户
     * @param
     * @return
     */
    @PostMapping("/update_platformpersonnel")
    public ResultJson update_platformpersonnel(@RequestBody Map<String,List<PlatformPersonnel>> map){
        int flag =  platformPersonnelService.
                updatePlatformpersonnel(map.get("list"));
        return ResultJson.ok(flag);
    }

    /**
     * 批量更新头像为本地文件
     * @return
     */
    @ApiOperation(value = "更新头像", notes = "批量更新头像为本地文件")
    @ApiImplicitParams({@ApiImplicitParam(name = "Authorization", value = "Authorization token", required = true, dataType = "string", paramType = "header")})
    @PostMapping("/wixinAvatar2loaclFileBatch")
    public ResultJson wixinAvatar2loaclFileBatch(){
        platformPersonnelService.wixinAvatar2loaclFileBatch();
        return ResultJson.ok();
    }
    /**
     * 功能描述: 根据userid查询用户信息
     * wy
     * @Date: 2019-09-11 18:05
     */
    @GetMapping("/userinfo/{userid}")
    public ResultJson getPlatformPersonnelByUserid(@PathVariable String userid){
        PlatformPersonnel platformPersonnel= platformPersonnelService.getPlatformPersonnelByUserid(Integer.parseInt(userid));
        return ResultJson.ok(platformPersonnel);
    }

    /**
     * 批量更新更新中心
     * @return
     */
    @ApiOperation(value = "更新中心", notes = "批量更新更新中心")
    @ApiImplicitParams({@ApiImplicitParam(name = "Authorization", value = "Authorization token", required = true, dataType = "string", paramType = "header")})
    @PostMapping("/updateMetroCenter")
    public ResultJson updateMetroCenter(){
        platformPersonnelService.updateMetroCenter();
        return ResultJson.ok();
    }


}
