package com.metro.auth.platform.generallog;

import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.domain.ResultCode;
import com.metro.auth.platform.domain.ResultJson;
import com.metro.auth.platform.domain.auth.SysLogInfo;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @ClassName: LogAddController
 * @Description: ${description}  
 * @Authror zhouy
 * @Date 2019-07-16 20:28
 */

@RestController
@RequestMapping("/requestlog")
public class LogAddController {

    @Resource
    public LogAddService logAddService;

    @GetMapping("/pagedlist")
    public ResultJson queryDataList( SysLogInfo logEntity, @RequestParam int pageIndex, @RequestParam int pageSize) {
        try{
            PageInfo<SysLogInfo> logList = logAddService.queryLogEntityPageList(logEntity,pageIndex,pageSize);
            return ResultJson.ok(logList);

        }catch(Exception e) {
            e.printStackTrace();
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }

}
