package com.metro.auth.platform.qyweixin.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.metro.auth.platform.config.BCryptMD5;
import com.metro.auth.platform.domain.auth.PlatformDepartment;
import com.metro.auth.platform.domain.auth.PlatformPersonnel;
import com.metro.auth.platform.domain.auth.PlatformSyncUserdepartLog;
import com.metro.auth.platform.domain.auth.PlatformSysUserRole;
import com.metro.auth.platform.domain.dto.*;
import com.metro.auth.platform.mapper.PlatformDepartmentMapper;
import com.metro.auth.platform.mapper.PlatformPersonnelMapper;
import com.metro.auth.platform.mapper.PlatformSyncUserdepartLogMapper;
import com.metro.auth.platform.mapper.PlatformSysUserRoleMapper;
import com.metro.auth.platform.qyweixin.model.AesException;
import com.metro.auth.platform.qyweixin.model.WXBizMsgCrypt;
import com.metro.auth.platform.service.PlatformDepartmentService;
import com.metro.auth.platform.service.PlatformPersonnelService;
import com.metro.auth.platform.utils.DateUtil;
import com.metro.auth.platform.utils.DownImageUtil;
import com.metro.auth.platform.utils.StrUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * className
 *
 * @Author: zhf
 * @Date: 2021-09-13
 * @Time: 15:40
 * @Description:
 */
@Service
@Slf4j
public class WeiXinCallBackService {
	@Resource
	private PlatformPersonnelService platformPersonnelService;
	@Resource
	private PlatformDepartmentService platformDepartmentService;
	@Resource
	private PlatformSyncUserdepartLogMapper platformSyncUserdepartLogMapper;
	@Resource
	private PlatformDepartmentMapper platformDepartmentMapper;
	@Resource
	private PlatformPersonnelMapper platformPersonnelMapper;
	@Resource
	private PlatformSysUserRoleMapper platformSysUserRoleMapper;

	// 检查当前部门是否更新  true：更新  false：不更新
	private boolean checkUpdateOffice(PlatformOfficeEntity obj, PlatformDepartment localOffice) {
		// 没有匹配到
		if (null == localOffice) {
			return false;
		}


		if (
				obj.getName().equals(localOffice.getName()) && // 部门名称
				obj.getParentId().equals(localOffice.getPid()) && // 父id
				obj.getLevel().toString().equals(localOffice.getLevel()) && // 级别
				!obj.getStatus().equals(localOffice.getStatus()) && // 部门状态
				this.checkSame(obj.getBranchCompanyId(), localOffice.getBranchCompanyId())
		) {
			return false;
		}

		return true;
	}




	/**
	 　* @description: 批量从微信同步部门数据
	 　* @param
	 　* @return
	 　* @author bajl
	 　* @date 2022/3/17 3:41 下午
	 　*/
	public Map batchSyncOfficeFromWecaht(List<PlatformOfficeEntity> thirdDepartList, Date ctime) {
		Map map = new HashMap();
		//查本地所有部门
		List<PlatformDepartment> localOfficeList = platformDepartmentService.getPlatformOfficeEntityAll();
		// 本地所有部门  key:部门主键   value:部门实体
		Map<String, PlatformDepartment> localOfficeMap = localOfficeList.stream().collect(Collectors.toMap(c->c.getId().toString(), Function.identity()));
		// 传入所有部门  key：部门主键  value：部门实体
		Map<String, PlatformOfficeEntity> wechatOfficeJsonMap = thirdDepartList.stream().collect(Collectors.toMap(c->c.getId(), Function.identity()));

		/*区分开新增修改删除，生成各自list*/
		// 过滤出新增的部门
		List<PlatformOfficeEntity> insertObjectList = thirdDepartList.stream().filter(c-> null == localOfficeMap.get(c.getId())).collect(Collectors.toList());
		// 过滤出被修改的部门
		List<PlatformOfficeEntity> updateObjectList = thirdDepartList.stream().filter(c-> checkUpdateOffice(c, localOfficeMap.get(c.getId()))).collect(Collectors.toList());
		// 过滤出被删除的部门    在本地没有找到的部门 并且 本地部门是启用状态
		List<Integer> deleteIdObjectList = localOfficeList.stream().filter(c-> null == wechatOfficeJsonMap.get(c.getId().toString()) && "1".equals(c.getStatus())).map(c->c.getId()).collect(Collectors.toList());
		// 日志
		List<PlatformSyncUserdepartLog> logList = new ArrayList<>();

		// 删除部门信息
		if(deleteIdObjectList.size()>0){
			// 被删除的从启用变为未启用
			platformDepartmentMapper.updatePlatformDepartmentStatusByPrimaryKeyFromweixinBatch(deleteIdObjectList, "0");

			// 获取日志
			this.setDepartDeleteLog(logList, deleteIdObjectList, localOfficeMap, ctime);

			log.info("====================office删除" + deleteIdObjectList.size() + "条");
		}

		// 新增部门信息
		if (insertObjectList.size() > 0) {
			for(PlatformOfficeEntity depart: insertObjectList) {
				if (!"离职隐藏".equals(depart.getName()) && !"开发测试".equals(depart.getName())) {
					PlatformDepartment platformDepartment = new PlatformDepartment();
					platformDepartment.setId(Integer.parseInt(depart.getId()));
					platformDepartment.setName(depart.getName());
					platformDepartment.setPid(depart.getParentId());
					platformDepartment.setNum(null == depart.getSort() ? "100000" : depart.getSort().toString());
					platformDepartment.setStatus("1");
					platformDepartment.setSynchronous("1");
					platformDepartment.setOrdernum(depart.getId());
					platformDepartment.setLevel(depart.getLevel().toString());
					platformDepartment.setAddtime(DateUtil.getCurTime());
					platformDepartment.setBranchCompanyId(depart.getBranchCompanyId());
					platformDepartmentMapper.insert(platformDepartment);
					// 获取日志
					this.setDepartInsertLog(logList, platformDepartment, ctime);
					log.info("====================新增部门" + System.currentTimeMillis());
				}
			}
		}
		// 修改部门信息
		if (updateObjectList.size() > 0) {
			for(PlatformOfficeEntity e: updateObjectList) {
				PlatformDepartment depart = JSONObject.parseObject(JSONObject.toJSONString(localOfficeMap.get(e.getId())), PlatformDepartment.class);
				depart.setId(Integer.parseInt(e.getId()));
				depart.setName(e.getName());
				depart.setLevel(e.getLevel().toString());
				depart.setPid(e.getParentId());
				depart.setStatus("1".equals(e.getStatus()) ? "0" : "1");
				depart.setSynchronous("1");
				depart.setBranchCompanyId(e.getBranchCompanyId());
				platformDepartmentMapper.updateByPrimaryKeyCheckNull(depart);

				// 获取日志
				this.setDepartUpdateLog(logList, localOfficeMap.get(e.getId()), depart, ctime);
				log.info("====================修改部门" + System.currentTimeMillis());
			}
		}

		// 保存日志
		if (logList.size() > 0) {
			try {
				platformSyncUserdepartLogMapper.insertBatch(logList);
			} catch (Exception e) {

			}
		}

		return map;
	}

	private void setDepartDeleteLog(List<PlatformSyncUserdepartLog> logList, List<Integer> deleteIdObjectList, Map<String, PlatformDepartment> localOfficeMap, Date ctime) {
		for(Integer id: deleteIdObjectList) {
			PlatformDepartment en = localOfficeMap.get(id.toString());
			PlatformSyncUserdepartLog log = new PlatformSyncUserdepartLog();
			log.setId(UUID.randomUUID().toString().replace("-",""));
			log.setSyncType("depart");
			log.setDoType("delete");
			log.setCode(en.getId().toString());
			log.setName(en.getName());
			log.setPreDataJson(JSONObject.toJSONString(en));
			log.setDelFlag("0");
			log.setCreateBy("1");
			log.setCreateTime(ctime);
			log.setWxCorpid("1");
			logList.add(log);
		}
	}
	private void setDepartInsertLog(List<PlatformSyncUserdepartLog> logList, PlatformDepartment platformDepartment, Date ctime) {
		PlatformSyncUserdepartLog log = new PlatformSyncUserdepartLog();
		log.setId(UUID.randomUUID().toString().replace("-",""));
		log.setSyncType("depart"); // 同步类型 1：用户  2：部门
		log.setDoType("insert"); // 操作类型 1：新增   2：修改   3：删除
		log.setCode(platformDepartment.getId().toString());
		log.setName(platformDepartment.getName());
		log.setPreDataJson(JSONObject.toJSONString(platformDepartment));
		log.setDelFlag("0");
		log.setCreateBy("1");
		log.setCreateTime(ctime);
		log.setWxCorpid("1");
		logList.add(log);
	}
	private void setDepartUpdateLog(List<PlatformSyncUserdepartLog> logList, PlatformDepartment preData, PlatformDepartment nextData, Date ctime) {
		PlatformSyncUserdepartLog log = new PlatformSyncUserdepartLog();
		log.setId(UUID.randomUUID().toString().replace("-",""));
		log.setSyncType("depart"); // 同步类型 1：用户  2：部门
		log.setDoType("update"); // 操作类型 1：新增   2：修改   3：删除
		log.setCode(preData.getId() + "");
		log.setName(preData.getName());
		log.setPreDataJson(JSONObject.toJSONString(preData));
		log.setNextDataJson(JSONObject.toJSONString(nextData));
		log.setDelFlag("0");
		log.setCreateBy("1");
		log.setCreateTime(ctime);
		log.setWxCorpid("1");
		logList.add(log);
	}

	// 检查当前人员是否更新  true：更新  false：不更新
	private boolean checkUpdateUser(PlatformUserEntity wechartObj, PlatformPersonnel localUser, Map<String, PlatformDepartment> localOfficeMap) {
		// 没有匹配到
		if (null == localUser) {
			return false;
		}


		PlatformPersonnel platformPersonnel = new PlatformPersonnel();
		// 部门、所属部门、主部门、中心id、中心名称 按照原有逻辑特殊处理
		setDepartCenterMainValue(wechartObj, localOfficeMap, platformPersonnel);


		// 开始判断相关数据是否有变化
		if (
						"0".equals(wechartObj.getDelFlag()) &&
						this.checkSame(localUser.getDepartment(), platformPersonnel.getDepartment()) && // 特殊处理 - 部门
						this.checkSame(localUser.getDepartmentname(), platformPersonnel.getDepartmentname()) && // 特殊处理 - 所属部门
						this.checkSame(localUser.getMetrocenterid(), platformPersonnel.getMetrocenterid()) && // 特殊处理 - 中心id
						this.checkSame(localUser.getMetrocentername(), platformPersonnel.getMetrocentername()) && // 特殊处理 - 中心名称
						this.checkSame(localUser.getMaindepartment(), platformPersonnel.getMaindepartment()) && // 特殊处理 - 主部门
						this.checkSame(localUser.getUsername(), wechartObj.getRealName()) && // 姓名
						this.checkSame(localUser.getSex(), wechartObj.getSex()) && // '性别 1男 2女
						this.checkSame(localUser.getBirthday(), wechartObj.getBirthday()) && // 生日
						this.checkSame(localUser.getAccount(), wechartObj.getStaffCode()) && // '工号
//						this.checkSame(localUser.getPassword(), wechartObj.getPassword()) && // 密码
						this.checkSame(localUser.getPhoneNumber(), wechartObj.getPhoneNumber()) && // 手机号码
						this.checkSame(localUser.getTelNumber(), wechartObj.getTelNumber()) && // 座机号码
						this.checkSame(localUser.getEmail(), wechartObj.getEmail()) && // '邮箱地址
						this.checkSame(localUser.getNickname(), wechartObj.getNickname()) && // 微信昵称
						this.checkSame(localUser.getAddress(), wechartObj.getAddress()) && // '地址
//						this.checkSame(localUser.getMobile(), wechartObj.getMobile()) && // 移动小号
//						this.checkSame(localUser.getTelecom(), wechartObj.getTelecom()) && // '电信小号
//						this.checkSame(localUser.getOffice(), wechartObj.getOffice()) && // 办公地点
						this.checkSame(localUser.getPosition(), wechartObj.getPosition()) && // 职务
						this.checkSame(localUser.getIdentity(), wechartObj.getIsleader()) && // 身份
//						this.checkSame(localUser.getRole(), wechartObj.getRole()) && // 角色
//						this.checkSame(localUser.getAddtime(), wechartObj.getAddtime()) && // '添加时间
//						this.checkSame(localUser.getCredit(), wechartObj.getCredit()) && // 信用分
//						this.checkSame(localUser.getPolitical(), wechartObj.getPolitical()) && // '政治面貌
//						this.checkSame(localUser.getAuth(), wechartObj.getAuth()) && // 角色权限
//						this.checkSame(localUser.getApp_id(), wechartObj.getApp_id()) && // 应用权限
//						this.checkSame(localUser.getPaizhu(), wechartObj.getPaizhu()) && //  NUL
//						this.checkSame(localUser.getFuze(), wechartObj.getFuze()) && // varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT '
//						this.checkSame(localUser.getFuzename(), wechartObj.getFuzename()) && // text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_c
//						this.checkSame(localUser.getIsadmin(), wechartObj.getIsadmin()) && // '是否为管理员
//						this.checkSame(localUser.getSynchronous(), wechartObj.getSynchronous()) && // '与企业微信同步0未同步1成功2失败
						!localUser.getStatus().equals(wechartObj.getStatus()) && // 启用状态0未启用1启用
						this.checkSame(localUser.getAvatar(), wechartObj.getAvatar()) && //
//						this.checkSame(localUser.getBirthdaypush(), wechartObj.getBirthdaypush()) && //  NUL
//						this.checkSame(localUser.getCode(), wechartObj.getCode()) && // 登录随机码
						this.checkSame(localUser.getOrdernum(), wechartObj.getSort()) && // 排序字段
						this.checkSame(localUser.getQrcode(), wechartObj.getQrcode()) && // 员工二维码地址 11.11
//						this.checkSame(localUser.getUpdatetime(), wechartObj.getUpdatetime()) && // 更新时间
						this.checkSame(localUser.getDelstatus(), wechartObj.getDelstatus()) && // '1微信不存在0正常
						this.checkSame(localUser.getBranchCompanyId(), wechartObj.getBranchCompanyId()) // 所属公司
		) {
			return false;
		}

		return true;
	}

	/**
	 * @Author wuchao
	 * @Description 部门、所属部门、主部门、中心id、中心名称 按照原有逻辑特殊处理
	 * @Date  2023-11-16
	 * @Param [wechartObj, localOfficeMap, platformPersonnel]
	 * @return void
	 **/
	private void setDepartCenterMainValue(PlatformUserEntity wechartObj, Map<String, PlatformDepartment> localOfficeMap, PlatformPersonnel platformPersonnel) {
		String officeId = wechartObj.getDepartId();
		if (StringUtils.isNotEmpty(officeId)) {
			platformPersonnel.setDepartment(wechartObj.getDepartId()); // 部门
			platformPersonnel.setDepartmentname(wechartObj.getDepartName()); // 所属部门
			platformPersonnel.setMaindepartment(wechartObj.getDepartId()); // '中心名称
		} else {
			platformPersonnel.setDepartment(nullToEmpty(wechartObj.getCenterId())); // 部门
			platformPersonnel.setDepartmentname(nullToEmpty(wechartObj.getCenterName())); // 所属部门
			platformPersonnel.setMaindepartment(nullToEmpty(wechartObj.getCenterId())); // '中心名称
		}

		// 默认为空
		platformPersonnel.setMetrocentername("");
		platformPersonnel.setMetrocenterid("");

		PlatformDepartment entity = localOfficeMap.get(platformPersonnel.getDepartment());
		if (entity != null) {
			//如果为pid=64 行政办公室   特殊处理
			if ("64".equals(entity.getPid())) {
				PlatformDepartment entity_parent = localOfficeMap.get(entity.getPid());
				platformPersonnel.setDepartment(entity_parent.getId().toString());
				platformPersonnel.setDepartmentname(entity_parent.getName());
				platformPersonnel.setMetrocenterid(entity_parent.getId().toString());
				platformPersonnel.setMetrocentername(entity_parent.getName());
			} else {
				PlatformDepartment entity_4 = localOfficeMap.get(entity.getPid());
				if ("2".equals(entity.getLevel())) {
					platformPersonnel.setMetrocentername(entity.getName());
					platformPersonnel.setMetrocenterid(String.valueOf(entity.getId()));
				} else if ("3".equals(entity.getLevel())) {
					PlatformDepartment entity_p = localOfficeMap.get(entity.getPid());
					if (entity_p != null) {
						platformPersonnel.setMetrocentername(entity_p.getName());
						platformPersonnel.setMetrocenterid(String.valueOf(entity_p.getId()));
					}
				} else if ("4".equals(entity.getLevel()) && entity_4 != null) {
					platformPersonnel.setDepartment(entity_4.getId().toString());
					platformPersonnel.setDepartmentname(entity_4.getName());
					PlatformDepartment entity_p = localOfficeMap.get(entity_4.getPid());
					if (entity_p != null) {
						platformPersonnel.setMetrocentername(entity_p.getName());
						platformPersonnel.setMetrocenterid(String.valueOf(entity_p.getId()));
					}
				} else if ("5".equals(entity.getLevel()) && entity_4 != null) {
					PlatformDepartment entity_5 = localOfficeMap.get(entity_4.getPid());
					platformPersonnel.setDepartment(entity_5.getId().toString());
					platformPersonnel.setDepartmentname(entity_5.getName());
					PlatformDepartment entity_p = localOfficeMap.get(entity_5.getPid());
					if (entity_p != null) {
						platformPersonnel.setMetrocentername(entity_p.getName());
						platformPersonnel.setMetrocenterid(String.valueOf(entity_p.getId()));
					}
				}
			}
		}
	}

	private PlatformOfficeEntity getOfficeById(Map<String, PlatformOfficeEntity> officeMap, String officeId, Integer level){
		PlatformOfficeEntity office = officeMap.get(officeId);
		if(office.getLevel().equals(level)){
			return office;
		}else{
			return getOfficeById(officeMap, office.getParentId(), level);
		}
	}

	private boolean checkSame(Object v1, Object v2) {
		String v3 = null == v1 ? "" : v1.toString();
		String v4 = null == v2 ? "" : v2.toString();
		return v3.equals(v4);
	}

	public Map batchSyncUserFromWecaht(List<PlatformUserEntity> thirdUserArray, Date ctime) {
		Map map = new HashMap();
		//查本地所有部门
		List<PlatformDepartment> localOfficeList = platformDepartmentService.getPlatformOfficeEntityAll();
		//查本地所有员工信息
		List<PlatformPersonnel> localUserList = platformPersonnelService.getPlatformUserEntityAll();
		// 本地所有部门  key:部门主键   value:部门实体
		Map<String, PlatformDepartment> localOfficeMap = localOfficeList.stream().collect(Collectors.toMap(c->c.getId().toString(), Function.identity()));
		// 本地所有人员  key:员工号   value:员工实体
		Map<String, PlatformPersonnel> localUserMap = localUserList.stream().collect(Collectors.toMap(c->c.getAccount().toLowerCase(), Function.identity()));
		// 传入所有人员  key：员工号  value：员工实体
		Map<String, PlatformUserEntity> wechatUserJsonMap = thirdUserArray.stream().collect(Collectors.toMap(c->c.getStaffCode().toLowerCase(), Function.identity()));

		// 过滤出新增的员工信息
		List<PlatformUserEntity> insertObjectList = thirdUserArray.stream().filter(c-> null == localUserMap.get(c.getStaffCode().toLowerCase())).collect(Collectors.toList());
		// 过滤出被修改的员工信息
		List<PlatformUserEntity> updateObjectList = thirdUserArray.stream().filter(c-> checkUpdateUser(c, localUserMap.get(c.getStaffCode().toLowerCase()), localOfficeMap)).collect(Collectors.toList());
		// 过滤出被删除的员工号
		List<String> deleteStaffCodeList = localUserList.stream().filter(c-> null == wechatUserJsonMap.get(c.getAccount().toLowerCase()) && "1".equals(c.getStatus())).map(c->c.getAccount()).collect(Collectors.toList());
		List<PlatformUserEntity> insertList = new ArrayList<>();
		List<PlatformUserEntity> updateList = new ArrayList<>();
		// 日志
		List<PlatformSyncUserdepartLog> logList = new ArrayList<>();

		//处理微信删除的数据
		if(deleteStaffCodeList.size()>0){
			platformPersonnelMapper.updateDelstatusByAccountBatch(deleteStaffCodeList);
			// 获取日志
			this.setUserDeleteLog(logList, deleteStaffCodeList, localUserMap , ctime);
			log.info("删除人" + System.currentTimeMillis());
		}
		// 新增人员信息
		if (insertObjectList.size() > 0) {
			for(PlatformUserEntity wechartObj: insertObjectList) {
				//1.根据工号创建基本账户
				PlatformPersonnel platformPersonnel=new PlatformPersonnel();
				platformPersonnel.setPassword(BCryptMD5.encode("SYdite@!QAZ2022"));
				platformPersonnel.setPaizhu("0");
				platformPersonnel.setStatus("0".equals(wechartObj.getStatus()) ? "1" : "0");
				platformPersonnel.setIsadmin(0);
				platformPersonnel.setId(Integer.parseInt(wechartObj.getId()));
				platformPersonnel.setSynchronous("1");
				platformPersonnel.setAddtime(DateUtil.smartFormat(new Date()));



				platformPersonnel.setUsername(wechartObj.getRealName()); // 姓名
				platformPersonnel.setSex(StringUtils.isEmpty(wechartObj.getSex()) ? null : Integer.parseInt(wechartObj.getSex())); // '性别 1男 2女
				platformPersonnel.setBirthday(wechartObj.getBirthday()); // 生日
				platformPersonnel.setAccount(wechartObj.getStaffCode()); // '工号
				platformPersonnel.setPhoneNumber(wechartObj.getPhoneNumber()); // 手机号码
				platformPersonnel.setTelNumber(wechartObj.getTelNumber()); // 座机号码
				platformPersonnel.setEmail(wechartObj.getEmail()); // '邮箱地址
				platformPersonnel.setNickname(wechartObj.getNickname()); // 微信昵称
				platformPersonnel.setAddress(wechartObj.getAddress()); // '地址
				platformPersonnel.setPosition(wechartObj.getPosition()); // 职务
				platformPersonnel.setIdentity(wechartObj.getIsleader()); // 身份
				platformPersonnel.setAvatar(wechartObj.getAvatar()); //
				platformPersonnel.setOrdernum(nullToEmpty(wechartObj.getSort())); // 排序字段
				platformPersonnel.setQrcode(wechartObj.getQrcode()); // 员工二维码地址 11.11
				platformPersonnel.setDelstatus(wechartObj.getDelstatus());
				platformPersonnel.setBranchCompanyId(wechartObj.getBranchCompanyId());

				// 部门、所属部门、主部门、中心id、中心名称 按照原有逻辑特殊处理
				setDepartCenterMainValue(wechartObj, localOfficeMap, platformPersonnel);

				//            platformPersonnel.setPassword(wechartObj.getPassword()); // 密码
//            platformPersonnel.setMobile(wechartObj.getMobile()); // 移动小号
//            platformPersonnel.setTelecom(wechartObj.getTelecom()); // '电信小号
//            platformPersonnel.setOffice(wechartObj.getOffice()); // 办公地点
//            platformPersonnel.setRole(wechartObj.getRole()); // 角色
//            platformPersonnel.setAddtime(wechartObj.getAddtime()); // '添加时间
//            platformPersonnel.setCredit(wechartObj.getCredit()); // 信用分
//            platformPersonnel.setPolitical(wechartObj.getPolitical()); // '政治面貌
//            platformPersonnel.setAuth(wechartObj.getAuth()); // 角色权限
//            platformPersonnel.setApp_id(wechartObj.getApp_id()); // 应用权限
//            platformPersonnel.setPaizhu(wechartObj.getPaizhu()); //  NUL
//            platformPersonnel.setFuze(wechartObj.getFuze()); // varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT '
//            platformPersonnel.setFuzename(wechartObj.getFuzename()); // text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_c
//            platformPersonnel.setIsadmin(wechartObj.getIsadmin()); // '是否为管理员
//            platformPersonnel.setSynchronous(wechartObj.getSynchronous()); // '与企业微信同步0未同步1成功2失败
//            platformPersonnel.setBirthdaypush(wechartObj.getBirthdaypush()); //  NUL
//            platformPersonnel.setCode(wechartObj.getCode()); // 登录随机码
//            platformPersonnel.setUpdatetime(wechartObj.getUpdatetime()); // 更新时间

				try {
					platformPersonnelMapper.insert(platformPersonnel);
				} catch (Exception e) {
					System.out.println("新增人员失败，新增人员实体：" + JSONObject.toJSONString(platformPersonnel));
				}


				//默认赋予新用户普通用户角色
				platformSysUserRoleMapper.insert(new PlatformSysUserRole(StrUtil.makePramykey(), Integer.parseInt(wechartObj.getId()), "1"));
				// 获取日志
				this.setUserInsertLog(logList, platformPersonnel, ctime);

				log.info("新增人" + System.currentTimeMillis());
			}
		}
		// 修改人员信息
		if (updateObjectList.size() > 0) {
			for(PlatformUserEntity wechartObj: updateObjectList) {
				PlatformPersonnel platformPersonnel = JSONObject.parseObject(JSONObject.toJSONString(localUserMap.get(wechartObj.getStaffCode().toLowerCase())), PlatformPersonnel.class);
				platformPersonnel.setStatus("0".equals(wechartObj.getStatus()) ? "1" : "0");
				platformPersonnel.setId(Integer.parseInt(wechartObj.getId()));
				platformPersonnel.setSynchronous("1");
				platformPersonnel.setAddtime(DateUtil.smartFormat(new Date()));
				platformPersonnel.setUsername(nullToEmpty(wechartObj.getRealName())); // 姓名
				platformPersonnel.setSex(StringUtils.isEmpty(wechartObj.getSex()) ? null : Integer.parseInt(wechartObj.getSex())); // '性别 1男 2女
				platformPersonnel.setBirthday(nullToEmpty(wechartObj.getBirthday())); // 生日
				platformPersonnel.setAccount(wechartObj.getStaffCode()); // '工号
				platformPersonnel.setPhoneNumber(nullToEmpty(wechartObj.getPhoneNumber())); // 手机号码
				platformPersonnel.setTelNumber(nullToEmpty(wechartObj.getTelNumber())); // 座机号码
				platformPersonnel.setEmail(nullToEmpty(wechartObj.getEmail())); // '邮箱地址
				platformPersonnel.setNickname(nullToEmpty(wechartObj.getNickname())); // 微信昵称
				platformPersonnel.setAddress(nullToEmpty(wechartObj.getAddress())); // '地址
				platformPersonnel.setPosition(nullToEmpty(wechartObj.getPosition())); // 职务
				platformPersonnel.setIdentity(nullToEmpty(wechartObj.getIsleader())); // 身份
				platformPersonnel.setAvatar(nullToEmpty(wechartObj.getAvatar())); //
				platformPersonnel.setOrdernum(StringUtils.isEmpty(wechartObj.getSort()) ? "100000" : wechartObj.getSort()); // 排序字段
				platformPersonnel.setQrcode(nullToEmpty(wechartObj.getQrcode())); // 员工二维码地址 11.11
				platformPersonnel.setDelstatus("0".equals(platformPersonnel.getStatus()) ? "1" : "0");
				platformPersonnel.setBranchCompanyId(wechartObj.getBranchCompanyId());

				// 部门、所属部门、主部门、中心id、中心名称 按照原有逻辑特殊处理
				setDepartCenterMainValue(wechartObj, localOfficeMap, platformPersonnel);

				platformPersonnelMapper.updateByPrimaryKeyCheckNull(platformPersonnel);

				// 保存日志
				this.setUserUpdateLog(logList,  localUserMap.get(wechartObj.getStaffCode().toLowerCase()), platformPersonnel, ctime);

				log.info("修改人" + System.currentTimeMillis());
			}

		}

		// 保存日志
		if (logList.size() > 0) {
			try {
				platformSyncUserdepartLogMapper.insertBatch(logList);
			} catch (Exception e) {

			}
		}

		return map;
	}

	private void setUserDeleteLog(List<PlatformSyncUserdepartLog> logList, List<String> deleteStaffCodeList, Map<String, PlatformPersonnel> localUserMap , Date ctime) {
		for(String id: deleteStaffCodeList) {
			PlatformPersonnel en = localUserMap.get(id.toLowerCase());
			PlatformSyncUserdepartLog log = new PlatformSyncUserdepartLog();
			log.setId(UUID.randomUUID().toString().replace("-",""));
			log.setSyncType("user");
			log.setDoType("delete");
			log.setCode(en.getAccount());
			log.setName(en.getUsername());
			log.setPreDataJson(JSONObject.toJSONString(en));
			log.setDelFlag("0");
			log.setCreateBy("1");
			log.setCreateTime(ctime);
			log.setWxCorpid("1");
			logList.add(log);
		}
	}
	private void setUserInsertLog(List<PlatformSyncUserdepartLog> logList, PlatformPersonnel platformPersonnel, Date ctime) {
		PlatformSyncUserdepartLog log = new PlatformSyncUserdepartLog();
		log.setId(UUID.randomUUID().toString().replace("-",""));
		log.setSyncType("user"); // 同步类型 1：用户  2：部门
		log.setDoType("insert"); // 操作类型 1：新增   2：修改   3：删除
		log.setCode(platformPersonnel.getAccount());
		log.setName(platformPersonnel.getUsername());
		log.setPreDataJson(JSONObject.toJSONString(platformPersonnel));
		log.setDelFlag("0");
		log.setCreateBy("1");
		log.setCreateTime(ctime);
		log.setWxCorpid("1");
		logList.add(log);
	}
	private void setUserUpdateLog(List<PlatformSyncUserdepartLog> logList, PlatformPersonnel preData, PlatformPersonnel nextData, Date ctime) {
		PlatformSyncUserdepartLog log = new PlatformSyncUserdepartLog();
		log.setId(UUID.randomUUID().toString().replace("-",""));
		log.setSyncType("user"); // 同步类型 1：用户  2：部门
		log.setDoType("update"); // 操作类型 1：新增   2：修改   3：删除
		log.setCode(preData.getAccount());
		log.setName(preData.getUsername());
		log.setPreDataJson(JSONObject.toJSONString(preData));
		log.setNextDataJson(JSONObject.toJSONString(nextData));
		log.setDelFlag("0");
		log.setCreateBy("1");
		log.setCreateTime(ctime);
		log.setWxCorpid("1");
		logList.add(log);
	}



	private String nullToEmpty(String str) {
		return null == str ? "" : str;
	}




	/**
	 * 处理企业微信的回调,企业
	 * @param request
	 * @param wxcpt
	 * @throws AesException
	 * @throws IOException
	 */
//	@Async
	public void callBackHandle(HttpServletRequest request, WXBizMsgCrypt wxcpt )throws AesException, IOException {

		String sReqData = request.getParameter("postData");
		System.out.println("----接收到的数据如下xmlString：---" + sReqData);
		if(StringUtils.isBlank(sReqData)){
			BufferedReader reader;
			reader = request.getReader();
			String line;
			String xmlString;
			StringBuilder inputString = new StringBuilder();
			while ((line = reader.readLine()) != null) {inputString.append(line);}
			xmlString = inputString.toString();
			request.getReader().close();
			sReqData =xmlString;
			System.out.println("----接收到的数据如下xmlString：---" + xmlString);
		}

		String branchCompanyId = request.getParameter("branchCompanyId");
		System.out.println("----接收到的数据如下branchCompanyId：---" + branchCompanyId);
		String sReqMsgSig = request.getParameter("msg_signature");
		System.out.println("----接收到的数据如下sReqMsgSig：---" + sReqMsgSig);
		String sReqTimeStamp =request.getParameter("timestamp");
		System.out.println("----接收到的数据如下sReqTimeStamp：---" + sReqTimeStamp);
		String sReqNonce = request.getParameter("nonce");
		System.out.println("----接收到的数据如下sReqNonce：---" + sReqNonce);
		// post请求的密文数据

		try {
			String sMsg = wxcpt.DecryptMsg(sReqMsgSig, sReqTimeStamp, sReqNonce, sReqData);
			System.out.println("after decrypt msg: " + sMsg);
			// TODO: 解析出明文xml标签的内容进行处理
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			DocumentBuilder db = dbf.newDocumentBuilder();
			StringReader sr = new StringReader(sMsg);
			InputSource is = new InputSource(sr);
			Document document = db.parse(is);
			Element root = document.getDocumentElement();
			NodeList nodelist2 = root.getElementsByTagName("ChangeType");
			String ChangeType = nodelist2.item(0).getTextContent();
			System.out.println("ChangeType：" + ChangeType);

			//ChangeType: update_user   delete_user  create_user
			//通讯录变更
			if (ChangeType.equals("create_user") || ChangeType.equals("delete_user") || ChangeType.equals("update_user")){
				NodeList nodelist1 = root.getElementsByTagName("UserID");
				NodeList nodelist3 = root.getElementsByTagName("NewUserID");

				String UserID = nodelist1.item(0).getTextContent();
				String NewUserID="";
				//   NewUserID  用户更换id
				if (nodelist3.getLength()>0){
					NewUserID = nodelist3.item(0).getTextContent();
				}
				System.out.println("NewUserID：" + NewUserID);
				System.out.println("UserID：" + UserID);

				// W 打头委外人员不同步
				if (UserID.startsWith("W") || UserID.startsWith("w") || NewUserID.startsWith("W") || NewUserID.startsWith("w")) {
					System.out.println("委外人员不同步， UserID：" + UserID + "  NewUserID: " + NewUserID);
				} else {
					String insertUserId = request.getParameter("insertUserId");
					platformPersonnelService.updatePlatformpersonnelFromweixin(UserID,NewUserID,ChangeType, Integer.parseInt(insertUserId), branchCompanyId);
				}
			}
			//部门变更
			if (ChangeType.equals("create_party") || ChangeType.equals("update_party") || ChangeType.equals("delete_party")){
				NodeList nodelist6 = root.getElementsByTagName("Id");
				NodeList nodelist7 = root.getElementsByTagName("Name");
				NodeList nodelist8 = root.getElementsByTagName("ParentId");
				String Id = nodelist6.item(0).getTextContent();
				String Name = "";
				String Pid="";
				//   NewUserID  用户更换ids
				if (nodelist7.getLength()>0){
					Name = nodelist7.item(0).getTextContent();
				}
				if (nodelist8.getLength()>0){
					Pid = nodelist8.item(0).getTextContent();
				}

				PlatformDepartment platformDepartment=new PlatformDepartment();
				platformDepartment.setId(Integer.parseInt(Id));
				platformDepartment.setName(Name);
				platformDepartment.setPid(Pid);
				platformDepartment.setAddtime(DateUtil.getCurTime());
				platformDepartmentService.updatePlatformDepartmentFromweixin(ChangeType,platformDepartment, branchCompanyId);
			}
			System.out.println("回调处理完成");
		} catch (Exception e) {
			e.printStackTrace();
		}

	}
}
