package com.metro.auth.platform.service;

import com.metro.auth.platform.domain.auth.*;
import com.metro.auth.platform.mapper.*;
import com.metro.auth.platform.utils.EmptyUtilHelper;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * 登陆身份认证
 * @author: zhouy
 * createAt: 2019/8/1
 */
@Component(value="CustomUserDetailsService")
public class CustomUserDetailsServiceImpl implements UserDetailsService {

    private final AuthMapper authMapper;
    private final PlatformPersonnelMapper platformPersonnelMapper;
    private final PlatformRoleMenuMapper platformRoleMenuMapper;
    private final PlatformSysButtonMapper platformSysButtonMapper;
    private final PlatformSysMenuMapper platformSysMenuMapper;

    public CustomUserDetailsServiceImpl(AuthMapper authMapper, PlatformPersonnelMapper personnelMapper,
                                        PlatformRoleMenuMapper platformRoleMenuMapper,
                                        PlatformSysButtonMapper platformSysButtonMapper,
                                        PlatformSysMenuMapper platformSysMenuMapper) {
        this.authMapper = authMapper;
        this.platformPersonnelMapper = personnelMapper;
        this.platformRoleMenuMapper = platformRoleMenuMapper;
        this.platformSysButtonMapper = platformSysButtonMapper;
        this.platformSysMenuMapper = platformSysMenuMapper;
    }

    @Override
    public UserDetail loadUserByUsername(String account) throws UsernameNotFoundException {
        //此处后期集成redis
        PlatformPersonnel platformPersonnel = platformPersonnelMapper.findByUsername(account);
        UserDetail userDetail = new UserDetail(platformPersonnel.getId(),platformPersonnel.getAccount(),platformPersonnel.getPassword());
        if (userDetail == null) {
            throw new UsernameNotFoundException(String.format("No userDetail found with account '%s'.", account));
        }
        //查询角色信息
//        PlatformSysRole role = authMapper.findRoleByUserId(userDetail.getId());
//        PlatformRoleMenuExample example = new PlatformRoleMenuExample();
//        PlatformRoleMenuExample.Criteria criteria = example.createCriteria();
//        criteria.andRoleidEqualTo(role.getName());
//        criteria.andFunctionidIsNotNull();
//        userDetail.setRole(role);

        List<PlatformSysRole> rolelist = authMapper.findRolelistByUserId(userDetail.getId());
//        String roleidlist="";
//        for (int i=0;i<rolelist.size();i++){
//            if (i==0){
//                roleidlist=rolelist.get(i).getId();
//            }else{
//                roleidlist=roleidlist+","+rolelist.get(i).getId();
//            }
//
//        }
        //PlatformRoleMenuExample example = new PlatformRoleMenuExample();
        //PlatformRoleMenuExample.Criteria criteria = example.createCriteria();
        //criteria.andRoleidEqualTo(rolelist.get(0).getName());
        //criteria.andFunctionidIsNotNull();
        if(rolelist!=null&&rolelist.size()>0){
            userDetail.setRole(rolelist.get(0));
        }else{
            userDetail.setRole(PlatformSysRole.builder().id("1").name("ROLE_USER").namezh("普通用户").description("用户角色").build());
        }
        userDetail.setRolelist(rolelist);


        return userDetail;
    }

}
