package com.metro.auth.platform.service;

/**
 * .::::.
 * .::::::::.
 * :::::::::::    佛主保佑、永无Bug
 * ..:::::::::::'
 * '::::::::::::'
 * .::::::::::
 * '::::::::::::::..
 * ..::::::::::::.
 * ``::::::::::::::::
 * ::::``:::::::::'        .:::.
 * ::::'   ':::::'       .::::::::.
 * .::::'      ::::     .:::::::'::::.
 * .:::'       :::::  .:::::::::' ':::::.
 * .::'        :::::.:::::::::'      ':::::.
 * .::'         ::::::::::::::'         ``::::.
 * ...:::           ::::::::::::'              ``::.
 * ```` ':.          ':::::::::'                  ::::..
 * '.:::::'                    ':'````..
 */

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.domain.auth.PlatformSysButton;
import com.metro.auth.platform.domain.auth.PlatformSysButtonExample;
import com.metro.auth.platform.domain.auth.PlatformSysRoleExample;
import com.metro.auth.platform.mapper.PlatformSysButtonMapper;
import com.metro.auth.platform.utils.EmptyUtilHelper;
import com.metro.auth.platform.utils.StrUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

/**
 * @ClassName: PlatfromButtonServiceImpl
 * @Description: ${description}  
 * @Authror zhouy
 * @Date 2019-09-12 17:29
 */

@Service
public class PlatformButtonServiceImpl implements PlatformButtonService{

    @Resource
    PlatformSysButtonMapper platformSysButtonMapper;


    @Override
    public PageInfo<PlatformSysButton> pageButtonslist(PlatformSysButton platformSysButton, int pageNum, int pageSize) {
        PageHelper.startPage(pageNum, pageSize);
        PlatformSysButtonExample platformSysButtonExample =new PlatformSysButtonExample();
        PlatformSysButtonExample.Criteria criteria = platformSysButtonExample.createCriteria();
        if(platformSysButton!=null){
            if(!EmptyUtilHelper.isEmpty(platformSysButton.getModule())){
                criteria.andModuleLike("%"+platformSysButton.getModule()+"%");
            }
            if(!EmptyUtilHelper.isEmpty(platformSysButton.getName())){
                criteria.andNameLike("%"+platformSysButton.getName()+"%");

            }
            if(!EmptyUtilHelper.isEmpty(platformSysButton.getCode())){
                criteria.andCodeEqualTo(platformSysButton.getCode());
            }
        }
        List<PlatformSysButton> list = platformSysButtonMapper.selectByExample(platformSysButtonExample);

        PageInfo<PlatformSysButton> pageInfo = new PageInfo<>(list);
        return pageInfo;
    }

    @Override
    public List<PlatformSysButton> Buttonslist(PlatformSysButton platformSysButton) {
        PlatformSysButtonExample platformSysButtonExample =new PlatformSysButtonExample();
        List<PlatformSysButton> list = platformSysButtonMapper.selectByExample(platformSysButtonExample);
        return list;
    }

    @Override
    public int delButton(String id) {
        int count = 0;
        count = platformSysButtonMapper.deleteByPrimaryKey(id);
        return count;
    }

    @Override
    public void delButtons(String ids) {
        String[] id = ids.split(",");
        Arrays.stream(id).forEach(t->{
            platformSysButtonMapper.deleteByPrimaryKey(t);
        });
    }

    @Override
    public int saveButtons(PlatformSysButton platformSysButton) {

        int count =0;
        if(platformSysButton!=null&& !EmptyUtilHelper.isEmpty(platformSysButton.getId())){
            //更新
            PlatformSysButtonExample platformSysButtonExample =new PlatformSysButtonExample();
            platformSysButtonExample.createCriteria().andIdEqualTo(platformSysButton.getId());
            count =platformSysButtonMapper.updateByExample(platformSysButton,platformSysButtonExample);
        }else {
            //主键
            platformSysButton.setId(StrUtil.makePramykey());
            count =platformSysButtonMapper.insert(platformSysButton);
        }
        return count;
    }
}
