package com.metro.auth.platform.service;

import com.metro.auth.platform.domain.auth.PlatformUserFavoriteApps;
import com.metro.auth.platform.mapper.PlatformUserFavoriteAppsMapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * 用户常用应用Service实现类
 */
@Service
public class PlatformUserFavoriteAppsServiceImpl implements PlatformUserFavoriteAppsService {

    @Resource
    private PlatformUserFavoriteAppsMapper platformUserFavoriteAppsMapper;

    @Override
    public List<PlatformUserFavoriteApps> getFavoriteAppsByUserId(String userId) {
        return platformUserFavoriteAppsMapper.getFavoriteAppsByUserId(userId);
    }

    @Override
    public List<PlatformUserFavoriteApps> getUnfavoriteApps(String userId, String keyword) {
        return platformUserFavoriteAppsMapper.getUnfavoriteApps(userId, keyword);
    }

    @Override
    public boolean addFavoriteApp(String userId, Integer appId, Integer sortOrder) {
        try {
            // 检查是否已存在
            PlatformUserFavoriteApps existing = platformUserFavoriteAppsMapper.getFavoriteApp(userId, appId);
            if (existing != null) {
                return false; // 已存在
            }
            
            // 设置默认排序值
            if (sortOrder == null) {
                sortOrder = 0;
            }
            
            PlatformUserFavoriteApps favoriteApp = new PlatformUserFavoriteApps();
            favoriteApp.setUserId(userId);
            favoriteApp.setAppId(appId);
            favoriteApp.setSortOrder(sortOrder);
            
            int result = platformUserFavoriteAppsMapper.insertFavoriteApp(favoriteApp);
            return result > 0;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean removeFavoriteApp(String userId, Integer appId) {
        try {
            int result = platformUserFavoriteAppsMapper.deleteFavoriteApp(userId, appId);
            return result > 0;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean updateFavoriteSort(String userId, Integer appId, Integer sortOrder) {
        try {
            int result = platformUserFavoriteAppsMapper.updateSortOrder(userId, appId, sortOrder);
            return result > 0;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}
