package com.metro.auth.platform.qyweixin.Controller;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.metro.auth.platform.domain.dto.PlatformUserEntity;
import com.metro.auth.platform.domain.dto.UserDepartDTO;
import com.metro.auth.platform.http.HttpAPIService;
import com.metro.auth.platform.outlineapi.PlatformUrlManager;
import com.metro.auth.platform.qyweixin.model.AesException;
import com.metro.auth.platform.qyweixin.model.WXBizMsgCrypt;
import com.metro.auth.platform.qyweixin.model.WxRefundNotifyResult;
import com.metro.auth.platform.qyweixin.service.WeiXinCallBackService;
import com.metro.auth.platform.utils.*;
import com.metro.auth.platform.wxmessage.ApiConfig;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.*;
import java.util.stream.Collectors;

@Controller
@RequestMapping("/qweixincallback")
@Slf4j
public class WeiXinCallBackController {
    @Resource
    private WeiXinCallBackService weiXinCallBackService;
    @Resource
    public Platform3Util platform3Util;
    /**
     * 接收企业微信回调
     * @param request
     */
    @ResponseBody
    @RequestMapping("/checkurl")
    public String request(HttpServletRequest request) throws AesException, IOException {
        String sToken = SpringUtil.getBean(PlatformUrlManager.class).getPlatformURI(PlatformUrlManager.WX_sToken);
        String sCorpID =SpringUtil.getBean(PlatformUrlManager.class).getPlatformURI(PlatformUrlManager.WX_sCorpID);
        String sEncodingAESKey =SpringUtil.getBean(PlatformUrlManager.class).getPlatformURI(PlatformUrlManager.WX_sEncodingAESKey);
        WXBizMsgCrypt wxcpt = new WXBizMsgCrypt(sToken, sEncodingAESKey, sCorpID);
        String sVerifyMsgSig = request.getParameter("msg_signature");
        String sVerifyTimeStamp = request.getParameter("timestamp");
        String sVerifyNonce = request.getParameter("nonce");
        String sVerifyEchoStr = request.getParameter("echostr");
        String sEchoStr; //需要返回的明文
        //异步处理业务
        weiXinCallBackService.callBackHandle(request,wxcpt);
        // 验证URL成功，将sEchoStr返回。
        return wxcpt.VerifyURL(sVerifyMsgSig, sVerifyTimeStamp,
                sVerifyNonce, sVerifyEchoStr);

    }

    /**
     * 接收三期平台同步用户数据回调
     * @param request
     */
    @ResponseBody
    @RequestMapping("/syncUserDepart")
    public String syncUserDepart(HttpServletRequest request) throws AesException, IOException {
        String sToken = SpringUtil.getBean(PlatformUrlManager.class).getPlatformURI(PlatformUrlManager.WX_sToken);
        String sCorpID =SpringUtil.getBean(PlatformUrlManager.class).getPlatformURI(PlatformUrlManager.WX_sCorpID);
        String sEncodingAESKey =SpringUtil.getBean(PlatformUrlManager.class).getPlatformURI(PlatformUrlManager.WX_sEncodingAESKey);
        WXBizMsgCrypt wxcpt = new WXBizMsgCrypt(sToken, sEncodingAESKey, sCorpID);
        String sVerifyMsgSig = request.getParameter("msg_signature");
        String sVerifyTimeStamp = request.getParameter("timestamp");
        String sVerifyNonce = request.getParameter("nonce");
        String sReqData = request.getParameter("postData");
        String sEchoStr; //需要返回的明文
        //异步处理业务
        weiXinCallBackService.callBackHandle(request,wxcpt);
        return "ok";
    }




    /**
     * @Author wuchao
     * @Description 接收三期平台部门、用户批量同步
     * @Date  2023-11-13
     * @Param [request, userDepartDTO]
     * @return java.lang.String
     **/
    @PostMapping("/syncUserDepartBath")
    @Transactional
    public String syncUserDepartBath() throws AesException, IOException {


        Date ctime = new Date();
        log.info("开始更新部门、人员信息");
        JSONObject source = platform3Util.getDepartUserAll();
        if (null == source || null == source.get("code") || !"1".equals(source.getString("code"))) {
            throw new RuntimeException("三期平台数据拉取失败");
        }
        UserDepartDTO userDepartDTO = JSONObject.parseObject(JSONObject.toJSONString(source.get("data")), UserDepartDTO.class);

        // 批量新增、更新、删除部门信息
        if (userDepartDTO.getDepartList().size() > 0) {
            weiXinCallBackService.batchSyncOfficeFromWecaht(userDepartDTO.getDepartList(), ctime);
        }
        // 批量新增、更新、删除人员信息
        // 过滤掉委外人员
        userDepartDTO.setUserList(userDepartDTO.getUserList().stream().filter(c->checkUser(c)).collect(Collectors.toList()));
        if (userDepartDTO.getUserList().size() > 0) {
            weiXinCallBackService.batchSyncUserFromWecaht(userDepartDTO.getUserList(), ctime);
        }
        System.out.println("批量同步人员、部门信息完成");
        return "ok";
    }


    //
    private static boolean checkUser(PlatformUserEntity user) {
        if (null == user) {
            return false;
        }
        String staffCode = user.getStaffCode().toLowerCase();
        if (staffCode.startsWith("w")) {
            if (staffCode.length() > 1) {
                String second =staffCode.substring(1, 2);
                if (second.matches(("\\d+")) && "outside".equals(user.getUserType())) {
                    return false;
                }
            } else if("outside".equals(user.getUserType())) {
                return false;
            }
        }

        return true;
    }


    /**
     * 获取签名
     */
    public String getSign(Map<Object, Object> map) {
        SortedMap<Object, Object> signParams = new TreeMap<>();
        for (Map.Entry<Object, Object> stringStringEntry : map.entrySet()) {
            signParams.put(stringStringEntry.getKey(), stringStringEntry.getValue());
        }
        signParams.remove("sign");
        return WXSignUtils.createSign("UTF-8", signParams);
    }

    private String returnXML(String return_code) {
        return "<xml><return_code><![CDATA["
                + return_code
                + "]]></return_code><return_msg><![CDATA[OK]]></return_msg></xml>";
    }

    public WxRefundNotifyResult wxRefundResultNotify(String responseXml){
        WxRefundNotifyResult wxRefundResult = JdomParseXmlUtils.getWxRefundNotifyResult(responseXml);
        if("SUCCESS".equals(wxRefundResult.getReturn_code())){
            try {
                String info= AESUtil.decryptData(wxRefundResult.getReq_info(),WXSignUtils.Key);
                log.info("解密后的退款通知"+info);
                WxRefundNotifyResult wxRefundResult2 = JdomParseXmlUtils.getWxRefundNotifyResult(info);
                String refundstatus = wxRefundResult2.getRefund_status();
                wxRefundResult.setRefund_status(refundstatus);
                wxRefundResult.setOut_refund_no(wxRefundResult2.getOut_refund_no());
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return wxRefundResult;
    }

}
