package com.metro.auth.platform.viewformat;

import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.domain.auth.SysCodelist;
import com.metro.auth.platform.mapper.SysCodelistMapper;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;


/**
 * 说明：数据字典切面类
 * Created by zhouy on 2019/07/215.
 */
@Aspect
@Component
public class DataDictAspect {

    /**
     * 非基本类型在 CLASS 中的定义
     */
    private static final String FILED_NAME_TYPE = "TYPE";
    @Resource
    private  SysCodelistMapper sysCodelistMapper;
    private final Map<String, String> dictInfoMap = new ConcurrentHashMap<>();

    @Pointcut("@annotation(dataDictClass)")
    public void doDataDictClass(DataDictClass dataDictClass) {
    }

    @Around("@annotation(dataDictClass)")
    public Object translation(final ProceedingJoinPoint pjp, DataDictClass dataDictClass) throws Throwable {
        PageInfo pagination = null;
        Object result = pjp.proceed();
        if (result == null) {
            return result;
        }else if(result instanceof PageInfo){
            pagination =  ((PageInfo) result);
            if(pagination.getList().size()==0){
                return pagination;
            }else{
                result = pagination.getList();
            }
        }

        Object obj;
        if (result instanceof List || result instanceof ArrayList) {
            List olist = ((List) result);
            if (olist.size() == 0) {
                return result;
            }
            obj = olist.get(0);
        } else {
            obj = result;
        }
        List<Map<String, String>> dictParams = boDict(obj.getClass());
        if (dictParams.size() == 0) {
            return result;
        }else{
            for (int i=0;i<dictParams.size();i++){

              //查询codelist dictParams.get(i).get("dict")
                SysCodelist codelist=new SysCodelist();
                codelist.setKindcode(dictParams.get(i).get("dict"));
                List<SysCodelist> dictInfos = sysCodelistMapper.selectByKindeCode(codelist);

                if (dictInfos == null && dictInfos.size() == 0) {
                    return result;
                }
                //先把字典值转成map
                for (SysCodelist sysCodelist : dictInfos) {
                    dictInfoMap.put(sysCodelist.getKindcode() + sysCodelist.getCodevalue(), sysCodelist.getCodename());
                }

                if (result instanceof List || result instanceof ArrayList) {
                    for (Object o : (List) result) {
                        sign(o, dictParams, dictInfoMap);
                    }
                } else {
                    sign(result, dictParams, dictInfoMap);
                }
            }
        }
        if(pagination!=null){
            pagination.setList((List)result);
            return  pagination;
        }else{
            return result;
        }
    }

    /**
     * 单个设置值
     *
     * @param obj
     * @param dictParams
     * @param dictInfoMap
     */
    public void sign(Object obj, List<Map<String, String>> dictParams, Map<String, String> dictInfoMap) {

        for (Map<String, String> dictParam : dictParams) {
            String dict = dictParam.get("dict");
            String source = dictParam.get("source");
            String dictName = dictParam.get("dictName");
            try {
                //获取源编码值
                String sourceValue = (String) BeanUtils.getBeanFieldValue(obj.getClass(), obj, source);
                String dictCodeName = dictInfoMap.get(dict + sourceValue);
                //设置值
                BeanUtils.setBeanField(obj.getClass(), obj, dictName, dictCodeName);
            } catch (Exception e) {
                e.printStackTrace();
            }

        }
    }

    /**
     * 获取bo中属性值
     *
     * @param cla
     * @return
     */
    private List<Map<String, String>> boDict(Class cla) {
        Field[] fields = cla.getDeclaredFields();
        List<Map<String, String>> list = new ArrayList<Map<String, String>>();
        Map<String, String> map;
        DataDict dataDict;
        for (Field field : fields) {
            if (field.isAnnotationPresent(DataDict.class)) {
                map = new HashMap<String, String>();
                dataDict = field.getAnnotation(DataDict.class);
                map.put("dict", dataDict.dict());
                map.put("source", dataDict.source());
                map.put("dictName", field.getName());
                list.add(map);
            }
        }
        return list;
    }

}