package com.metro.auth.platform.controller;

import com.metro.auth.platform.domain.ResultCode;
import com.metro.auth.platform.domain.ResultJson;
import com.metro.auth.platform.domain.auth.*;
import com.metro.auth.platform.generallog.LogAnnotation;
import com.metro.auth.platform.outlineapi.PlatformUrlManager;
import com.metro.auth.platform.service.AuthService;
import com.metro.auth.platform.service.HistoryTodayService;
import com.metro.auth.platform.utils.DateUtil;
import com.metro.auth.platform.utils.MailUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import java.util.Calendar;
import java.util.List;

/**
 * @author zhouy
 * createAt: 2019/8/1
 */
@Slf4j
@RestController
@Api(tags = "历史上的今天")
@RequestMapping("/history")
public class HistoryDayController {
    @Resource
    private  HistoryTodayService historyTodayService;
    /**
     * 查询历史上的今天
     */
    @GetMapping("/getoday")
    public ResultJson getoday(){
        Calendar a=Calendar.getInstance();
        int mothvalue=a.get(Calendar.MONTH)+1;
        int dayvalue=a.get(Calendar.DATE);
        String todayvalue=mothvalue+"月"+dayvalue+"日";
    return ResultJson.ok(todayvalue);
    }    /**
     * 查询历史上的今天
     */
    @GetMapping("/gethistorylist")
    public ResultJson gethistorylist(){
        List<HistoryToday> list= historyTodayService.getHistoryTodaylist();
        return ResultJson.ok(list);
    }

}
