package com.metro.auth.platform.controller;

import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.domain.ResultCode;
import com.metro.auth.platform.domain.ResultJson;
import com.metro.auth.platform.domain.auth.PlatformHoliday;
import com.metro.auth.platform.generallog.LogAnnotation;
import com.metro.auth.platform.service.PlatformHolidayService;
import com.metro.auth.platform.utils.DateUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

@RestController
@RequestMapping("/sysholiday")
public class PlatformHolidayController {
    @Value("${jwt.header}")
    private String tokenHeader;
    @Resource
    private PlatformHolidayService platformHolidayService;

    /**
     * 查询列表
     * @param pageNum
     * @param pageSize
     * @param platformHoliday
     * @return
     */
    @GetMapping("/pagedlist")
    public ResultJson pagedlist(@RequestParam(required=true,value="pageNum",defaultValue="1") int pageNum,
                                @RequestParam(required=true,value="pageSize",defaultValue="15") int pageSize,
                                PlatformHoliday platformHoliday, HttpServletRequest request){
        String token = request.getHeader(tokenHeader);
        PageInfo<PlatformHoliday> page =  platformHolidayService.pagedlist(platformHoliday,pageNum,pageSize);
        return ResultJson.ok(page);
    }

    /**
     * 根据id更新实体
     * @param platformHoliday
     * @return
     */
    @LogAnnotation(operateContent="节假日",operateType="更新")
    @PostMapping("/update")
    public  ResultJson update(@RequestBody PlatformHoliday platformHoliday){
        int flag=platformHolidayService.saveUpdatePlatformHoliday(platformHoliday);
        if (flag>0){
            return ResultJson.ok(ResultCode.SUCCESS);
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }
    /**
     * 根据id更新实体
     * @param platformDepartment
     * @return
     */
    @LogAnnotation(operateContent="节假日",operateType="新增")
    @PostMapping("/add")
    public  ResultJson add(@RequestBody PlatformHoliday platformDepartment){
        int flag=platformHolidayService.savePlatformHoliday(platformDepartment);
        if (flag>0){
            return ResultJson.ok(ResultCode.SUCCESS);
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }
    /**
     *根据id获取实体
     * @param id
     * @return
     */
    @GetMapping("/load")
    public  ResultJson load(@RequestParam(required = true,value = "id",defaultValue = "") String id){
        PlatformHoliday platformHoliday=platformHolidayService.load(id);
        if (platformHoliday!=null){
            return  ResultJson.ok(platformHoliday);
        }else {
            return  ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }
    /**
     *根据id删除实体
     * @param id
     * @return
     */
    @LogAnnotation(operateContent="节假日",operateType="删除")
    @PostMapping("/delete")
    public  ResultJson delete(@RequestParam(required = true,value = "id",defaultValue = "") String id){
        int flag=platformHolidayService.delPlatformHoliday(id);
        if (flag>0){
            return ResultJson.ok(ResultCode.SUCCESS);
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }

    /**
     * 根据id更新部门启停状态
     * @return
     */
    @LogAnnotation(operateContent="节假日",operateType="更新状态")
    @PostMapping("/updatestatus")
    public  ResultJson updatestatus(@RequestBody PlatformHoliday platformHoliday){
        int flag=platformHolidayService.updatePlatformHolidayStatusById(platformHoliday);
        if (flag>0){
            return ResultJson.ok(ResultCode.SUCCESS);
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }
    /**
     * 批量启停用
     * @param ids
     * @param status
     * @return
     */
    @LogAnnotation(operateContent="节假日",operateType="批量更新")
    @PostMapping("/updateHolidayStatus")
    public ResultJson updateHolidayStatus(String ids,String status){
        platformHolidayService.updateHolidayStatus(status,ids);
        return ResultJson.ok();
    }
    /**
     * 接口:查询当日节假日列表
     */
    @GetMapping("/getHolidayListByDatetime")
    public  ResultJson getHolidayListByTypeAndNum(){
        PlatformHoliday platformHoliday=new PlatformHoliday();
        platformHoliday.setDatetime(DateUtil.getCurTimeByFormatter("yyyy-MM-dd"));
        List<PlatformHoliday> list=platformHolidayService.selectByExample(platformHoliday);
        return  ResultJson.ok(list);
    }
}
