package com.metro.auth.platform.service;

/**
 * .::::.
 * .::::::::.
 * :::::::::::    佛主保佑、永无Bug
 * ..:::::::::::'
 * '::::::::::::'
 * .::::::::::
 * '::::::::::::::..
 * ..::::::::::::.
 * ``::::::::::::::::
 * ::::``:::::::::'        .:::.
 * ::::'   ':::::'       .::::::::.
 * .::::'      ::::     .:::::::'::::.
 * .:::'       :::::  .:::::::::' ':::::.
 * .::'        :::::.:::::::::'      ':::::.
 * .::'         ::::::::::::::'         ``::::.
 * ...:::           ::::::::::::'              ``::.
 * ```` ':.          ':::::::::'                  ::::..
 * '.:::::'                    ':'````..
 */

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.domain.ResultJson;
import com.metro.auth.platform.domain.auth.PlatformIntranets;
import com.metro.auth.platform.domain.auth.PlatformIntranetsExample;
import com.metro.auth.platform.mapper.PlatformIntranetsMapper;
import com.metro.auth.platform.utils.DateUtil;
import com.metro.auth.platform.utils.EmptyUtilHelper;
import com.metro.auth.platform.utils.StrUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * @ClassName: PlatformIntranetsImpl
 * @Description: ${description}  
 * @Authror zhouy
 * @Date 2019-09-29 15:16
 */
@Service
public class PlatformIntranetsServiceImpl implements PlatformIntranetsService {

    @Resource
    private PlatformIntranetsMapper platformIntranetsMapper;

    @Override
    public PageInfo<PlatformIntranets> pagedlist(PlatformIntranets platformIntranets, int pageNum, int pageSize) {
        PageHelper.startPage(pageNum, pageSize);
        PlatformIntranetsExample platformIntranetsExample = new PlatformIntranetsExample();
        PlatformIntranetsExample.Criteria criteria = platformIntranetsExample.createCriteria();

        List<PlatformIntranets> list = platformIntranetsMapper.selectByExample(platformIntranetsExample);
        PageInfo<PlatformIntranets> pageInfo = new PageInfo<PlatformIntranets>(list);
        return pageInfo;
    }

    @Override
    public PlatformIntranets newsdetail(String id) {
        return platformIntranetsMapper.selectByPrimaryKey(id);
    }

    @Override
    public int savenewsdetail(PlatformIntranets platformIntranets) {
        if(platformIntranets!=null&&!EmptyUtilHelper.isEmpty(platformIntranets.getId())){

            platformIntranets.setUpdateddate(DateUtil.getCurTime());
            return platformIntranetsMapper.updateByPrimaryKey(platformIntranets);
        }else{
            platformIntranets.setId(StrUtil.makePramykey());
            platformIntranets.setCreateddate(DateUtil.getCurTime());
            return platformIntranetsMapper.insert(platformIntranets);
        }

    }

    @Override
    public int deletenews(String id) {
        return platformIntranetsMapper.deleteByPrimaryKey(id);
    }

    @Override
    public List<PlatformIntranets> newsdetailTop(String status, String catelog) {
        PlatformIntranetsExample platformIntranetsExample = new PlatformIntranetsExample();
        PlatformIntranetsExample.Criteria criteria = platformIntranetsExample.createCriteria();
        criteria.andCatelogEqualTo(catelog);
        criteria.andStatusEqualTo(status);
        List<PlatformIntranets> list = platformIntranetsMapper.selectByExampleWithBLOBs(platformIntranetsExample);
        return list;
    }

}
