package com.metro.auth.platform.controller;

/**
 * .::::.
 * .::::::::.
 * :::::::::::    佛主保佑、永无Bug
 * ..:::::::::::'
 * '::::::::::::'
 * .::::::::::
 * '::::::::::::::..
 * ..::::::::::::.
 * ``::::::::::::::::
 * ::::``:::::::::'        .:::.
 * ::::'   ':::::'       .::::::::.
 * .::::'      ::::     .:::::::'::::.
 * .:::'       :::::  .:::::::::' ':::::.
 * .::'        :::::.:::::::::'      ':::::.
 * .::'         ::::::::::::::'         ``::::.
 * ...:::           ::::::::::::'              ``::.
 * ```` ':.          ':::::::::'                  ::::..
 * '.:::::'                    ':'````..
 */

import com.metro.auth.platform.domain.ResultCode;
import com.metro.auth.platform.domain.ResultJson;
import com.metro.auth.platform.domain.auth.PlatformRoleMenu;
import com.metro.auth.platform.domain.auth.PlatformSysMenu;
import com.metro.auth.platform.domain.dto.RoleFunctionDTO;
import com.metro.auth.platform.service.PlatformMenuService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @ClassName: PlatformMenuController
 * @Description: ${description}  
 * @Authror zhouy
 * @Date 2019-09-09 17:11
 */
@RestController
@RequestMapping("/menu")
public class PlatformMenuController {

    @Value("${jwt.header}")
    private String tokenHeader;

    @Resource
    private PlatformMenuService platformMenuService;

    /**
     * 功能描述: <br>根据token查询用户可见菜单
     * 〈〉
     * @Param: [request]
     * @Return: [request]
     * @Author: zhouy
     * @Date: 2019-09-09 17:47
     */

    @GetMapping("/accessmenu")
    public ResultJson accessmenu(HttpServletRequest request){
        String token = request.getHeader(tokenHeader);
        if (token == null) {
            return ResultJson.failure(ResultCode.UNAUTHORIZED);
        }
        List<PlatformSysMenu> accessMenu =  platformMenuService.selectPlatformSysmenu(token);
        return ResultJson.ok(accessMenu);
    }

    /**
     * 功能描述: <br>根据token查询用户可见菜单
     * 〈〉
     * @Param: [request]
     * @Return: [request]
     * @Author: zhouy
     * @Date: 2019-09-09 17:47
     */

    @GetMapping("/list")
    public ResultJson menulist(){
        List<PlatformSysMenu> accessMenu =  platformMenuService.selectAllMenu();
        return ResultJson.ok(accessMenu);
    }

    /**
     * 功能描述: <br>新增菜单信息
     * 〈〉
     * @Param: [platformSysMenu]
     * @Return: [platformSysMenu]
     * @Author: zhouy
     * @Date: 2019-09-10 23:20
     */
    @PostMapping("/savemenu")
    public ResultJson saveMenu(@RequestBody PlatformSysMenu platformSysMenu){

        platformMenuService.saveMenu(platformSysMenu);
        return ResultJson.ok();
    }

    /**
     * 功能描述: <br>根据Roid查询用户可见菜单及可见按钮
     * 〈〉
     * @Param: [request]
     * @Return: [request]
     * @Author: zhouy
     * @Date: 2019-09-09 17:47
     */

    @GetMapping("/menufunctions")
    public ResultJson menuFunctions(PlatformRoleMenu platformRoleMenu){
        RoleFunctionDTO accessMenu =  platformMenuService.menuFunctions(platformRoleMenu);
        return ResultJson.ok(accessMenu);
    }




}
