package com.metro.auth.platform.controller;

/**
 * .::::.
 * .::::::::.
 * :::::::::::    佛主保佑、永无Bug
 * ..:::::::::::'
 * '::::::::::::'
 * .::::::::::
 * '::::::::::::::..
 * ..::::::::::::.
 * ``::::::::::::::::
 * ::::``:::::::::'        .:::.
 * ::::'   ':::::'       .::::::::.
 * .::::'      ::::     .:::::::'::::.
 * .:::'       :::::  .:::::::::' ':::::.
 * .::'        :::::.:::::::::'      ':::::.
 * .::'         ::::::::::::::'         ``::::.
 * ...:::           ::::::::::::'              ``::.
 * ```` ':.          ':::::::::'                  ::::..
 * '.:::::'                    ':'````..
 */

import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.domain.PageResult;
import com.metro.auth.platform.domain.ResultCode;
import com.metro.auth.platform.domain.ResultJson;
import com.metro.auth.platform.domain.auth.PlatformRoleMenu;
import com.metro.auth.platform.domain.auth.PlatformSysRole;
import com.metro.auth.platform.domain.dto.RoleFunctionDTO;
import com.metro.auth.platform.service.PlatformRoleService;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * @ClassName: PlatformRoleController
 * @Description: ${description}  
 * @Authror zhouy
 * @Date 2019-09-11 11:24
 */
@RestController
@RequestMapping("/role")
public class PlatformRoleController {

    @Resource
    PlatformRoleService platformRoleService;

    /**
     * 功能描述: <br>列表
     * 〈〉
     * @Param: [pageNum, pageSize, platformSysRole]
     * @Return: [pageNum, pageSize, platformSysRole]
     * @Author: zhouy
     * @Date: 2019-09-11 18:22
     */

    @GetMapping("/pagedlist")
    public ResultJson pagedlist(@RequestParam(required=true,value="pageNum",defaultValue="1") int pageNum,
                                @RequestParam(required=true,value="pageSize",defaultValue="15") int pageSize,
                                PlatformSysRole platformSysRole){
        PageInfo<PlatformSysRole> page =  platformRoleService.pagedlist(platformSysRole,pageNum,pageSize);
        return ResultJson.ok(page);
    }

    /**
     * 功能描述: <br>保存角色信息
     * 〈〉
     * @Param: [platformSysRole]
     * @Return: [platformSysRole]
     * @Author: zhouy
     * @Date: 2019-09-11 15:13
     */
    @PostMapping("/save")
    public ResultJson  saveRole(@RequestBody PlatformSysRole platformSysRole){

        int count = platformRoleService.savaRole(platformSysRole);
        if(count>0){
            return ResultJson.ok();
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }

    @DeleteMapping("/del")
    public ResultJson  deleRole(@RequestParam String id){

        int count = platformRoleService.deleRole(id);
        if(count>0){
            return ResultJson.ok();
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }

    @DeleteMapping("/batchdel/{ids}")
    public ResultJson  delRoles(@PathVariable String ids){
       platformRoleService.delRoles(ids);
        return ResultJson.ok();
    }

    @PostMapping("/savepermission")
    public ResultJson savepermission(@RequestBody RoleFunctionDTO roleFunctionDTO){

        int count = platformRoleService.savepermission(roleFunctionDTO);
        if(count>0){
            return ResultJson.ok();
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }
}