package com.metro.auth.platform.generallog;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.domain.auth.SysLogInfo;
import com.metro.auth.platform.domain.auth.SysLogInfoExample;
import com.metro.auth.platform.mapper.SysLogInfoMapper;
import com.metro.auth.platform.utils.EmptyUtilHelper;
import com.metro.auth.platform.utils.StrUtil;
import com.metro.auth.platform.viewformat.StringUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service
public class LogAddService {

    @Resource
    SysLogInfoMapper sysLogInfoMapper;

    /**
     * 功能描述: <br>保存日志信息
     * 〈〉
     * @Param: [logEntity]
     * @Return: [logEntity]
     * @Author: zhouy
     * @Date: 2019-07-16 16:17
     */

    @Async
    public void addLogInfo(SysLogInfo logEntity) {

        sysLogInfoMapper.insert(logEntity);
    }
    /**
     * 功能描述: <br>获得主键id
     * 〈〉
     * @Param: []
     * @Return: []
     * @Author: zhouy
     * @Date: 2019-07-16 16:17
     */
    
    public String getUUid(){
        return StrUtil.makePramykey();
    }

    /**
     * 功能描述: <br>查询日志列表
     * 〈〉
     * @Param: [entity, pageIndex, pageSize]
     * @Return: [entity, pageIndex, pageSize]
     * @Author: zhouy
     * @Date: 2019-07-16 20:46
     */

    public PageInfo<SysLogInfo> queryLogEntityPageList(SysLogInfo entity, int pageIndex, int pageSize) {
        PageHelper.startPage(pageIndex, pageSize);

        SysLogInfoExample sysLogInfoExample = new SysLogInfoExample();
        SysLogInfoExample.Criteria criteria = sysLogInfoExample.createCriteria();

        if (!EmptyUtilHelper.isEmpty(entity.getOperatetype())){
            criteria.andOperatetypeLike("%"+entity.getOperatetype()+"%");
        }

        if (!EmptyUtilHelper.isEmpty(entity.getOperatetime())){
            criteria.andOperatetimeLike("%"+entity.getOperatetime()+"%");
        }

        if (!EmptyUtilHelper.isEmpty(entity.getUsername())){
            criteria.andUsernameEqualTo(entity.getUsername());
        }
        sysLogInfoExample.setOrderByClause("operatetime desc");
        List<SysLogInfo> list =  sysLogInfoMapper.selectByExampleWithBLOBs(sysLogInfoExample);
        PageInfo<SysLogInfo> pageInfo = new PageInfo<SysLogInfo>(list);

        return pageInfo;
    }
}
