package com.metro.auth.platform.mapper;

import com.metro.auth.platform.domain.auth.PlatformPersonnel;
import com.metro.auth.platform.domain.auth.PlatformPersonnelExample;
import java.util.List;

import com.metro.auth.platform.domain.auth.PlatformSysUserRole;
import com.metro.auth.platform.domain.dto.PlatformOfficeEntity;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface PlatformPersonnelMapper {

    List<PlatformPersonnel> getPlatformUserEntityAll();


    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table platform_personnel
     *
     * @mbg.generated
     */
    long countByExample(PlatformPersonnelExample example);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table platform_personnel
     *
     * @mbg.generated
     */
    int deleteByExample(PlatformPersonnelExample example);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table platform_personnel
     *
     * @mbg.generated
     */
    int deleteByPrimaryKey(Integer id);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table platform_personnel
     *
     * @mbg.generated
     */
    int insert(PlatformPersonnel record);
    int insert_tmp(PlatformPersonnel record);
    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table platform_personnel
     *
     * @mbg.generated
     */
    int insertSelective(PlatformPersonnel record);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table platform_personnel
     *
     * @mbg.generated
     */
    List<PlatformPersonnel> selectByExampleWithBLOBs(PlatformPersonnelExample example);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table platform_personnel
     *
     * @mbg.generated
     */
    List<PlatformPersonnel> selectByExample(PlatformPersonnelExample example);
    List<PlatformPersonnel> selectTemporaryByExample(PlatformPersonnelExample example);
    List<PlatformPersonnel> selectAll(PlatformPersonnelExample example);

    /**
     * 查询所有带处理的人员信息
     * @param example
     * @return
     */
    List<PlatformPersonnel> selectUserListOfUpdate(PlatformPersonnelExample example);

    /**
     * 处理有问题部门信息
     * @param example
     * @return
     */
    List<PlatformPersonnel> selectUserDeptListOfUpdate(PlatformPersonnelExample example);
    List<PlatformPersonnel> selectByExampleUserid(PlatformPersonnelExample example);
    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table platform_personnel
     *
     * @mbg.generated
     */
    PlatformPersonnel selectByPrimaryKey(Integer id);

    /**
     * zhf根据角色ID获得用户列表
     * @param role_id
     * @return
     */
    List<PlatformPersonnel> selectByroleId(String role_id);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table platform_personnel
     *
     * @mbg.generated
     */
    int updateByExampleSelective(@Param("record") PlatformPersonnel record, @Param("example") PlatformPersonnelExample example);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table platform_personnel
     *
     * @mbg.generated
     */
    int updateByExampleWithBLOBs(@Param("record") PlatformPersonnel record, @Param("example") PlatformPersonnelExample example);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table platform_personnel
     *
     * @mbg.generated
     */
    int updateByExample(@Param("record") PlatformPersonnel record, @Param("example") PlatformPersonnelExample example);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table platform_personnel
     *
     * @mbg.generated
     */
    int updateByPrimaryKeySelective(PlatformPersonnel record);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table platform_personnel
     *
     * @mbg.generated
     */
    int updateByPrimaryKeyWithBLOBs(PlatformPersonnel record);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table platform_personnel
     *
     * @mbg.generated
     */
    int updateByPrimaryKey(PlatformPersonnel record);

    int updateByPrimaryKeyCheckNull(PlatformPersonnel record);

    int updateByPrimaryKeyNoPassword(PlatformPersonnel record);

    /**
     *根据工号获取用户
     * @param account
     * @return PlatformPersonnel
     */
    PlatformPersonnel selectByAccount(String account);


    List<PlatformPersonnel>  getPlatformPersonnelBybirthday(String birthday);
    /**
     * 根据用户名查找用户
     * @param account
     * @return
     */
    PlatformPersonnel findByUsername(@Param("account") String account);

    /**
     * 根据email查询用户信息
     * @param email
     * @return
     */
    PlatformPersonnel findUserInfoByemail(@Param("email") String email);
    /**
     * 根据id更改状态
     * @param record
     * @return
     */
    int updateStatusByPrimaryKeySelective(PlatformPersonnel record);

    /**
     * 根据工号更新头像
     * @param record
     * @return
     */
    int updateAvatarByAccount(PlatformPersonnel record);
    int updateAllByAccount(PlatformPersonnel record);
    int updateTempAllByAccount(PlatformPersonnel record);
    /**
     * 根据
     * @param record
     * @return
     */
    int updateDeptByid(PlatformPersonnel record);
    /**
     * 根据用户角色
     * @param id
     * @return
     */
    void updateRoleByUserid(@Param("id") int id,@Param("role") String role);

    /**
     * 根据code查询用户信息
     * @param code
     * @return
     */
    PlatformPersonnel findUserInfoByCode(@Param("code") String code);

    PlatformPersonnel findUserInfoByAccount(@Param("account") String account);
    /**
     * 根据id更新登录code
     * @param account
     * @param code
     */
    int updateCodeByUserid(@Param("account") String account,@Param("code") String code);
    /**
     *
     */
    int updateCodeByEmail(@Param("email") String email,@Param("code") String code);
    /**
     * 重置密码
     * @param password
     * @param id
     * @return
     */
    int updatePasswordByUserid(@Param("password") String password,@Param("id") String id);

    int batchInsert(List<PlatformPersonnel> list);

    int updateBatch(List<PlatformPersonnel> list);

    /**
     *批量更新头像
     * @param list
     * @return int
     */
    int updateBatchAvatar(List<PlatformPersonnel> list);
    int centerUpdateBatch(List<PlatformPersonnel> list);

    int batchTemporaryInsert(List<PlatformPersonnel> list);

    int updateTemporaryBatch(List<PlatformPersonnel> list);
    int updateDelTemporaryBatch(List<PlatformPersonnel> list);
    /**
     * 更新用户信息，只更新部分字段
     * @param record
     * @return
     */
    int updateSynchronousByPrimaryKey(PlatformPersonnel record);

    int updateSynchronousNoByPrimaryKey(PlatformPersonnel record);

    int updateDelstatusByAccount(@Param("UserID") String UserID);
    int updateDelstatusByAccountBatch(@Param("userIdList") List<String> userIdList);

    /**
     * 设置用户位启用
     * @param UserID
     * @return
     */
    int updateStatusByAccount(@Param("UserID") String UserID);


    int updateTemporaryDelstatusByAccount(@Param("UserID") String UserID);

    int updateTemporaryAccountByid(@Param("id") int id,@Param("UserID") String UserID);
    PlatformPersonnel selectTemByAccount(String account);
}
