package com.metro.auth.platform.controller;

import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.domain.Pagination;
import com.metro.auth.platform.domain.ResultCode;
import com.metro.auth.platform.domain.ResultJson;
import com.metro.auth.platform.domain.auth.PlatformSysLibrary;
import com.metro.auth.platform.generallog.LogAnnotation;
import com.metro.auth.platform.service.PlatformSysLibraryService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

@RestController
@RequestMapping("/syslibrary")
public class PlatformSysLibraryController {
    @Value("${jwt.header}")
    private String tokenHeader;
    @Resource
    private PlatformSysLibraryService platformSysLibraryService;

    /**
     * 查询列表
     * @param pageNum
     * @param pageSize
     * @param platformSysLibrary
     * @return
     */
    @GetMapping("/pagedlist")
    public ResultJson pagedlist(@RequestParam(required=true,value="pageNum",defaultValue="1") int pageNum,
                                @RequestParam(required=true,value="pageSize",defaultValue="15") int pageSize,
                                PlatformSysLibrary platformSysLibrary,HttpServletRequest request){
        String token = request.getHeader(tokenHeader);
        PageInfo<PlatformSysLibrary> page =  platformSysLibraryService.pagedlist(platformSysLibrary,pageNum,pageSize);
             return ResultJson.ok(page);
    }

    /**
     * 根据id更新实体
     * @param platformSysLibrary
     * @return
     */
    @LogAnnotation(operateContent="图片管理",operateType="更新")
    @PutMapping("/update")
    public  ResultJson update(@RequestBody PlatformSysLibrary platformSysLibrary){
        int flag=platformSysLibraryService.saveUpdatePlatformSysLibrary(platformSysLibrary);
        if (flag>0){
            return ResultJson.ok(ResultCode.SUCCESS);
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }
    /**
     * 根据id更新实体
     * @param platformSysLibrary
     * @return
     */
    @LogAnnotation(operateContent="图片管理",operateType="新增")
    @PostMapping("/add")
    public  ResultJson add(@RequestBody PlatformSysLibrary platformSysLibrary){
        int flag=platformSysLibraryService.savePlatformSysLibrary(platformSysLibrary);
        if (flag>0){
            return ResultJson.ok(ResultCode.SUCCESS);
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }
    /**
     *根据id获取实体
     * @param id
     * @return
     */
    @GetMapping("/load")
    public  ResultJson load(@RequestParam(required = true,value = "id",defaultValue = "") String id){
        PlatformSysLibrary platformSysLibrary=platformSysLibraryService.load(id);
        if (platformSysLibrary!=null){
            return  ResultJson.ok(platformSysLibrary);
        }else {
            return  ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }
    /**
     *根据id删除实体
     * @param id
     * @return
     */
    @LogAnnotation(operateContent="图片管理",operateType="删除")
    @RequestMapping("/delete")
    public  ResultJson delete(@RequestParam(required = true,value = "id",defaultValue = "") String id){
        int flag=platformSysLibraryService.delPlatformSysLibrary(id);
        if (flag>0){
            return ResultJson.ok(ResultCode.SUCCESS);
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }

    /**
     * 根据id更新部门启停状态
     * @return
     */
    @LogAnnotation(operateContent="图片管理",operateType="更新状态")
    @PostMapping("/updatestatus")
    public  ResultJson updatestatus(@RequestBody PlatformSysLibrary platformSysLibrary){
        int flag=platformSysLibraryService.updatePlatformSysLibraryStatusById(platformSysLibrary);
        if (flag>0){
            return ResultJson.ok(ResultCode.SUCCESS);
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }
    /**
     * 批量启停用
     * @param ids
     * @param status
     * @return
     */
    @LogAnnotation(operateContent="图片管理",operateType="批量更新状态")
    @PutMapping("/updateSysAdvStatus")
    public ResultJson updateSysAdvStatus(String ids,String status){
        platformSysLibraryService.updatePlatformSysLibraryStatus(status,ids);
        return ResultJson.ok();
    }
    /**
     * 接口1：根据type 及num  查询list
     */
    @GetMapping("/getSysAdvListByTypeAndNum")
    public  ResultJson getSysAdvListByTypeAndNum(String type,String num){
        PlatformSysLibrary platformSysLibrary=new PlatformSysLibrary();
        platformSysLibrary.setType(type);
        platformSysLibrary.setNum(num);
        platformSysLibrary.setStatus("1");
        List<PlatformSysLibrary> list=platformSysLibraryService.selectByExampleForinterface(platformSysLibrary);
        return  ResultJson.ok(list);
    }
    /**
     * 接口1：查询列表-pc端使用
     * @param pageIndex
     * @param pageSize
     * @param platformSysLibrary
     * @return
     */
    @GetMapping("/pagedlistpc")
    public ResultJson pagedlistpc(@RequestParam(required=true,value="pageIndex",defaultValue="1") int pageIndex,
                                @RequestParam(required=true,value="pageSize",defaultValue="15") int pageSize,
                                PlatformSysLibrary platformSysLibrary,HttpServletRequest request){
        String token = request.getHeader(tokenHeader);
//        platformSysLibrary.setStatus("1");
        PageInfo<PlatformSysLibrary> page =  platformSysLibraryService.pagedlist(platformSysLibrary,pageIndex,pageSize);
        Pagination pagination = new Pagination(page.getList(),new Long(page.getTotal()),pageSize,pageIndex);
        return ResultJson.ok(pagination);
    }
    /**
     *接口2：根据id获取实体
     * @param id
     * @return
     */
    @GetMapping("/getlibrarybyid/{id}")
    public  ResultJson getlibrarybyid(@PathVariable String id){
        PlatformSysLibrary platformSysLibrary=platformSysLibraryService.load(id);
        if (platformSysLibrary!=null){
            return  ResultJson.ok(platformSysLibrary);
        }else {
            return  ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }
}
