package com.metro.auth.platform.domain.auth;

import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/**
 * @author : zhouy
 * createAt: 2019/8/1
 */
public class UserDetail implements UserDetails {
    private long id;
    private String username;
    private String password;
    private PlatformSysRole role;
    private Date lastPasswordResetDate;
    private PlatformPersonnel platformPersonnel;
    private List<PlatformSysButton> permission;
    private List<PlatformSysRole> rolelist;

    public UserDetail(
            Integer id,
            String username,
            PlatformSysRole role,
        String password) {
        this.id = id;
        this.username = username;
        this.password = password;
        this.role = role;
    }

    public UserDetail(String username, String password, PlatformSysRole role) {
        this.username = username;
        this.password = password;
        this.role = role;
    }

    public UserDetail(Integer id, String username, String password) {
        this.id = id;
        this.username = username;
        this.password = password;
    }

    //返回分配给用户的角色列表
    @Override
    public Collection<? extends GrantedAuthority> getAuthorities() {
        List<GrantedAuthority> authorities = new ArrayList<>();
        authorities.add(new SimpleGrantedAuthority(role.getName()));
        return authorities;
    }

    public long getId() {
        return id;
    }

    @Override
    public String getPassword() {
        return password;
    }

    @Override
    public String getUsername() {
        return username;
    }

    /**
     * 账户是否未过期
     */
    @Override
    public boolean isAccountNonExpired() {
        return true;
    }

    /**
     *  账户是否未锁定
     */
    @Override
    public boolean isAccountNonLocked() {
        return true;
    }
    /**
     * 密码是否未过期
     */
    @Override
    public boolean isCredentialsNonExpired() {
        return true;
    }

    /** 账户是否激活
     */
    @Override
    public boolean isEnabled() {
        return true;
    }
    public Date getLastPasswordResetDate() {
        return lastPasswordResetDate;
    }


    public PlatformSysRole getRole() {
        return role;
    }

    public void setRole(PlatformSysRole role) {
        this.role = role;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setLastPasswordResetDate(Date lastPasswordResetDate) {
        this.lastPasswordResetDate = lastPasswordResetDate;
    }

    public PlatformPersonnel getPlatformPersonnel() {
        return platformPersonnel;
    }

    public void setPlatformPersonnel(PlatformPersonnel platformPersonnel) {
        this.platformPersonnel = platformPersonnel;
    }

    public List<PlatformSysButton> getPermission() {
        return permission;
    }

    public void setPermission(List<PlatformSysButton> permission) {
        this.permission = permission;
    }

    public List<PlatformSysRole> getRolelist() {
        return rolelist;
    }

    public void setRolelist(List<PlatformSysRole> rolelist) {
        this.rolelist = rolelist;
    }
}
