package com.metro.auth.platform.controller;

/**
 * .::::.
 * .::::::::.
 * :::::::::::    佛主保佑、永无Bug
 * ..:::::::::::'
 * '::::::::::::'
 * .::::::::::
 * '::::::::::::::..
 * ..::::::::::::.
 * ``::::::::::::::::
 * ::::``:::::::::'        .:::.
 * ::::'   ':::::'       .::::::::.
 * .::::'      ::::     .:::::::'::::.
 * .:::'       :::::  .:::::::::' ':::::.
 * .::'        :::::.:::::::::'      ':::::.
 * .::'         ::::::::::::::'         ``::::.
 * ...:::           ::::::::::::'              ``::.
 * ```` ':.          ':::::::::'                  ::::..
 * '.:::::'                    ':'````..
 */

import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.domain.ResultCode;
import com.metro.auth.platform.domain.ResultJson;
import com.metro.auth.platform.domain.auth.PlatformIntranets;
import com.metro.auth.platform.service.PlatformIntranetsService;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * @ClassName: PlatformIntranetsController
 * @Description: ${description}  
 * @Authror zhouy
 * @Date 2019-09-29 15:15
 */
@RestController
@RequestMapping("/post")
public class PlatformIntranetsController {



    @Resource
    private PlatformIntranetsService platformIntranetsService;


    /**
     * 功能描述: <br>查询新闻列表
     * 〈〉
     * @Param: [pageNum, pageSize, platformIntranets]
     * @Return: [pageNum, pageSize, platformIntranets]
     * @Author: zhouy
     * @Date: 2019-09-29 15:52
     */

    @GetMapping("/pagedlist")
    public ResultJson pagedlist(@RequestParam(required=true,value="pageNum",defaultValue="1") int pageNum,
                                @RequestParam(required=true,value="pageSize",defaultValue="15") int pageSize,
                                PlatformIntranets platformIntranets){
        PageInfo<PlatformIntranets> page =  platformIntranetsService.pagedlist(platformIntranets,pageNum,pageSize);
        return ResultJson.ok(page);
    }

    @GetMapping("/detail/{id}")
    public ResultJson newsdetail(@PathVariable String id){
        PlatformIntranets platformIntranets =  platformIntranetsService.newsdetail(id);
           return ResultJson.ok(platformIntranets);
    }

    @GetMapping("/top")
    public ResultJson newsdetailTop(@RequestParam String status,@RequestParam String catelog ){
        List<PlatformIntranets> platformIntranets =  platformIntranetsService.newsdetailTop(status,catelog);
        return ResultJson.ok(platformIntranets);
    }



    @PostMapping("/save")
    public ResultJson savenewsdetail(@RequestBody PlatformIntranets platformIntranets){
        int count =  platformIntranetsService.savenewsdetail(platformIntranets);
        if(count>0){
            return ResultJson.ok();
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);

        }

    }

}
