package com.metro.auth.platform;

import com.metro.auth.platform.wxmessage.ApiConfig;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.scheduling.annotation.EnableAsync;

/**
 * @author zhouy
 */
@EnableAsync
@SpringBootApplication
@EnableCaching
@MapperScan("com.metro.auth.platform.mapper")
public class SpringBootForPlatformApplication extends SpringBootServletInitializer {

	@Override
	protected SpringApplicationBuilder configure(SpringApplicationBuilder application) {
		return application.sources(SpringBootForPlatformApplication.class);
	}
	public static void main(String[] args) {
		ConfigurableApplicationContext context =  SpringApplication.run(SpringBootForPlatformApplication.class, args);
		context.getBean(ApiConfig.class).ApiConfigInit(false);
	}
}
