package com.metro.auth.platform.service;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import com.metro.auth.platform.domain.auth.PlatformHoliday;
import com.metro.auth.platform.domain.auth.PlatformHolidayExample;
import com.metro.auth.platform.http.HttpAPIService;
import com.metro.auth.platform.mapper.PlatformHolidayMapper;
import com.metro.auth.platform.utils.EmptyUtilHelper;
import com.metro.auth.platform.utils.JwtUtils;
import com.metro.auth.platform.viewformat.DataDictClass;
import com.metro.auth.platform.viewformat.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.UUID;

@Slf4j
@Service
public class PlatformHolidayServiceImpl implements PlatformHolidayService{
    @Resource
    private PlatformHolidayMapper platformHolidayMapper;
    private final JwtUtils jwtTokenUtil;
    public PlatformHolidayServiceImpl(JwtUtils jwtTokenUtil) {
        this.jwtTokenUtil = jwtTokenUtil;
    }
    @Resource
    public HttpAPIService httpAPIService;
    @Override
    @DataDictClass
    public List<PlatformHoliday> selectByExample(PlatformHoliday platformHoliday) {
        PlatformHolidayExample example = new PlatformHolidayExample();
        PlatformHolidayExample.Criteria criteria=example.createCriteria();
        if (!EmptyUtilHelper.isEmpty(platformHoliday.getDatetime())){
            criteria.andDatetimeEqualTo(platformHoliday.getDatetime());
        }
        criteria.andStatusEqualTo("1");
        return platformHolidayMapper.selectByExample(example);
    }

    @Override
    public  int savePlatformHoliday(PlatformHoliday entity){
        int flag=0;
        Date d = new Date();
       //获取最新id
        String uuid = UUID.randomUUID().toString();
        uuid = uuid.replace("-", "");
        entity.setId(uuid);
        if (StringUtil.isEmpty(entity.getStatus())) {
            entity.setStatus("1");
        }
            flag=platformHolidayMapper.insert(entity);
        return flag;
        }
    /**
     *
     * @param entity
     * @return
     */
    @Override
    public  int saveUpdatePlatformHoliday(PlatformHoliday entity){
        int flag=0;
         flag=platformHolidayMapper.updateByPrimaryKey(entity);
        return flag;
    }

    /**
     *
     * @param id
     * @return
     */
        @Override
        public int delPlatformHoliday(String id){
            int flag=platformHolidayMapper.deleteByPrimaryKey(id);

            return flag;
            }

    /**
     *根据id更新启用状态
     * @param entity
     * @return
     */
    @Override
            public  int updatePlatformHolidayStatusById(PlatformHoliday entity){
            int flag=0;
                //更改状态
               flag= platformHolidayMapper.updateStatusByPrimaryKey(entity);
            return  flag;
            }

    /**
     *
     * @param platformHoliday
     * @param pageNum
     * @param pageSize
     * @return
     */
    @Override
    @DataDictClass
        public PageInfo<PlatformHoliday> pagedlist(PlatformHoliday platformHoliday, int pageNum, int pageSize) {

            PageHelper.startPage(pageNum, pageSize);
        PlatformHolidayExample platformHolidayExample = new PlatformHolidayExample();
        PlatformHolidayExample.Criteria criteria = platformHolidayExample.createCriteria();
            //搜索
            if (platformHoliday!=null){
                if (!EmptyUtilHelper.isEmpty(platformHoliday.getTitle())){
                    criteria.andTitleLike("%"+platformHoliday.getTitle()+"%");
                }
                if (!EmptyUtilHelper.isEmpty(platformHoliday.getDatetime())){
                    criteria.andDatetimeEqualTo(platformHoliday.getDatetime());
                }
            }
        platformHolidayExample.setOrderByClause(" datetime desc");
            List<PlatformHoliday> list=platformHolidayMapper.selectByExample(platformHolidayExample);
            PageInfo<PlatformHoliday> pageInfo = new PageInfo<>(list);

            return pageInfo;
        }
        @Override
        public  PlatformHoliday load(String id){
            PlatformHoliday platformHoliday=platformHolidayMapper.selectByPrimaryKey(id);
            return  platformHoliday;
        }
    /**
     * 批量启停，微信无操作
     * @param status
     * @param ids
     */
    @Override
    public void updateHolidayStatus(String status,String ids) {

        String[] id = ids.split(",");
        for (int i=0;i<id.length;i++ ) {
            PlatformHoliday platformHoliday=platformHolidayMapper.selectByPrimaryKey(id[i]);
            platformHoliday.setStatus(status);
            int flag=platformHolidayMapper.updateStatusByPrimaryKey(platformHoliday);

        }
    }

}
