package com.metro.auth.platform.utils;


import com.metro.auth.platform.qyweixin.model.WxRefundNotifyResult;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.security.Security;

/**
 * @author 周海峰
 * @function
 * @date 
 * @version 
 */
public class AESUtil {
    /** 
     * 密钥算法 
     */ 
    private static final String ALGORITHM = "AES";  
    /** 
     * 加解密算法/工作模式/填充方式 
     */ 
    private static final String ALGORITHM_MODE_PADDING = "AES/ECB/PKCS7Padding";  
    /** 
     * 生成key 
     */  
   // private static SecretKeySpec key = new SecretKeySpec(MD5Util.MD5Encode(WXSignUtils.getaKey(), "utf-8").toLowerCase().getBytes(), ALGORITHM);  
  
    /** 
     * AES加密 
     *  
     * @param data 
     * @return 
     * @throws Exception 
     */  
    public static String encryptData(String data,String key) throws Exception {  
    	SecretKeySpec key1 = new SecretKeySpec(MD5Util.MD5Encode(key, "utf-8").toLowerCase().getBytes(), ALGORITHM); 
        // 创建密码器  
        Cipher cipher = Cipher.getInstance(ALGORITHM_MODE_PADDING);  
        // 初始化  
        cipher.init(Cipher.ENCRYPT_MODE, key1);  
        return Base64Util.encode(cipher.doFinal(data.getBytes()));  
    }  
  
   /** 
     * AES解密 
     * @param base64Data 
     * @return 
     * @throws Exception 
     */  
    public static String decryptData(String base64Data,String key) throws Exception {  
    	SecretKeySpec key1 = new SecretKeySpec(MD5Util.MD5Encode(key, "utf-8").toLowerCase().getBytes(), ALGORITHM);
    	/**
    	 * 此处调用支持PKCS7Padding
    	 */
    	Security.addProvider(new org.bouncycastle.jce.provider.BouncyCastleProvider());  
        Cipher cipher = Cipher.getInstance(ALGORITHM_MODE_PADDING);  
        cipher.init(Cipher.DECRYPT_MODE, key1);  
        return new String(cipher.doFinal(Base64Util.decode(base64Data)));  
    }  
   
    public static void main(String[] args) {
    	  String xmlString= "ow75zl50fef/M8zaSwemGVJsEHYCqkY31i2IoRFjqqv073pokq5kij1dWZoxHJVI+/pxfop1bsYdjLHEpAogcw/HgN7A7+x2mP2xr0kJZU66BuMpv0+4c5YXLlqdswLRlO7k7YVLjuLm7LdkoSiqOGvnOf2kF93yHZ96dmqhOPExIf5VRfglxuOR0C28Eqixyx43dVmFN3WOles9NhigIc6LbZh7IyqyhmtqzW2E4OjgscFYAZiF4IRNXd4Ol78TIJJ6KmX9U5IHv+WMalLtkII+hjWWax+oUpZqKAwzHubx39JragRwkfrv5Gyy/pw/pUF1Zk22fFSXtSuhkAPvCgN5qLOgKQy7pbfPpQhxvOFRGnjMUjU8ywQz32UjFZzPGwZq6giIpAxwAm3W6hLhwQiIZd9JhHDNUTAVivoHggcGbgeDMcM7ZB4AsQBzJmSH3ATIEMye7liQ5pnbDo1411yQMfhPQGiZbxXgx+4l2lYIypjUDT0D488RSFRtsrVYS3lLoXSF3Tm2RynwVDbd+9L2JKpVCwIESCPpRpr6wvnCxbZnsFqvwauZP2XcpA2VoWuQXKUkM0nZf8oYRsTAWPQ/joRdg7lq+I2Nu1lpL7pAronFEozDS4TF6iBHugQ5S6olt1HWs0fHJ3lcwy6SNPUReFFD1WPgSMXOOWf6JSO2t/SDe9vPLr4OC/tW+B5fA7ffxZRYVZh+/E4bevbuO7tjAZl4A5y4pc43VjA6xrm0KOY1ekbj+gk+qMx23vwfDpLsJwHZuoM1wcqOdRptqfpb4CRuMr++cenm9C723QFnLgW9VSq770K0HTRLufLwFp0J257xscmYn/aBshddsRX9KoEm7mYAqhvzLvXWmuoBbAlx1B+GpZsiN2T6FVEgZXadSJs9WwkArjlu6IwIXjfmnBiIOfm6XDJz2M0MRYaU7nLon7p7BBBLHKiGzBIQiChjaUGM/q/B+nXfxqtH3/wFW565HygJqqGHpS9kfGnuQo6aYeVSuziTtg44KBMr6l1m+fbCAK7d+booXW/JxOfU8fKEyLFjPqJXeaB1YAc=";
    	try {
			System.out.println(decryptData(xmlString,"12345678901234567890123456789012"));
			String str=decryptData(xmlString,"12345678901234567890123456789012");
			System.out.println("xml"+str);
			WxRefundNotifyResult wxRefundResult2=JdomParseXmlUtils.getWxRefundNotifyResult(str);
			System.out.println("jieguo "+wxRefundResult2.getRefund_status());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
    
    
}

