package com.metro.auth.platform.config;

import com.metro.auth.platform.domain.auth.UserDetail;
import com.metro.auth.platform.utils.JwtUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.annotation.Resource;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;

/**
 * token校验
 * @author: zhouy
 * createAt: 2019/8/1
 */
@Component
public class JwtAuthenticationTokenFilter extends OncePerRequestFilter {

    @Value("${jwt.header}")
    private String token_header;

    @Resource
    private JwtUtils jwtUtils;

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        String auth_token = request.getHeader(this.token_header);
        final String auth_token_start = "";

        // 获取请求方式
        String Method = request.getMethod();
        // 获取请求的ip地址
        String IP  = request.getRemoteAddr();

        logger.info("请求服务器IP和Method "+IP+"----"+Method);

        if (StringUtils.isNotEmpty(auth_token) && auth_token.startsWith(auth_token_start)) {
            auth_token = auth_token.substring(auth_token_start.length());
        } else {
            // 不按规范,不允许通过验证
            auth_token = null;
        }

        String account = jwtUtils.getUsernameFromToken(auth_token);
        try{
            logger.info(String.format("Checking authentication for userDetail %s.", account));

            if (jwtUtils.containToken(account, auth_token) && account != null && SecurityContextHolder.getContext().getAuthentication() == null) {
                UserDetail userDetail = jwtUtils.getUserFromToken(auth_token);
                if (jwtUtils.validateToken(auth_token, userDetail)) {
                    UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken(userDetail, null, userDetail.getAuthorities());
                    authentication.setDetails(new WebAuthenticationDetailsSource().buildDetails(request));
                    logger.info(String.format("Authenticated userDetail %s, setting security context", account));
                    SecurityContextHolder.getContext().setAuthentication(authentication);
                }
            }
        }catch (Exception e){
            logger.info("token认证时发生异常！");
            e.printStackTrace();
        }

        chain.doFilter(request, response);
    }
}
