package com.metro.auth.platform.domain.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel(description= "具体参数描述")
@JsonInclude(value= JsonInclude.Include.NON_NULL)
public class PersonneBaseDTO {


    @ApiModelProperty(value = "部门或员工id")
    private Integer id;
    @ApiModelProperty(value = "部门或员工名")
    private String title;
    @ApiModelProperty(value = "上级id")
    private String pid;
    @ApiModelProperty(value = "部门或员工名")
    private String label;
    @ApiModelProperty(value = "部门或员工id")
    private Integer key;
    @ApiModelProperty(value = "工号")
    private String no;


    public PersonneBaseDTO(PersonneDTO dto){
        this.id=dto.getId();
        this.title=dto.getTitle();
        this.label=dto.getLabel();
        this.key=dto.getKey();
        this.no= dto.getNo();
    }

}
