package com.metro.auth.platform.service;

import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.domain.auth.PlatformDepartment;
import com.metro.auth.platform.domain.dto.DepartmentPersonneDTO;
import com.metro.auth.platform.domain.dto.PlatformOfficeEntity;
import org.springframework.cache.annotation.CacheEvict;

import java.util.List;

public interface PlatformDepartmentService {

    List<PlatformDepartment> getPlatformOfficeEntityAll();

    List<PlatformDepartment> selectByExample();

    /**
     * 功能描述: <br>根据机构id查询所有上级机构
     * 〈〉
     * @Param: [id]
     * @Return: [PlatformDepartment]
     * @Author: lx
     */

    List<PlatformDepartment> queryPlatformDepartmentById(Integer id);

    List<PlatformDepartment> selectPlatformDepartmentListByPid(String pid);
    /**
     *  新增或修改实体
     * @param entity
     * @return
     */
    int savePlatformDepartment(PlatformDepartment entity);
    int saveUpdatePlatformDepartment(PlatformDepartment entity);
    /**
     * 删除实体
     * @param id
     * @return
     */
    int delPlatformDepartment(String id);
    int updatePlatformDepartmentStatusById(PlatformDepartment entity);
    /**
     *分页查询
     * @param platformDepartment
     * @param pageNum
     * @param pageSize
     * @return
     */
    PageInfo<PlatformDepartment> pagedlist(PlatformDepartment platformDepartment ,int pageNum, int pageSize);

    PlatformDepartment load(String id);
    List<PlatformDepartment> selectAllMenu();
    /**
     * 部门树不含员工
     * @param
     * @return
     */
    DepartmentPersonneDTO getDepartmentTree(String token);
    void updateDeptStatus(String status,String ids);
    long countByExample(String id);
    long countaccountByExample(String id);

    /**
     * 同步企业微信部门信息
     * @return
     */
    @CacheEvict(value = "viewDeptall",key = "'tree'")//清除组织树结构的缓存
     void findwxdeptinfo();
    @CacheEvict(value = "viewDeptall",key = "'tree'")//清除组织树结构的缓存
    void updatePlatformDepartmentFromweixin(String ChangeType,PlatformDepartment entity, String branchCompanyId);
}
