package com.metro.auth.platform.domain.dto;


import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

/**
 * <p>
 * 平台用户表
 * </p>
 *
 * @author zjn
 * @since 2021-07-06
 */
@Data
@Accessors(chain = true)
public class PlatformUserEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    protected String id;

    // 基础平台id
    private String baseId;

    // 公司id
    private String companyId;

    // 中心id
    private String centerId;

    // 部门id
    private String departId;

    // 直属组织机构id
    private String officeId;

    // 用户名
    private String username;

    // 密码
    private String password;

    // 加密盐
    private String hashSalt;

    // 姓名
    private String realName;

    // 员工号
    private String staffCode;

    // 性别 1男，2女
    private String sex;

    // 邮箱
    private String email;

    // 手机号码
    private String phoneNumber;

    // 座机号码
    private String telNumber;

    // 头像
    private String avatar;

    // 微信昵称
    private String nickname;

    // 生日
    private String birthday;

    // 地址
    private String address;

    // 岗位
    private String position;

    // 前端主题颜色
    private String color;

    // 管理员标记
    private Integer admin;

    // 应用管理员标记
    private String appAdmin;

    // 状态 0正常，1冻结
    private String status;

    // 与企业微信同步0未同步1成功2失败
    private String synchronous;

    // 1微信不存在0正常
    private String delstatus;

    // 员工二维码地址
    private String qrcode;

    // 人员类别 inside内部，outside外部
    private String userType;

    // 用户数据来源 Wechat微信，
    private String userSource;

    // 人员状态 quit离职，working在职
    private String userStatus;

    // 是否领导
    private String isleader;

    // 是否是分管领导
    private String ischarge;

    // 分管机构
    private String chargeOffices;

    // 是否隐藏 0否，1是
    private String hide;

    // 排序
    private String sort;

    protected String centerName;

    protected String departName;

    protected String officeName;

    protected String officeType;

    protected String icon;

    protected String name;

    private String dataId;

    private String delFlag;

    private String branchCompanyId;
}
