package com.metro.auth.platform.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.config.BCryptMD5;
import com.metro.auth.platform.config.MyPasswordEncoder;
import com.metro.auth.platform.domain.WebUserToken;
import com.metro.auth.platform.domain.auth.*;
import com.metro.auth.platform.domain.dto.DepartmentPersonneDTO;
import com.metro.auth.platform.domain.dto.PersonneBaseDTO;
import com.metro.auth.platform.domain.dto.PersonneDTO;
import com.metro.auth.platform.domain.dto.ResultDTO;
import com.metro.auth.platform.domain.entity.Department;
import com.metro.auth.platform.domain.entity.DepartmentExample;
import com.metro.auth.platform.domain.entity.PersonnelExample;
import com.metro.auth.platform.http.HttpAPIService;
import com.metro.auth.platform.mapper.*;
import com.metro.auth.platform.utils.*;
import com.metro.auth.platform.viewformat.DataDictClass;
import com.metro.auth.platform.wxmessage.ApiConfig;
import com.metro.auth.platform.wxmessage.MessageSendType;
import com.metro.auth.platform.wxmessage.Messagesend;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import com.metro.auth.platform.utils.JwtUtils;
import org.springframework.util.CollectionUtils;

@Slf4j
@Service
public class PlatformPersonnelServiceImpl implements PlatformPersonnelService {
    private final JwtUtils jwtTokenUtil;
    @Resource
    private PlatformPersonnelMapper platformPersonnelMapper;
    @Resource
    private WeixinuserupdateinfoMapper weixinuserupdateinfoMapper;
    @Resource
    private PlatformNumberMapper platformNumberMapper;
    @Resource
    private PlatformSysUserRoleMapper platformSysUserRoleMapper;
    @Resource
    private Messagesend messagesend;
    @Resource
    private PlatformPersonnelManagerdeptMapper platformPersonnelManagerdeptMapper;
    @Resource
    private PlatformPersonnelDepartmentMapper platformPersonnelDepartmentMapper;
    @Resource
    public HttpAPIService httpAPIService;
    @Resource
    private PlatformDepartmentService platformDepartmentService;
    @Resource
    private DepartmentMapper departmentMapper;
    @Resource
    private PlatformDepartmentMapper platformDepartmentMapper;
    @Resource
    private PersonnelMapper personnelMapper;
    @Value("${Benediction_Birthday}")
    private String Benediction_Birthday;
    private static final boolean SYNCHRONOUSLDSTATUS = false;
    private static final boolean SYNCHRONOUSLDSTATUS_PER_DEPT = true;

    @Resource
    private Platform3Util platform3Util;


    public PlatformPersonnelServiceImpl(JwtUtils jwtTokenUtil) {
        this.jwtTokenUtil = jwtTokenUtil;
    }

    /**
     * #创建微信用户
     */
    @Value("${weixin-params.wx_user_create}")
    private String WX_USER_CREATE;
    @Value("${weixin-params.wx_user_get}")
    private String WX_USER_GET;
    @Value("${weixin-params.wx_user_delete}")
    private String WX_USER_DELETE;
    @Value("${weixin-params.wx_user_update}")
    private String WX_USER_UPDATE;
    @Value("${weixin-params.wx_user_dept_detail}")
    private String WX_USER_DEPT_DETAIL;
    @Value("${weixin-params.wx_all_userinfo}")
    private String WX_ALL_USERINFO;


    @Override
    public List<PlatformPersonnel> getPlatformUserEntityAll() {
        return platformPersonnelMapper.getPlatformUserEntityAll();
    }

    @Override
    public List<PlatformPersonnel> selectByExample() {
        PlatformPersonnelExample example = new PlatformPersonnelExample();
        return platformPersonnelMapper.selectByExample(example);
    }

    @Override
    public PlatformPersonnel selectByAccount(String account) {
        return platformPersonnelMapper.selectByAccount(account);
    }

    /**
     * 功能描述: <br>生日提醒
     * 〈〉
     *
     * @Param: []
     * @Return: []
     * @Author: zhouy
     * @Date: 2019-10-29 15:58
     */

    @Override
    public List<PlatformPersonnel> getPlatformPersonnelBybirthday() {

        List<PlatformPersonnel> list = platformPersonnelMapper.getPlatformPersonnelBybirthday(DateUtil.getCurTimeByFormatter("MM-dd"));
        //判断是否已推送
        if (list != null && list.size() > 0) {
            if (EmptyUtilHelper.isEmpty(list.get(0).getBirthdaypush()) ||
                    !list.get(0).getBirthdaypush().equals(DateUtil.getCurTimeByFormatter("YYYY-MM-dd"))) {
                birthdaysendMessage(list);
            }
        }
        return list;
    }

    /**
     * 功能描述: <br>处理生日推送信息
     * 〈〉
     *
     * @Param: [list]
     * @Return: [list]
     * @Author: zhouy
     * @Date: 2019-10-29 16:19
     */

    private void birthdaysendMessage(List<PlatformPersonnel> list) {

        JSONObject result = messagesend.messagesend(new MessageSendType(list, Benediction_Birthday));
        if (list != null) {
            list.stream().forEach(t -> {
                t.setBirthdaypush(DateUtil.getCurTimeByFormatter("YYYY-MM-dd"));
                platformPersonnelMapper.updateByPrimaryKey(t);
            });
        }
    }


    /**
     * 功能描述: <br>查询列表
     * 〈〉
     *
     * @Param: [platformPersonnel, pageNum, pageSize]
     * @Return: [platformPersonnel, pageNum, pageSize]
     * @Author: zhouy
     * @Date: 2019-09-11 18:02
     */

    @Override
    @DataDictClass
    public PageInfo<PlatformPersonnel> pagedlist(PlatformPersonnel platformPersonnel, int pageNum, int pageSize, String token) {
        UserDetail userDetail = jwtTokenUtil.getUserFromToken(token);
        PlatformPersonnel entity = platformPersonnelMapper.selectByAccount(userDetail.getUsername());
        String fuze = "10000";
        String isadmin = "0";
        String[] list_fuze = {};
        if (entity != null) {
            if (entity.getIsadmin() != 1) {

                if (!EmptyUtilHelper.isEmpty(entity.getFuze())) {
                    fuze = entity.getFuze();
                    list_fuze = fuze.split(",");
                }
            } else {
                isadmin = "1";
            }
        }

        PageHelper.startPage(pageNum, pageSize);
        PlatformPersonnelExample platformPersonnelExample = new PlatformPersonnelExample();
        PlatformPersonnelExample.Criteria criteria = platformPersonnelExample.createCriteria();
        List<PlatformPersonnel> list = new ArrayList<>();
        if (platformPersonnel != null) {
            if (!EmptyUtilHelper.isEmpty(platformPersonnel.getDelstatus())) {
                criteria.andDelstatusEqualTo(platformPersonnel.getDelstatus());
            }
            if (!EmptyUtilHelper.isEmpty(platformPersonnel.getAccount())) {
                criteria.andAccountLike("%" + platformPersonnel.getAccount() + "%");
            }
            if (!EmptyUtilHelper.isEmpty(platformPersonnel.getUsername())) {
                criteria.andUsernameLike("%" + platformPersonnel.getUsername() + "%");
            }
            if (!EmptyUtilHelper.isEmpty(platformPersonnel.getPhoneNumber())) {
                criteria.andPhoneNumberLike("%" + platformPersonnel.getPhoneNumber() + "%");
            }

            if ("1".equals(isadmin)) {
                //管理员
                if (!EmptyUtilHelper.isEmpty(platformPersonnel.getDepartmentid())) {
                    criteria.andOrDepartment(platformPersonnel.getDepartmentid());
                } else {
                    if (!EmptyUtilHelper.isEmpty(platformPersonnel.getCenterid())) {
                        criteria.andOrDepartment(platformPersonnel.getCenterid());
                    }
                }
                list = platformPersonnelMapper.selectByExample(platformPersonnelExample);
            } else {
                if (!EmptyUtilHelper.isEmpty(platformPersonnel.getDepartmentid())) {
                    criteria.andOrDepartmentAndUserid(platformPersonnel.getDepartmentid());
                } else {
                    if (!EmptyUtilHelper.isEmpty(platformPersonnel.getCenterid())) {
                        criteria.andOrDepartmentAndUserid(platformPersonnel.getCenterid());
                    }
                }
                criteria.andDepartmentAndUserid(entity.getId().toString());

                list = platformPersonnelMapper.selectByExampleUserid(platformPersonnelExample);
            }
            platformPersonnelExample.setOrderByClause(" ordernum asc, identity desc");
//            List<String> departlist= Arrays.asList(list_fuze);
        }

        PageInfo<PlatformPersonnel> pageInfo = new PageInfo<>(list);

        return pageInfo;
    }

    @Override
    public int delUser(String id) {
        int count = platformPersonnelMapper.deleteByPrimaryKey(Integer.parseInt(id));
        //同步企业微信
        if (count > 0) {
//            boolean flag = this.deletewxuserinfo(id);
        }
        return count;
    }

    @Override
    public void delUsers(String ids) {

        String[] id = ids.split(",");
        Arrays.stream(id).forEach(t -> {
            platformPersonnelMapper.deleteByPrimaryKey(Integer.parseInt(t));
//            boolean flag = this.deletewxuserinfo(t);
        });
    }

    @Override
    public void updateUsersStatus(String status, String ids) {

        String[] id = ids.split(",");
        for (int i = 0; i < id.length; i++) {
            PlatformPersonnel platformPersonnel = platformPersonnelMapper.selectByPrimaryKey(Integer.parseInt(id[i]));
            platformPersonnel.setStatus(status);
            int flag = platformPersonnelMapper.updateStatusByPrimaryKeySelective(platformPersonnel);
//            if (flag > 0 && SYNCHRONOUSLDSTATUS) this.updatewxuserinfoStatus(platformPersonnel.getAccount(), status);
        }
    }

    @Override
    public int savaUser(PlatformPersonnel platformPersonnel) {
        int count = 0;
        platformPersonnel.setSynchronous("1");
        final String rawPassword = platformPersonnel.getPassword();
        //BCryptMD5为自定义加密处理
        platformPersonnel.setPassword(BCryptMD5.encode(rawPassword));
        if (platformPersonnel != null && !EmptyUtilHelper.isEmpty(platformPersonnel.getId())) {
            count = platformPersonnelMapper.updateByPrimaryKey(platformPersonnel);
        } else {
            PlatformNumber platformNumber = new PlatformNumber();
            platformNumber.setType("per");
            platformNumber = platformNumberMapper.selectOrderByNum(platformNumber);
            platformPersonnel.setId(platformNumber.getNum());
            count = platformPersonnelMapper.insert(platformPersonnel);
            //默认赋予新用户普通用户角色
            platformSysUserRoleMapper.insert(new PlatformSysUserRole(StrUtil.makePramykey(), platformNumber.getNum(), "1"));
            Date d = new Date();
            platformPersonnel.setAddtime(DateUtil.smartFormat(d));
            if (count > 0) {
                platformNumber.setNum(platformNumber.getNum() + 1);
                platformNumberMapper.updateByPrimaryKeySelective(platformNumber);
            }
        }
        platformPersonnelMapper.updateByPrimaryKey(platformPersonnel);

        return count;
    }

    /**
     * 保存-不更新密码
     *
     * @param platformPersonnel
     * @return
     */
    @Override
    @CacheEvict(value = "viewDeptall", key = "'tree'")//清除组织树结构的缓存
    public int savenopassword(PlatformPersonnel platformPersonnel) {

        int count = 0;
        boolean flag = false;
        platformPersonnel.setSynchronous("1");
        if (platformPersonnel != null && !EmptyUtilHelper.isEmpty(platformPersonnel.getId())) {
            count = platformPersonnelMapper.updateByPrimaryKeyNoPassword(platformPersonnel);//不更新密码
//            if (count > 0 && SYNCHRONOUSLDSTATUS) {
//                ResultDTO resultDTO = this.updatewxuserinfo(platformPersonnel.getId().toString());
//                if (resultDTO.getCode().equals("60111")) {
//                    resultDTO = this.addwxuserinfo(platformPersonnel.getId().toString());
//                }
//                platformPersonnel.setSynchronous(resultDTO.getCode());
//            }
        } else {
            PlatformNumber platformNumber = new PlatformNumber();
            platformNumber.setType("per");
            platformNumber = platformNumberMapper.selectOrderByNum(platformNumber);
            platformPersonnel.setId(platformNumber.getNum());
            count = platformPersonnelMapper.insert(platformPersonnel);
            //默认赋予新用户普通用户角色
            platformSysUserRoleMapper.insert(new PlatformSysUserRole(StrUtil.makePramykey(), platformNumber.getNum(), "1"));
            Date d = new Date();
            platformPersonnel.setAddtime(DateUtil.smartFormat(d));
//            if (count > 0 && SYNCHRONOUSLDSTATUS) {
//                platformNumber.setNum(platformNumber.getNum() + 1);
//                platformNumberMapper.updateByPrimaryKeySelective(platformNumber);
//                ResultDTO resultDTO = this.addwxuserinfo(platformPersonnel.getId().toString());
//                platformPersonnel.setSynchronous(resultDTO.getCode());
//            }
        }
        int count_save = platformPersonnelMapper.updateByPrimaryKey(platformPersonnel);
        if (count_save > 0) {
            this.saveUserDepartment(platformPersonnel.getId(), platformPersonnel.getDepartment(), platformPersonnel.getFuze());
        }
        return count;
    }

    /**
     * 功能描述: <br>
     * 〈〉
     *
     * @Param: []
     * @Return: []
     * @Author: zhouy
     * @Date: 2019-09-11 19:23
     */
    @Override
    @DataDictClass
    public List<PlatformPersonnel> getUserList() {

        return platformPersonnelMapper.selectByExample(new PlatformPersonnelExample());
    }

    /**
     * 同步微信-新增
     *
     * @param id
     * @return
     */
    private ResultDTO addwxuserinfo(String id) {
        boolean flag = false;
        ResultDTO resultDTO = new ResultDTO();
        if (SYNCHRONOUSLDSTATUS) {
            PlatformPersonnel entity = platformPersonnelMapper.selectByPrimaryKey(Integer.parseInt(id));
            if (entity != null) {
                JSONObject object = new JSONObject();
                object.put("userid", entity.getAccount());//成员UserID。对应管理端的帐号，企业内必须唯一。不区分大小写，长度为1~64个字节。只能由数字、字母和“_-@.”四种字符组成，且第一个字符必须是数字或字母。*
                object.put("name", entity.getUsername());//成员名称。长度为1~64个utf8字符*
                object.put("alias", entity.getNickname());//成员别名。长度1~32个utf8字符
                object.put("mobile", entity.getPhoneNumber());//手机号码。企业内必须唯一，mobile/email二者不能同时为空
                object.put("department", entity.getDepartment());//成员所属部门id列表,不超过20个 *
//             object.put("order",webUserToken.getOrder());//部门内的排序值，默认为0，成员次序以创建时间从小到大排列。数量必须和department一致，数值越大排序越前面。有效的值范围是[0, 2^32)
                object.put("position", entity.getPosition());//职务信息。长度为0~128个字符
                object.put("gender", entity.getSex().toString());//性别。1表示男性，2表示女性
                object.put("email", entity.getEmail());//邮箱 长度6~64个字节，且为有效的email格式
                object.put("telephone", entity.getTelNumber());//座机。32字节以内，由纯数字或’-‘号组成。
//             object.put("is_leader_in_dept",webUserToken.getIs_leader_in_dept());//个数必须和department一致，表示在所在的部门内是否为上级。1表示为上级，0表示非上级。在审批等应用里可以用来标识上级审批人
//             object.put("avatar_mediaid",webUserToken.getAvatar_mediaid());//成员头像的mediaid，通过素材管理接口上传图片获得的mediaid
                object.put("enable", entity.getStatus());//启用/禁用成员。1表示启用成员，0表示禁用成员
//             object.put("extattr",webUserToken.getExtattr());//自定义字段。
//             object.put("to_invite",webUserToken.getTo_invite());//是否邀请该成员使用企业微信。
//             object.put("external_profile",webUserToken.getExternal_profile());//成员对外属性，字段详情见对外属性。
//             object.put("external_position",webUserToken.getExternal_position());//对外职务，如果设置了该值，则以此作为对外展示的职务，否则以position来展示。长度12个汉字内。
                object.put("address", entity.getAddress());//地址。长度最大128个字符
                String url = WX_USER_CREATE + SpringUtil.getBean(ApiConfig.class).getAccessToken_Tx();
//                JSONObject wxuserinfo = httpAPIService.doPost(url, object.toString());
//                log.info("wxuserinf 为===" + wxuserinfo);
//                String errmsg = wxuserinfo.getString("errmsg");
//                String errcode = wxuserinfo.getString("errcode");
//                resultDTO.setMessage(errmsg);
//                resultDTO.setCode(errcode);
//                if ("created".equals(errmsg)) {
//                    log.info("创建微信信息状态====" + errmsg);
//                    flag = true;
//                }
            }
        }
        return resultDTO;
    }

    /**
     * 同步微信-更新
     *
     * @param id
     * @return 先注掉不同步，避免发加入邀请 11.20
     */
    private ResultDTO updatewxuserinfo(String id) {
        boolean flag = false;
        ResultDTO resultDTO = new ResultDTO();
        if (SYNCHRONOUSLDSTATUS) {
            PlatformPersonnel entity = platformPersonnelMapper.selectByPrimaryKey(Integer.parseInt(id));
            if (entity != null) {
                JSONObject object = new JSONObject();
                object.put("userid", entity.getAccount());//成员UserID。对应管理端的帐号，企业内必须唯一。不区分大小写，长度为1~64个字节。只能由数字、字母和“_-@.”四种字符组成，且第一个字符必须是数字或字母。*
                object.put("name", entity.getUsername());//成员名称。长度为1~64个utf8字符*
                object.put("alias", entity.getNickname());//成员别名。长度1~32个utf8字符
                object.put("mobile", entity.getPhoneNumber());//手机号码。企业内必须唯一，mobile/email二者不能同时为空
                object.put("department", entity.getDepartment());//成员所属部门id列表,不超过20个 *
                //             object.put("order",webUserToken.getOrder());//部门内的排序值，默认为0，成员次序以创建时间从小到大排列。数量必须和department一致，数值越大排序越前面。有效的值范围是[0, 2^32)
                object.put("position", entity.getPosition());//职务信息。长度为0~128个字符
                object.put("gender", entity.getSex().toString());//性别。1表示男性，2表示女性
                object.put("email", entity.getEmail());//邮箱 长度6~64个字节，且为有效的email格式
                object.put("telephone", entity.getTelNumber());//座机。32字节以内，由纯数字或’-‘号组成。
                //             object.put("is_leader_in_dept",webUserToken.getIs_leader_in_dept());//个数必须和department一致，表示在所在的部门内是否为上级。1表示为上级，0表示非上级。在审批等应用里可以用来标识上级审批人
                //             object.put("avatar_mediaid",webUserToken.getAvatar_mediaid());//成员头像的mediaid，通过素材管理接口上传图片获得的mediaid
                object.put("enable", entity.getStatus());//启用/禁用成员。1表示启用成员，0表示禁用成员
                //             object.put("extattr",webUserToken.getExtattr());//自定义字段。
                //             object.put("to_invite",webUserToken.getTo_invite());//是否邀请该成员使用企业微信。
                //             object.put("external_profile",webUserToken.getExternal_profile());//成员对外属性，字段详情见对外属性。
                //             object.put("external_position",webUserToken.getExternal_position());//对外职务，如果设置了该值，则以此作为对外展示的职务，否则以position来展示。长度12个汉字内。
                object.put("address", entity.getAddress());//地址。长度最大128个字符
                String url = WX_USER_UPDATE + SpringUtil.getBean(ApiConfig.class).getAccessToken_Tx();
//                JSONObject wxuserinfo = httpAPIService.doPost(url, object.toString());
//                log.info("wxuserinf 为===" + wxuserinfo);
//                String errmsg = wxuserinfo.getString("errmsg");
//                String errcode = wxuserinfo.getString("errcode");
//                resultDTO.setMessage(errmsg);
//                resultDTO.setCode(errcode);
//                if ("updated".equals(errmsg)) {
//                    log.info("更新微信信息状态====" + errmsg);
//                    flag = true;
//                }
            }
        }
        return resultDTO;
    }

    /**
     * 同步微信-更新
     *
     * @param account
     * @param status
     * @return 先注掉不同步，避免发加入邀请 11.20
     */
    private boolean updatewxuserinfoStatus(String account, String status) {
        boolean flag = false;
        if (SYNCHRONOUSLDSTATUS) {
            JSONObject object = new JSONObject();
            object.put("userid", account);//成员UserID。对应管理端的帐号，企业内必须唯一。不区分大小写，长度为1~64个字节。只能由数字、字母和“_-@.”四种字符组成，且第一个字符必须是数字或字母。*
            object.put("enable", status);//启用/禁用成员。1表示启用成员，0表示禁用成员
            String url = WX_USER_UPDATE + SpringUtil.getBean(ApiConfig.class).getAccessToken_Tx();
//            JSONObject wxuserinfo = httpAPIService.doPost(url, object.toString());
//            log.info("wxuserinf 为===" + wxuserinfo);
//            String errmsg = wxuserinfo.getString("errmsg");
//            if ("updated".equals(errmsg)) {
//                log.info("更新微信信息状态====" + errmsg);
//                flag = true;
//            }
        }
        return flag;
    }

    /**
     * 先注掉不同步，避免发加入邀请 11.20
     *
     * @param id
     * @return
     */
    private boolean deletewxuserinfo(String id) {
        boolean flag = false;
        if (SYNCHRONOUSLDSTATUS) {
            PlatformPersonnel entity = platformPersonnelMapper.selectByPrimaryKey(Integer.parseInt(id));
            String url = WX_USER_DELETE + SpringUtil.getBean(ApiConfig.class).getAccessToken_Tx() + "&userid=" + entity.getAccount();
            try {
//                String wxuserinfo = httpAPIService.doGet(url);
//                JSONObject json = JSONUtil.getJSONFromString(wxuserinfo);
//                String errmsg = json.getString("errmsg");
//                log.info("errmsg 为===" + json.get("errmsg"));
//                if ("deleted".equals(errmsg)) {
//                    log.info("更新微信信息状态====" + errmsg);
//                    flag = true;
//                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return flag;
    }

    /**
     * 根据部门id获取成员信息
     *
     * @param deptid      获取的部门id
     * @param fetch_child 1/0：是否递归获取子部门下面的成员
     * @return
     */
    @Override
    public int getUserinfoListFromWeixin(String deptid, String fetch_child) {
        int flag = 0;

        if (SYNCHRONOUSLDSTATUS_PER_DEPT) {

            JSONArray jsonArray = getSourceData(Platform3Util.SOURCE_TYPE, deptid, fetch_child);

            try {
                PlatformPersonnelExample platformPersonnelExample = new PlatformPersonnelExample();
                List<PlatformPersonnel> list = platformPersonnelMapper.selectAll(platformPersonnelExample);
                ArrayList arrlist = new ArrayList();
                for (int k = 0; k < list.size(); k++) {
                    arrlist.add(list.get(k).getAccount());
                }
                if (jsonArray.size() > 0) {
                    for (int i = 0; i < jsonArray.size(); i++) {
                        JSONObject obj = jsonArray.getJSONObject(i);  // 遍历 jsonarray 数组，把每一个对象转成 json 对象
//                        String userid=obj.get("userid").toString();
//                        判断当前userid时候已存在，存在着跳过
//                        PlatformPersonnel platformPersonnel_status=platformPersonnelMapper.findUserInfoByAccount(userid);
                        boolean res_result = arrlist.contains(obj.get("userid"));
                        if (!res_result) {
                            PlatformPersonnel platformPersonnel = new PlatformPersonnel();
                            Date d = new Date();
//                            PlatformNumber platformNumber = new PlatformNumber();
//                            platformNumber.setType("per");
//                            platformNumber = platformNumberMapper.selectOrderByNum(platformNumber);
                            String idStr = obj.get("id").toString();
                            platformPersonnel.setId(Integer.parseInt(idStr));
//                            platformNumber.setNum(platformNumber.getNum() + 1);
//                            platformNumberMapper.updateByPrimaryKeySelective(platformNumber);

                            platformPersonnel.setUsername(obj.get("name").toString());
                            platformPersonnel.setSex(Integer.parseInt(obj.get("gender").toString()));
                            platformPersonnel.setBirthday("");//生日
                            platformPersonnel.setAccount(obj.get("userid").toString());
//                    platformPersonnel.setId(Integer.parseInt(obj.get("userid").toString()));
                            platformPersonnel.setPassword(BCryptMD5.encode("!QAZ2wsx#EDC2022"));
                            platformPersonnel.setPhoneNumber(obj.get("mobile").toString());
                            platformPersonnel.setTelNumber(obj.get("telephone").toString());
                            platformPersonnel.setEmail(obj.get("email").toString());
                            platformPersonnel.setNickname(obj.get("name").toString());
                            if (obj.get("address") != null) {
                                platformPersonnel.setAddress(obj.get("address").toString());
                            }
                            platformPersonnel.setMobile("");//移动小号
                            platformPersonnel.setTelecom("");//电信小号
                            platformPersonnel.setOffice("");
                            String deptlist = obj.getString("department");
                            deptlist = deptlist.replace("[", "");
                            deptlist = deptlist.replace("]", "");
                            platformPersonnel.setDepartment(deptlist);
                            platformPersonnel.setDepartmentname(getdeptnameBydeptidlist(deptlist));
                            platformPersonnel.setPosition(obj.get("position").toString());
                            platformPersonnel.setIdentity("");
                            platformPersonnel.setRole(obj.get("is_leader_in_dept").toString());
                            platformPersonnel.setAddtime(DateUtil.smartFormat(d));
                            platformPersonnel.setCredit("");
                            platformPersonnel.setPolitical("");//政治面貌
                            platformPersonnel.setAuth("");
                            platformPersonnel.setAppId("");
                            platformPersonnel.setPaizhu("");
                            platformPersonnel.setFuze("");
                            platformPersonnel.setIsadmin(0);
                            platformPersonnel.setSynchronous("1");
                            platformPersonnel.setStatus("1");
                            if (obj.get("avatar") != null) {
                                String avatar = DownImageUtil.saveAvatar2File(obj.get("avatar").toString(), platformPersonnel.getAccount());
                                platformPersonnel.setAvatar(avatar);
                            }
                            int res = platformPersonnelMapper.insert(platformPersonnel);
                            int role_flag = platformSysUserRoleMapper.insert(new PlatformSysUserRole(StrUtil.makePramykey(), platformPersonnel.getId(), "1"));
                            log.info(obj.get("name").toString() + "=========" + role_flag);
                        } else {
//                            log.info(obj.get("name").toString() + "====已存在=====" );
                        }
                    }
                    this.updateUserDeptFormal();
                    //插入更新记录
                    Weixinuserupdateinfo weixinuserupdateinfo = new Weixinuserupdateinfo();
                    weixinuserupdateinfo.setId(DateUtil.getNumberByDateTime());
                    weixinuserupdateinfo.setUpdatetime(DateUtil.getCurTime());
                    weixinuserupdateinfo.setCount("1");
                    weixinuserupdateinfo.setType("2");
                    weixinuserupdateinfoMapper.insert(weixinuserupdateinfo);
                }

            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return flag;
    }
    private JSONArray getSourceData(String sourceType, String deptId, String fetchChild) {

        JSONArray jsonArray = null;

        if(Platform3Util.SOURCE_TYPE_WECHAT.equals(sourceType)){
            String url = WX_USER_DEPT_DETAIL + SpringUtil.getBean(ApiConfig.class).getAccessToken_Tx() + "&department_id=" + deptId + "&fetch_child=" + fetchChild;
            String wxuserinfo = httpAPIService.doGet(url);
            JSONObject json = JSONUtil.getJSONFromString(wxuserinfo);
            jsonArray = json.getJSONArray("userlist");
        }
        if(Platform3Util.SOURCE_TYPE_PLATFORM3.equals(sourceType)){

            JSONArray source = platform3Util.getUserListByOfficeId(deptId, fetchChild);
            //改结构
            jsonArray = platform3Util.convertUserList(source);
        }

        return jsonArray;
    }

    /**
     * 直接批量处理人员部门低于3级的信息
     *
     * @date 7-28
     * @author wy
     */
    private void updateUserDeptFormal() {
        //  把level》3级人员划入3级，领导不需要处理， 1 2 3级不需要处理
        //1.查询所有带处理人员信
        PlatformPersonnelExample platformPersonnelExample = new PlatformPersonnelExample();
        List<PlatformPersonnel> list = platformPersonnelMapper.selectUserDeptListOfUpdate(platformPersonnelExample);

        //  2.循环判断人员部门是否》3级，并更新到对应3级部门
        for (int k = 0; k < list.size(); k++) {
            //查询父级别id
            int id = list.get(k).getId();
            String account = list.get(k).getAccount();
            String dept = list.get(k).getDepartment();
            String[] ll = dept.split(",");
            dept = ll[0];
            log.info("待处理帐号：account==" + account + "dept==" + dept);

            //取当前部门信息
            PlatformDepartment entity = platformDepartmentService.load(dept);
            if (entity != null) {
                //如果为pid=64 行政办公室   特殊处理
                if ("64".equals(entity.getPid())) {
                    PlatformDepartment entity_parent = platformDepartmentService.load(entity.getPid());
                    list.get(k).setDepartment(entity_parent.getId().toString());
                    list.get(k).setDepartmentname(entity_parent.getName());
                    log.info("处理结果1：更新后dept=" + entity_parent.getPid());
                } else {
                    PlatformDepartment entity_4 = platformDepartmentService.load(entity.getPid());
                    if ("2".equals(entity.getLevel())) {
                        list.get(k).setMetrocentername(entity.getName());
                        list.get(k).setMetrocenterid(String.valueOf(entity.getId()));
                        log.info("处理结果0：更新后dept=" + entity_4.getPid());
                    } else if ("3".equals(entity.getLevel())) {
                        PlatformDepartment entity_p = platformDepartmentService.load(entity.getPid());
                        if (entity_p != null) {
                            list.get(k).setMetrocentername(entity_p.getName());
                            list.get(k).setMetrocenterid(String.valueOf(entity_p.getId()));
                        }
                        log.info("处理结果0：更新后dept=" + entity_4.getPid());
                    } else if ("4".equals(entity.getLevel()) && entity_4 != null) {
                        list.get(k).setDepartment(entity_4.getId().toString());
                        list.get(k).setDepartmentname(entity_4.getName());
                        PlatformDepartment entity_p = platformDepartmentService.load(entity_4.getPid());
                        if (entity_p != null) {
                            list.get(k).setMetrocentername(entity_p.getName());
                            list.get(k).setMetrocenterid(String.valueOf(entity_p.getId()));
                        }
                        log.info("处理结果2：更新后dept=" + entity_4.getPid());
                    } else if ("5".equals(entity.getLevel()) && entity_4 != null) {
                        PlatformDepartment entity_5 = platformDepartmentService.load(entity_4.getPid());
                        list.get(k).setDepartment(entity_5.getId().toString());
                        list.get(k).setDepartmentname(entity_5.getName());
                        PlatformDepartment entity_p = platformDepartmentService.load(entity_5.getPid());
                        if (entity_p != null) {
                            list.get(k).setMetrocentername(entity_p.getName());
                            list.get(k).setMetrocenterid(String.valueOf(entity_p.getId()));
                        }
                        log.info("处理结果3：更新后dept=" + entity_5.getPid());
                    }
                }
                int flag5 = platformPersonnelMapper.updateSynchronousByPrimaryKey(list.get(k));
                if (flag5 > 0) {
                    platformPersonnelMapper.updateSynchronousNoByPrimaryKey(list.get(k));
                }

            }
        }

    }

    /**
     * 从临时表批量处理人员部门
     *
     * @date 7-28
     * @author wy
     */
    private void updateUserDept() {
        //  把level》3级人员划入3级，领导不需要处理， 1 2 3级不需要处理
        //1.查询所有带处理人员信  synchronous=1，处理后置成0
        PlatformPersonnelExample platformPersonnelExample = new PlatformPersonnelExample();
        List<PlatformPersonnel> list = platformPersonnelMapper.selectUserListOfUpdate(platformPersonnelExample);

        //  2.循环判断人员部门是否》3级，并更新到对应3级部门
        for (int k = 0; k < list.size(); k++) {
            //查询父级别id
            int id = list.get(k).getId();
            String account = list.get(k).getAccount();
            String dept = list.get(k).getDepartment();
            String[] ll = dept.split(",");
            dept = ll[0];
            log.info("待处理帐号：account==" + account + "dept==" + dept);

            //取当前部门信息
            PlatformDepartment entity = platformDepartmentService.load(dept);
            if (entity != null) {
                // TODO 4
                //如果为pid=64 行政办公室   特殊处理
                if ("64".equals(entity.getPid())) {
                    PlatformDepartment entity_parent = platformDepartmentService.load(entity.getPid());
                    list.get(k).setDepartment(entity_parent.getId().toString());
                    list.get(k).setMetrocenterid(entity_parent.getId().toString());
                    list.get(k).setDepartmentname(entity_parent.getName());
                    list.get(k).setMetrocentername(entity_parent.getName());
                    log.info("处理结果1：更新后dept=" + entity_parent.getId() + entity_parent.getName());
                } else {
                    PlatformDepartment entity_4 = platformDepartmentService.load(entity.getPid());
                    if ("2".equals(entity.getLevel())) {
                        list.get(k).setMetrocentername(entity.getName());
                        list.get(k).setMetrocenterid(String.valueOf(entity.getId()));
                        log.info("处理结果0：更新后dept=" + entity_4.getPid());
                    } else if ("3".equals(entity.getLevel())) {
//                        list.get(k).setDepartment(entity_4.getId().toString());
//                        list.get(k).setDepartmentname(entity_4.getName());
                        PlatformDepartment entity_p = platformDepartmentService.load(entity.getPid());
                        if (entity_p != null) {
                            list.get(k).setMetrocentername(entity_p.getName());
                            list.get(k).setMetrocenterid(String.valueOf(entity_p.getId()));
                        }
                        log.info("处理结果0：更新后dept=" + entity_4.getPid());
                    } else if ("4".equals(entity.getLevel()) && entity_4 != null) {
                        list.get(k).setDepartment(entity_4.getId().toString());
                        list.get(k).setDepartmentname(entity_4.getName());
                        PlatformDepartment entity_p = platformDepartmentService.load(entity_4.getPid());
                        if (entity_p != null) {
                            list.get(k).setMetrocentername(entity_p.getName());
                            list.get(k).setMetrocenterid(String.valueOf(entity_p.getId()));
                        }
                        log.info("处理结果2：更新后dept=" + entity_4.getPid());
                    } else if ("5".equals(entity.getLevel()) && entity_4 != null) {
                        PlatformDepartment entity_5 = platformDepartmentService.load(entity_4.getPid());
                        list.get(k).setDepartment(entity_5.getId().toString());
                        list.get(k).setDepartmentname(entity_5.getName());
                        PlatformDepartment entity_p = platformDepartmentService.load(entity_5.getPid());
                        if (entity_p != null) {
                            list.get(k).setMetrocentername(entity_p.getName());
                            list.get(k).setMetrocenterid(String.valueOf(entity_p.getId()));
                        }
                        log.info("处理结果3：更新后dept=" + entity_5.getPid());
                    }

                }
                //TODO 批量更新数据到正式表
                int flag5 = platformPersonnelMapper.updateSynchronousByPrimaryKey(list.get(k));
                if (flag5 > 0) {
                    //更新成功后重置同步表对比状态，准备下次拉取对比
                    platformPersonnelMapper.updateSynchronousNoByPrimaryKey(list.get(k));
                }


            }
        }

    }

    /**
     * 查询不再企业微信里的人员名单
     *
     * @param deptid
     * @param fetch_child
     * @param pageNum
     * @param pageSize
     * @return
     */
    @Override
    public PageInfo<PlatformPersonnel> getPlatformPersonnelpagedlist_WeixinDelete(String deptid, String fetch_child, int pageNum, int pageSize) {

        //获取全部用户
        PlatformPersonnelExample platformPersonnelExample = new PlatformPersonnelExample();
        List<PlatformPersonnel> list = platformPersonnelMapper.selectByExample(platformPersonnelExample);

        //获取部门下微信的用户信息
        List<PlatformPersonnel> weixin_cache = new ArrayList<>();
        JSONArray jsonArray = getSourceData(Platform3Util.SOURCE_TYPE, deptid, fetch_child);

        Map<String, PlatformPersonnel> cache = new HashMap<>();
        if (jsonArray.size() > 0) {
            for (int i = 0; i < jsonArray.size(); i++) {
                JSONObject obj = jsonArray.getJSONObject(i);
                PlatformPersonnel platformPersonnel = new PlatformPersonnel();
                platformPersonnel.setUsername(obj.get("name").toString());
                platformPersonnel.setSex(Integer.parseInt(obj.get("gender").toString()));
                platformPersonnel.setAccount(obj.get("userid").toString());
                platformPersonnel.setPassword(BCryptMD5.encode("SYdite@!QAZ2022"));
                platformPersonnel.setPhoneNumber(obj.get("mobile").toString());
                //更新是否为上级 11.11
                String identity = obj.getString("is_leader_in_dept");
                identity = identity.replace("[", "");
                identity = identity.replace("]", "");
                platformPersonnel.setIdentity(identity);
                //TODO 同步其他字段
                // 1112 增加部分字段开始
                //账户状态 激活状态: 1=已激活，2=已禁用，4=未激活，5=退出企业。
                String status = obj.getString("status");
                if (status.equals("1")) {
                    platformPersonnel.setStatus("1");
                } else {
                    platformPersonnel.setStatus("0");
                }
                //主部门 main_department
                platformPersonnel.setMaindepartment(obj.get("main_department").toString());
                platformPersonnel.setQrcode(obj.get("qr_code").toString());
                platformPersonnel.setNickname(obj.get("alias").toString());
                platformPersonnel.setUpdatetime(DateUtil.getCurTime());
                // 1112 增加部分字段结束
                platformPersonnel.setTelNumber(obj.get("telephone").toString());
                platformPersonnel.setEmail(obj.get("email").toString());
                if (obj.get("address") != null) {
                    platformPersonnel.setAddress(obj.get("address").toString());
                }
                String deptlist = obj.getString("department");
                deptlist = deptlist.replace("[", "");
                deptlist = deptlist.replace("]", "");
                platformPersonnel.setDepartment(deptlist);//部门特别的标识一下
                platformPersonnel.setPosition(obj.get("position").toString());
                if (obj.get("avatar") != null) {
                    platformPersonnel.setAvatar(obj.get("avatar").toString());
                }
                cache.put(platformPersonnel.getAccount(), platformPersonnel);

            }
            List<Map<String, String>> changelist = new ArrayList<>();
            for (int j = 0; j < list.size(); j++) {
                PlatformPersonnel personnel = cache.get(list.get(j).getAccount());
                if (personnel == null) {
                    Map<String, String> map = new HashMap<>();
                    map.put("name", "异常用户");
                    map.put("value", "微信中不存在此用户!");
                    changelist.add(map);
                    list.get(j).setChangelist(changelist);
                    weixin_cache.add(list.get(j));
                }

            }

        }
        weixin_cache = weixin_cache.stream().sorted(Comparator.comparing(PlatformPersonnel::getAccount)).collect(Collectors.toList());
        PageInfo<PlatformPersonnel> pageInfo = new PageInfo<>(weixin_cache);
        return pageInfo;
    }

    /**
     * zhf
     *
     * @param deptid      部门id
     * @param fetch_child 是否递归获取子部门下面的成员：1-递归获取，0-只获取本部门
     * @return
     */
    @Override
    public PageInfo<PlatformPersonnel> getPlatformPersonnelpagedlist_Weixin(String deptid, String fetch_child, int pageNum, int pageSize) {

        //获取全部用户
        PlatformPersonnelExample platformPersonnelExample = new PlatformPersonnelExample();
        List<PlatformPersonnel> list = platformPersonnelMapper.selectTemporaryByExample(platformPersonnelExample);
        Map<String, PlatformPersonnel> cache = new HashMap<>();
        for (PlatformPersonnel platformPersonnel : list) {
            cache.put(platformPersonnel.getAccount(), platformPersonnel);
        }

        //获取部门下微信的用户信息
        List<PlatformPersonnel> weixin_cache = new ArrayList<>();
        JSONArray jsonArray = getSourceData(Platform3Util.SOURCE_TYPE, deptid, fetch_child);

        if (jsonArray.size() > 0) {
            for (int i = 0; i < jsonArray.size(); i++) {
                JSONObject obj = jsonArray.getJSONObject(i);  // 遍历 jsonarray 数组，把每一个对象转成 json 对象
                PlatformPersonnel platformPersonnel = new PlatformPersonnel();
                platformPersonnel.setUsername(obj.get("name").toString());
                platformPersonnel.setSex(Integer.parseInt(obj.get("gender").toString()));
                platformPersonnel.setAccount(obj.get("userid").toString());
                platformPersonnel.setPassword(BCryptMD5.encode("SYdite@!QAZ2022"));
                platformPersonnel.setPhoneNumber(obj.get("mobile").toString());
                //更新是否为上级 11.11
                String identity = obj.getString("is_leader_in_dept");
                identity = identity.replace("[", "");
                identity = identity.replace("]", "");
                platformPersonnel.setIdentity(identity);
                //TODO 同步其他字段
                // 1112 增加部分字段开始
                //账户状态 激活状态: 1=已激活，2=已禁用，4=未激活，5=退出企业。
                String status = obj.getString("status");
                if (status.equals("1")) {
                    platformPersonnel.setStatus("1");
                } else {
                    platformPersonnel.setStatus("0");
                }
                //主部门 main_department
                platformPersonnel.setMaindepartment(obj.get("main_department").toString());
                //内部排序  order带逗号不可用
//                String order = obj.getString("order");
//                order = order.replace("[", "");
//                order = order.replace("]", "");
//                platformPersonnel.setOrdernum(order);
                //员工二维码 qr_code
                platformPersonnel.setQrcode(obj.get("qr_code").toString());
                platformPersonnel.setNickname(obj.get("alias").toString());
                platformPersonnel.setUpdatetime(DateUtil.getCurTime());
                // 1112 增加部分字段结束
                platformPersonnel.setTelNumber(obj.get("telephone").toString());
                platformPersonnel.setEmail(obj.get("email").toString());
//                platformPersonnel.setNickname(obj.get("name").toString());
                if (obj.get("address") != null) {
                    platformPersonnel.setAddress(obj.get("address").toString());
                }
                String deptlist = obj.getString("department");
                deptlist = deptlist.replace("[", "");
                deptlist = deptlist.replace("]", "");
                platformPersonnel.setDepartment(deptlist);//部门特别的标识一下
                platformPersonnel.setPosition(obj.get("position").toString());
                if (obj.get("avatar") != null) {
                    platformPersonnel.setAvatar(obj.get("avatar").toString());
                }


                //比较改变的项目
                List<Map<String, String>> changelist = new ArrayList<>();
                PlatformPersonnel personnel = cache.get(platformPersonnel.getAccount());
                if (personnel == null) {
                    platformPersonnel.setIschange("1");
                    platformPersonnel.setChangetype("add");
                    Map<String, String> map = new HashMap<>();
                    map.put("name", "用户新增");
                    map.put("value", "本地不存在此用户!");
                    changelist.add(map);
                    platformPersonnel.setChangelist(changelist);
                    //临时生成一个ID，前台用于展示
                    int id = 10000000 + i;
                    platformPersonnel.setId(id);
                    platformPersonnel.setDepartmentname(getdeptnameBydeptidlist(deptlist));

                }

                if (personnel != null) {
                    String weixin_identity = platformPersonnel.getIdentity();//部门
                    weixin_identity = StringUtils.isEmpty(weixin_identity) ? "" : weixin_identity;

                    String weixin_dept = platformPersonnel.getDepartment();//部门
                    weixin_dept = StringUtils.isEmpty(weixin_dept) ? "" : weixin_dept;

                    String weixin_avatar = platformPersonnel.getAvatar();//头像
                    weixin_avatar = StringUtils.isEmpty(weixin_avatar) ? "" : weixin_avatar;

                    String weixin_mobile = platformPersonnel.getPhoneNumber();//电话
                    weixin_mobile = StringUtils.isEmpty(weixin_mobile) ? "" : weixin_mobile;

                    String weixin_email = platformPersonnel.getEmail();//电话
                    weixin_email = StringUtils.isEmpty(weixin_email) ? "" : weixin_email;

                    String weixin_position = platformPersonnel.getPosition();//岗位
                    weixin_position = StringUtils.isEmpty(weixin_position) ? "" : weixin_position;

                    String weixin_status = platformPersonnel.getStatus();//岗位
                    weixin_status = StringUtils.isEmpty(weixin_status) ? "" : weixin_status;
                    try {
                        // 判断岗位 1202 增加
                        String identity_new = personnel.getIdentity();
                        if (!StringUtils.isEmpty(weixin_identity) && !identity_new.equals(weixin_identity)) {
                            platformPersonnel.setIschange("1");
                            platformPersonnel.setChangetype("update");
                            Map<String, String> map = new HashMap<>();
                            map.put("name", "上下级");
                            map.put("oldvalue", identity_new);//
                            map.put("value", weixin_identity);
                            changelist.add(map);
                            platformPersonnel.setChangelist(changelist);
                        }
                        // 判断岗位 1112 增加
                        String position = personnel.getPosition();
                        position = StringUtils.isEmpty(position) ? "" : position;
                        if (!StringUtils.isEmpty(weixin_position) && !position.equals(weixin_position)) {
                            platformPersonnel.setIschange("1");
                            platformPersonnel.setChangetype("update");
                            Map<String, String> map = new HashMap<>();
                            map.put("name", "岗位");
                            map.put("oldvalue", position);//
                            map.put("value", weixin_position);
                            changelist.add(map);
                            platformPersonnel.setChangelist(changelist);
                        }
                        //判断邮箱
                        String email = personnel.getEmail();
                        email = StringUtils.isEmpty(email) ? "" : email;
                        if (!StringUtils.isEmpty(weixin_email) && !email.equals(weixin_email)) {//比较
                            platformPersonnel.setIschange("1");
                            platformPersonnel.setChangetype("update");
                            Map<String, String> map = new HashMap<>();
                            map.put("name", "邮箱");
                            map.put("oldvalue", email);//
                            map.put("value", weixin_email);
                            changelist.add(map);
                            platformPersonnel.setChangelist(changelist);
                        }
                        //判断账户状态
                        if (!StringUtils.isEmpty(platformPersonnel.getStatus())) {
                            if (StringUtils.isEmpty(personnel.getStatus()) || !personnel.getStatus().equals(platformPersonnel.getStatus())) {//岗位比较
                                platformPersonnel.setIschange("1");
                                platformPersonnel.setChangetype("update");
                                Map<String, String> map = new HashMap<>();
                                map.put("name", "状态");
                                map.put("oldvalue", platformPersonnel.getStatus());//
                                map.put("value", weixin_status);
                                changelist.add(map);
                                platformPersonnel.setChangelist(changelist);
                            }
                        }
//                        //判断岗位
//                        if (!StringUtils.isEmpty(platformPersonnel.getPosition())) {
//                            if (StringUtils.isEmpty(personnel.getPosition()) || !personnel.getPosition().equals(platformPersonnel.getPosition())) {//岗位比较
//                                platformPersonnel.setIschange("1");
//                                platformPersonnel.setChangetype("update");
//                                Map<String, String> map = new HashMap<>();
//                                map.put("name", "岗位");
//                                map.put("oldvalue", platformPersonnel.getPosition());//
//                                map.put("value", weixin_position);
//                                changelist.add(map);
//                                platformPersonnel.setChangelist(changelist);
//                            }
//                        }
                        //判断部门
                        String dept = personnel.getDepartment();
                        dept = StringUtils.isEmpty(dept) ? "" : dept;
                        if (!StringUtils.isEmpty(weixin_dept) && !StrUtil.strEqual(dept, weixin_dept)) {//部门比较
                            platformPersonnel.setIschange("1");
                            platformPersonnel.setChangetype("update");
                            Map<String, String> map = new HashMap<>();
                            map.put("name", "部门");
                            map.put("oldvalue", getdeptnameBydeptidlist(dept));//
                            String value = getdeptnameBydeptidlist(weixin_dept);
                            map.put("value", value);
                            changelist.add(map);
                            platformPersonnel.setChangelist(changelist);
                            platformPersonnel.setDepartmentname(value);
                        }
                        //判断手机号
                        String mobile = personnel.getPhoneNumber();
                        mobile = StringUtils.isEmpty(mobile) ? "" : mobile;
                        if (!StringUtils.isEmpty(weixin_mobile) && !mobile.equals(weixin_mobile)) {//电话比较
                            platformPersonnel.setIschange("1");
                            platformPersonnel.setChangetype("update");
                            Map<String, String> map = new HashMap<>();
                            map.put("name", "电话");
                            map.put("oldvalue", mobile);//
                            map.put("value", weixin_mobile);
                            changelist.add(map);
                            platformPersonnel.setChangelist(changelist);
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }

                    platformPersonnel.setId(personnel.getId());
                }
                if ("1".equals(platformPersonnel.getIschange())) {//只返回改变的用户
                    weixin_cache.add(platformPersonnel);
                }

            }
        }

        weixin_cache = weixin_cache.stream().sorted(Comparator.comparing(PlatformPersonnel::getAccount)).collect(Collectors.toList());
        PageInfo<PlatformPersonnel> pageInfo = new PageInfo<>(weixin_cache);
        return pageInfo;

    }

    /**
     * zhf 20220128
     * 只是跟新用户头像
     */
    @Override
    public void avatarUpdate() throws Exception{

        //获取全部用户
        PlatformPersonnelExample platformPersonnelExample = new PlatformPersonnelExample();
        List<PlatformPersonnel> list = platformPersonnelMapper.selectTemporaryByExample(platformPersonnelExample);
        //获取部门下微信的用户信息
        String url = WX_USER_DEPT_DETAIL + SpringUtil.getBean(ApiConfig.class).getAccessToken_Tx() + "&department_id=1&fetch_child=1";
        String wxUserInfo = httpAPIService.doGet(url);
        Map<String,String> map = new HashMap<>();
        List<PlatformPersonnel> cacheUpdate = new ArrayList<>();
        JSONObject json = JSONUtil.getJSONFromString(wxUserInfo);
        String userList = json.getString("userlist");
        JSONArray jsonArray = JSONArray.parseArray(userList);
        if (jsonArray.size() > 0) {
            for (int i = 0; i < jsonArray.size(); i++) {
                JSONObject obj = jsonArray.getJSONObject(i);
                String avatar = obj.get("avatar").toString();
                String account = obj.get("userid").toString();
                if (StringUtils.isNotEmpty(avatar)){
                    map.put(account,avatar);
                }

            }
        }

        if (!CollectionUtils.isEmpty(list)){
            for (PlatformPersonnel personnel : list) {
                String account = personnel.getAccount();
                String s = map.get(account);
                if (StringUtils.isNotEmpty(s)){
                    personnel.setAvatar(s);
                    cacheUpdate.add(personnel);
                }

            }
        }

        if (!CollectionUtils.isEmpty(cacheUpdate)){
            platformPersonnelMapper.updateBatchAvatar(cacheUpdate);
        }

    }


    @Override
    @CacheEvict(value = "viewDeptall", key = "'tree'")//清除组织树结构的缓存
    public int updatePlatformpersonnel(List<PlatformPersonnel> list) {
        if (list == null || list.size() == 0) {
            return 1;
        }
        log.info("共有[" + list.size() + "条数据进行了更新!]");
        //开始头像转换本地文件，替换本地路径
        for (int i = 0; i < list.size(); i++) {
            list.get(i).setAvatar(DownImageUtil.saveAvatar2File(list.get(i).getAvatar(), list.get(i).getAccount()));
        }
        String userlist="account:";// 记录下所有变更account
        int result_stauts1 = 0;
        int result_status2 = 0;
        List<PlatformPersonnel> add_list =
                list.stream().filter(item -> "add".equals(item.getChangetype())).collect(Collectors.toList());
        List<PlatformPersonnel> update_list =
                list.stream().filter(item -> "update".equals(item.getChangetype())).collect(Collectors.toList());
        //设置新增用户的ID,并保存
        if (add_list != null && add_list.size() > 0) {
            List<PlatformSysUserRole> sysUserRoles = new ArrayList<>();
            //获取ID
            PlatformNumber platformNumber = new PlatformNumber();
            platformNumber.setType("per");
            platformNumber = platformNumberMapper.selectOrderByNum(platformNumber);
            int num = platformNumber.getNum();
            //获取当前时间
            String time = DateUtil.smartFormat(new Date());
            for (int i = 0; i < add_list.size(); i++) {
                userlist=userlist+"add=>"+add_list.get(i).getAccount();
                String[] stringlist = add_list.get(i).getDepartment().split(",");//多个部门取第一个保存，否则异常
                //查询部门名称
                PlatformDepartment dept = platformDepartmentMapper.selectByPrimaryKey(Integer.parseInt(stringlist[0]));

                num++;
                add_list.get(i).setId(num);
                add_list.get(i).setAddtime(time);
                add_list.get(i).setIsadmin(0);
                add_list.get(i).setSynchronous("1");
//                add_list.get(i).setStatus("1");
                if (dept != null) {
                    add_list.get(i).setDepartmentname(dept.getName());

                }

                String metrocentername = "";
                String metrocenterid = "";
                //1016 判断当前部门是否为中心级别level=2 ，如果不等于
                if (dept != null) {
                    if (dept.getLevel().equals("5")) {
                        metrocenterid = dept.getPid();
                        PlatformDepartment dept_p = platformDepartmentMapper.selectByPrimaryKey(Integer.parseInt(metrocenterid));//当前站点
                        if (dept != null) {//班组
                            metrocenterid = dept.getPid();
                            dept_p = platformDepartmentMapper.selectByPrimaryKey(Integer.parseInt(dept_p.getPid()));
                            if (dept_p != null) {//部门
                                metrocenterid = dept.getPid();
                                dept_p = platformDepartmentMapper.selectByPrimaryKey(Integer.parseInt(dept_p.getPid()));
                                if (dept_p != null) {//中心
                                    metrocenterid = dept.getPid();
                                    dept_p = platformDepartmentMapper.selectByPrimaryKey(Integer.parseInt(dept_p.getPid()));
                                    if (dept_p != null) {
                                        metrocentername = dept_p.getName();
                                    }
                                }
                            }
                        }

                    } else if (dept.getLevel().equals("4")) {
                        metrocenterid = dept.getPid();
                        PlatformDepartment dept_p = platformDepartmentMapper.selectByPrimaryKey(Integer.parseInt(metrocenterid));
                        if (dept_p != null) {//部门
                            metrocenterid = dept.getPid();
                            dept_p = platformDepartmentMapper.selectByPrimaryKey(Integer.parseInt(dept_p.getPid()));
                            if (dept_p != null) {//中心
                                metrocenterid = dept.getPid();
                                dept_p = platformDepartmentMapper.selectByPrimaryKey(Integer.parseInt(dept_p.getPid()));
                                if (dept_p != null) {
                                    metrocentername = dept_p.getName();
                                }
                            }
                        }


                    } else if (dept.getLevel().equals("3")) {
                        metrocenterid = dept.getPid();
                        PlatformDepartment dept_p = platformDepartmentMapper.selectByPrimaryKey(Integer.parseInt(metrocenterid));
                        if (dept_p != null) {
                            metrocentername = dept_p.getName();
                        }
                    } else if (dept.getLevel().equals("2")) {
                        metrocenterid = String.valueOf(dept.getId());
                        metrocentername = dept.getName();
                    } else {
                        metrocenterid = dept.getPid();
                        PlatformDepartment dept_p = platformDepartmentMapper.selectByPrimaryKey(Integer.parseInt(metrocenterid));
                        if (dept_p != null) {
                            metrocentername = dept_p.getName();
                        }

                    }
                }
                if (!StringUtils.isEmpty(metrocentername) && !StringUtils.isEmpty(metrocenterid)) {
                    add_list.get(i).setMetrocentername(metrocentername);
                    add_list.get(i).setMetrocenterid(metrocenterid);
                }
                //默认赋予新用户普通用户角色
                PlatformSysUserRole sysUserRole = new PlatformSysUserRole(StrUtil.makePramykey(), num, "1");
                sysUserRoles.add(sysUserRole);

            }
            //更新
            platformNumber.setNum(num + 1);
            platformNumberMapper.updateByPrimaryKeySelective(platformNumber);
            //插入临时表0729
            platformPersonnelMapper.batchTemporaryInsert(add_list);
            //插入正式表
            result_stauts1 = platformPersonnelMapper.batchInsert(add_list);
            //插入角色
            platformSysUserRoleMapper.batchInsert(sysUserRoles);
            if (result_stauts1 > 0) {
                //更新部门id0729
                this.updateUserDept();
            }
        }

        //更新
        if (update_list != null && update_list.size() > 0) {
            for (int i = 0; i < update_list.size(); i++) {
                userlist = userlist +"up=>"+ update_list.get(i).getAccount();
            }
            //插入临时表0729
            result_status2 = platformPersonnelMapper.updateTemporaryBatch(update_list);
            if (result_status2 > 0) {
                //更新部门id0729
                this.updateUserDept();
            }
        }
        //插入更新记录
        Weixinuserupdateinfo weixinuserupdateinfo = new Weixinuserupdateinfo();
        weixinuserupdateinfo.setId(DateUtil.getNumberByDateTime());
        weixinuserupdateinfo.setUpdatetime(DateUtil.getCurTime());
        weixinuserupdateinfo.setCount(String.valueOf(list.size()));
        weixinuserupdateinfo.setType("1");
        weixinuserupdateinfo.setMemo(userlist);
        weixinuserupdateinfoMapper.insert(weixinuserupdateinfo);
        return 1;
    }

    @Override
//    @CacheEvict(value = "viewDeptall", key = "'tree'")//清除组织树结构的缓存
    public int updatePlatformpersonnel_del(List<PlatformPersonnel> list) {
        if (list == null || list.size() == 0) {
            return 1;
        }
        log.info("共有[" + list.size() + "条数据进行了更新!]");
        int result_status2 = 0;
        //更新
        if (list != null && list.size() > 0) {
            //更新主表状态
            result_status2 = platformPersonnelMapper.updateDelTemporaryBatch(list);
        }
        //插入更新记录
        Weixinuserupdateinfo weixinuserupdateinfo = new Weixinuserupdateinfo();
        weixinuserupdateinfo.setId(DateUtil.getNumberByDateTime());
        weixinuserupdateinfo.setUpdatetime(DateUtil.getCurTime());
        weixinuserupdateinfo.setCount(String.valueOf(list.size()));
        weixinuserupdateinfo.setType("4");
        weixinuserupdateinfoMapper.insert(weixinuserupdateinfo);
        return 1;
    }

    @Override
    public void insertWeixinUserUpdateInfo() {
        Weixinuserupdateinfo weixinuserupdateinfo = new Weixinuserupdateinfo();
        weixinuserupdateinfo.setId(DateUtil.getNumberByDateTime());
        weixinuserupdateinfo.setUpdatetime(DateUtil.getCurTime());
        weixinuserupdateinfo.setCount("-1");
        weixinuserupdateinfo.setType("1");
        weixinuserupdateinfoMapper.insert(weixinuserupdateinfo);
    }

    /**
     * 同步微信昵称
     *
     * @return
     */
    @Override
    public int synchronousAvatar() {
        int flag = 1;
        this.updateUserDeptFormal();
        return flag;
    }

    @Override
    public boolean checkpassword(String password, String token) {
        boolean flag = false;
        UserDetail userDetail = jwtTokenUtil.getUserFromToken(token);
        PlatformPersonnel entity = platformPersonnelMapper.selectByAccount(userDetail.getUsername());
        //BCryptPasswordEncoder encoder = new BCryptPasswordEncoder();
        flag = new MyPasswordEncoder().matches(password, entity.getPassword());
//        final   String password_old=encoder.encode(password);
//        if (password_old.equals(entity.getPassword()))  flag=true;
        return flag;
    }

    @Override
    public boolean updatepassword(String password, String token) {
        boolean flag = false;
        UserDetail userDetail = jwtTokenUtil.getUserFromToken(token);
        PlatformPersonnel entity = platformPersonnelMapper.selectByAccount(userDetail.getUsername());
        //BCryptPasswordEncoder encoder = new BCryptPasswordEncoder();
        final String password_old = BCryptMD5.encode(password);
        entity.setPassword(password_old);
        int count = platformPersonnelMapper.updateByPrimaryKey(entity);
        if (count > 0) {
            flag = true;
        }
        return flag;
    }

    @Override
    public boolean updatePasswordByUserid(String password, String id) {

        boolean flag = false;
        final String password_new = BCryptMD5.encode(password);
        int f = platformPersonnelMapper.updatePasswordByUserid(password_new, id);
        if (f > 0) {
            flag = true;
        }
        return flag;
    }

    /**
     * 从企业微信拉取用户信息
     *
     * @param userId userId
     * @return
     */
    @Override
    public boolean updateUserinfoByUserid(String userId, String branchCompanyId) {
        int flag = 0;
        boolean flagb = false;
        if (StringUtils.isNotEmpty(userId)) {
            PlatformPersonnel platformPersonnel = platformPersonnelMapper.selectByPrimaryKey(Integer.parseInt(userId));
            if (platformPersonnel != null) {

                //根据userid获取微信用户信息
                JSONObject obj = getSourceDataByAccount(Platform3Util.SOURCE_TYPE, platformPersonnel.getAccount());

                try {
                    if(StringUtils.isNotEmpty(branchCompanyId)) {
                        platformPersonnel.setBranchCompanyId(branchCompanyId);
                    }
                    platformPersonnel.setUsername(obj.get("name").toString());
                    platformPersonnel.setSex(Integer.parseInt(obj.get("gender").toString()));
                    platformPersonnel.setAccount(obj.get("userid").toString());
                    platformPersonnel.setPhoneNumber(obj.get("mobile").toString());
                    platformPersonnel.setTelNumber(obj.get("telephone").toString());
                    platformPersonnel.setEmail(obj.get("email").toString());
                    platformPersonnel.setNickname(obj.get("alias").toString());
                    if (obj.get("address") != null) {
                        platformPersonnel.setAddress(obj.get("address").toString());
                    }
                    String deptlist = obj.getString("department");
                    deptlist = deptlist.replace("[", "");
                    deptlist = deptlist.replace("]", "");
                    platformPersonnel.setDepartment(deptlist);
                    platformPersonnel.setDepartmentname(getdeptnameBydeptidlist(deptlist));
                    platformPersonnel.setPosition(obj.get("position").toString());
                    String is_leader_in_dept = obj.getString("is_leader_in_dept");
                    is_leader_in_dept = is_leader_in_dept.replace("[", "");
                    is_leader_in_dept = is_leader_in_dept.replace("]", "");
                    platformPersonnel.setIdentity(is_leader_in_dept);
                    // TODO 11.13增加更新字段
                    platformPersonnel.setUpdatetime(DateUtil.getCurTime());
                    platformPersonnel.setMaindepartment(obj.get("main_department").toString());
                    platformPersonnel.setQrcode(obj.get("qr_code").toString());
                    //账户状态 激活状态: 1=已激活，2=已禁用，4=未激活，5=退出企业。
                    String status = obj.getString("status");
                    if (status.equals("1")) {
                        platformPersonnel.setStatus("1");
                    } else {
                        platformPersonnel.setStatus("0");
                    }

                    platformPersonnel.setSynchronous("1");
                    if (obj.get("avatar") != null) {
                        String avatar = DownImageUtil.saveAvatar2File(obj.get("avatar").toString(), platformPersonnel.getAccount());
                        platformPersonnel.setAvatar(avatar);
                    }
                    //处理4 5 级部门 及 行政办公室下级部门无上级问题
                    //取当前部门信息
                    //10.27 判断下部门id是否为多个，如果为多个取第一个处理
                    String[] dplist = platformPersonnel.getDepartment().split(",");
                    String departmentid = "";
                    if (dplist.length > 0) {
                        departmentid = dplist[0];
                    }
                    // TODO 1
                    PlatformDepartment entity = platformDepartmentService.load(departmentid);
                    String metrocentername = "";
                    String metrocenterid = "";
                    //1016 判断当前部门是否为中心级别level=2 ，如果不等于


                    if (entity != null) {
                        //如果为pid=64 行政办公室   特殊处理
                        if ("64".equals(entity.getPid())) {
                            PlatformDepartment entity_parent = platformDepartmentService.load(entity.getPid());
                            platformPersonnel.setDepartment(entity_parent.getId().toString());
                            platformPersonnel.setDepartmentname(entity_parent.getName());
                            platformPersonnel.setMetrocenterid(entity_parent.getId().toString());
                            platformPersonnel.setMetrocentername(entity_parent.getName());
                            log.info("处理结果1：更新后dept=" + entity_parent.getPid());
                        } else {
                            PlatformDepartment entity_4 = platformDepartmentService.load(entity.getPid());
                            if ("2".equals(entity.getLevel())) {
                                platformPersonnel.setMetrocentername(entity.getName());
                                platformPersonnel.setMetrocenterid(String.valueOf(entity.getId()));
                                log.info("处理结果0：更新后dept=" + entity_4.getPid());
                            } else if ("3".equals(entity.getLevel())) {
//                        list.get(k).setDepartment(entity_4.getId().toString());
//                        list.get(k).setDepartmentname(entity_4.getName());
                                PlatformDepartment entity_p = platformDepartmentService.load(entity.getPid());
                                if (entity_p != null) {
                                    platformPersonnel.setMetrocentername(entity_p.getName());
                                    platformPersonnel.setMetrocenterid(String.valueOf(entity_p.getId()));
                                }
                                log.info("处理结果0：更新后dept=" + entity_4.getPid());
                            } else if ("4".equals(entity.getLevel()) && entity_4 != null) {
                                platformPersonnel.setDepartment(entity_4.getId().toString());
                                platformPersonnel.setDepartmentname(entity_4.getName());
                                PlatformDepartment entity_p = platformDepartmentService.load(entity_4.getPid());
                                if (entity_p != null) {
                                    platformPersonnel.setMetrocentername(entity_p.getName());
                                    platformPersonnel.setMetrocenterid(String.valueOf(entity_p.getId()));
                                }
                                log.info("处理结果2：更新后dept=" + entity_4.getPid());
                            } else if ("5".equals(entity.getLevel()) && entity_4 != null) {
                                PlatformDepartment entity_5 = platformDepartmentService.load(entity_4.getPid());
                                platformPersonnel.setDepartment(entity_5.getId().toString());
                                platformPersonnel.setDepartmentname(entity_5.getName());
                                PlatformDepartment entity_p = platformDepartmentService.load(entity_5.getPid());
                                if (entity_p != null) {
                                    platformPersonnel.setMetrocentername(entity_p.getName());
                                    platformPersonnel.setMetrocenterid(String.valueOf(entity_p.getId()));
                                }
                                log.info("处理结果3：更新后dept=" + entity_5.getPid());
                            }
//                        PlatformDepartment entity_4 = platformDepartmentService.load(entity.getPid());
//                        if ("4".equals(entity.getLevel()) && entity_4 != null) {
//                            platformPersonnel.setDepartment(entity_4.getId().toString());
//                            platformPersonnel.setDepartmentname(entity_4.getName());
//                            log.info("处理结果：更新后dept=" + entity_4.getPid());
//                        } else if ("5".equals(entity.getLevel()) && entity_4 != null) {
//                            metrocenterid=entity.getPid();
//                            PlatformDepartment dept_p = platformDepartmentMapper.selectByPrimaryKey(Integer.parseInt(metrocenterid));//当前站点
//
//                            PlatformDepartment entity_5 = platformDepartmentService.load(entity_4.getPid());
//                            platformPersonnel.setDepartment(entity_5.getId().toString());
//                            platformPersonnel.setDepartmentname(entity_5.getName());
//                            log.info("处理结果：更新后dept=" + entity_5.getPid());
//                        }
                        }
                    }
                    flag = platformPersonnelMapper.updateAllByAccount(platformPersonnel);
                    //TODO 单独更新时更新临时表，减少对比次数
                    if (flag > 0) {
                        platformPersonnelMapper.updateTempAllByAccount(platformPersonnel);
                    }
                    Weixinuserupdateinfo weixinuserupdateinfo = new Weixinuserupdateinfo();
                    weixinuserupdateinfo.setId(DateUtil.getNumberByDateTime());
                    weixinuserupdateinfo.setUpdatetime(DateUtil.getCurTime());
                    weixinuserupdateinfo.setCount("1");
                    weixinuserupdateinfo.setType("1");
                    weixinuserupdateinfo.setMemo(platformPersonnel.getAccount());
                    weixinuserupdateinfoMapper.insert(weixinuserupdateinfo);

                } catch (Exception e) {
                    e.printStackTrace();
                }

            }
        }
        if (flag > 0) {
            flagb = true;
        }
        return flagb;
    }
    private JSONObject getSourceDataByAccount(String sourceType, String account){
        JSONObject json = null;

        if(Platform3Util.SOURCE_TYPE_WECHAT.equals(sourceType)){
            String url = WX_ALL_USERINFO + SpringUtil.getBean(ApiConfig.class).getAccessToken_Tx() + "&userid=" + account;
            String wxuserinfo = httpAPIService.doGet(url);
            json = JSONUtil.getJSONFromString(wxuserinfo);
        }
        if(Platform3Util.SOURCE_TYPE_PLATFORM3.equals(sourceType)){
            JSONObject source = platform3Util.getUserByStaffCode(account);
            //改结构
            json = platform3Util.convertUser(source);
        }

        return json;
    }

    public String getdeptnameBydeptidlist(String deptidlist) {
        String deptnamelist = "";
        String[] list = deptidlist.split(",");

        for (int i = 0; i < list.length; i++) {
            PlatformDepartment platformDepartment = new PlatformDepartment();
            platformDepartment = platformDepartmentService.load(list[i]);
            if (platformDepartment != null && platformDepartment.getName() != null && !"".equals(platformDepartment.getName())) {
                if (i == 0) {
                    deptnamelist = platformDepartment.getName();
                } else {
                    deptnamelist = deptnamelist + "," + platformDepartment.getName();
                }

            }
        }


        return deptnamelist;
    }

    @Override
    @DataDictClass
    public PageInfo<PlatformPersonnel> pagedlistByToken(PlatformPersonnel platformPersonnel, int pageNum, int pageSize, String token) {
        UserDetail userDetail = jwtTokenUtil.getUserFromToken(token);
        PlatformPersonnel entity = platformPersonnelMapper.selectByAccount(userDetail.getUsername());
        PageHelper.startPage(pageNum, pageSize);
        PlatformPersonnelExample platformPersonnelExample = new PlatformPersonnelExample();
        PlatformPersonnelExample.Criteria criteria = platformPersonnelExample.createCriteria();

        if (!EmptyUtilHelper.isEmpty(entity.getAccount())) {
            criteria.andAccountLike(entity.getAccount());
        }


        List<PlatformPersonnel> list = platformPersonnelMapper.selectByExample(platformPersonnelExample);
        PageInfo<PlatformPersonnel> pageInfo = new PageInfo<>(list);

        return pageInfo;
    }

    @Override
    public boolean getweixinisleaderindeptByaccount() {
        this.synchronousIdentity();
        return true;
    }

    /**
     * 同步微信昵称
     */
    public void synchronousIdentity() {
        int flag = 0;
        try {
            JSONArray jsonArray = getSourceData("paltform3", "1", "1");

            if (jsonArray.size() > 0) {
                for (int i = 0; i < jsonArray.size(); i++) {
                    JSONObject obj = jsonArray.getJSONObject(i);
                    String account = obj.get("userid").toString();
                    String avatar = obj.get("avatar").toString();
//                    String identity=obj.get("is_leader_in_dept").toString();
                    String identity = obj.getString("is_leader_in_dept");
                    identity = identity.replace("[", "");
                    identity = identity.replace("]", "");
                    PlatformPersonnel platformPersonnel = new PlatformPersonnel();
                    platformPersonnel.setAccount(account);
                    platformPersonnel.setAvatar(avatar);
                    platformPersonnel.setIdentity(identity);
                    flag = platformPersonnelMapper.updateAvatarByAccount(platformPersonnel);
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void getUserDepartmentStatus() {
        PlatformPersonnelExample example = new PlatformPersonnelExample();
        List<PlatformPersonnel> list = platformPersonnelMapper.selectByExample(example);
        list.stream().forEach(t -> {
            this.saveUserDepartment(t.getId(), t.getDepartment(), t.getFuze());
        });

    }

    /**
     * 功能描述: 保存用户所属部门和负责部门
     * 〈〉
     *
     * @Param: [userid, userdept, usermanagerdipt]
     * @Author: zhouy
     * @Date: 2019-11-09 14:48
     */

    private void saveUserDepartment(int userid, String userdept, String usermanagerdipt) {

        //用户所属部门不为空时
        if (!EmptyUtilHelper.isEmpty(userdept)) {
            List<String> deptlist = Arrays.asList(userdept.split(","));
            PlatformPersonnelDepartmentExample platformPersonnelDepartmentExample = new PlatformPersonnelDepartmentExample();
            PlatformPersonnelDepartmentExample.Criteria criteria = platformPersonnelDepartmentExample.createCriteria();
            criteria.andUseridEqualTo(userid);
            //先删除后新增
            platformPersonnelDepartmentMapper.deleteByExample(platformPersonnelDepartmentExample);
            deptlist.stream().forEach(t -> {
                if (!"".equals(t)) {
                    PlatformPersonnelDepartment platformPersonnelDepartment = new PlatformPersonnelDepartment();
                    platformPersonnelDepartment.setId(StrUtil.makePramykey());
                    platformPersonnelDepartment.setUserid(userid);
                    platformPersonnelDepartment.setDepartment(Integer.parseInt(t));
                    platformPersonnelDepartmentMapper.insert(platformPersonnelDepartment);
                }

            });
        }

        //用户负责部门不为空时
        if (!EmptyUtilHelper.isEmpty(usermanagerdipt)) {
            List<String> managerdeptlist = Arrays.asList(usermanagerdipt.split(","));
            PlatformPersonnelManagerdeptExample platformPersonnelManagerdeptExample = new PlatformPersonnelManagerdeptExample();
            PlatformPersonnelManagerdeptExample.Criteria criteria = platformPersonnelManagerdeptExample.createCriteria();
            criteria.andUseridEqualTo(userid);
            //先删除后新增
            platformPersonnelManagerdeptMapper.deleteByExample(platformPersonnelManagerdeptExample);
            managerdeptlist.stream().forEach(t -> {
                PlatformPersonnelManagerdept platformPersonnelManagerdept = new PlatformPersonnelManagerdept();
                platformPersonnelManagerdept.setId(StrUtil.makePramykey());
                platformPersonnelManagerdept.setUserid(userid);
                platformPersonnelManagerdept.setDepartment(Integer.parseInt(t));
                platformPersonnelManagerdeptMapper.insert(platformPersonnelManagerdept);

            });
        }

    }

//    @Override
//    public DepartmentPersonneDTO getDepartmentPersonneDTO2(String dept){
//        DepartmentPersonneDTO dto = new DepartmentPersonneDTO();
//        //获取所有组织部门
//        DepartmentExample de = new DepartmentExample();
//        de.setOrderByClause(" id asc ");
//        List<DepartmentPersonneDTO> deptlist = departmentMapper.getDepartmentPersonneDTOList(de);
//        //获取所有部门员工
//        PersonnelExample pe = new PersonnelExample();
//        pe.setOrderByClause(" id asc ");
//        List<PersonneDTO> personnellist = personnelMapper.getDepartmentPersonneDTOList(pe);
//
//        //构造数据
//        if("".equals(dept)){
//            for (int i = 0; i < deptlist.size(); i++) {
//                if ("0".equals(deptlist.get(i).getPid())){
//                    dto = deptlist.get(i);
//                    break;
//                }
//            }
//        }else{
//            dto = departmentMapper.selectByPrimaryKey2(Integer.parseInt(dept));
//            dto.setChildren(new ArrayList<Object>());
//        }
//
//        //首先将人员放到部门下
//        for (int i = 0; i < deptlist.size(); i++) {
//            DepartmentPersonneDTO dtoa = deptlist.get(i);
//            String id = dtoa.getId().toString();
//            List<Object> childlist = new ArrayList<Object>();
//            for (int k = 0; k < personnellist.size(); k++) {
//                List<String> result = Arrays.asList(personnellist.get(k).getPid().split(","));
//                for (int j=0;j<result.size();j++){
//                    if (id.equals(result.get(j))){
//                        PersonneBaseDTO baseDTO = new PersonneBaseDTO(personnellist.get(k));
//                        childlist.add(baseDTO);
//                        personnellist.remove(personnellist.get(k));
//                        k--;
//                    }
//                }
//
//
//            }
//            dtoa.setPeople(childlist);
//            dtoa.setChildren(new ArrayList<Object>());
//        }
//
//        //将部门放在部门下
//        dto = this.getDepartmentPersonneDTO(dto,deptlist);
//
//
//        return dto;
//    }

    public DepartmentPersonneDTO getDepartmentPersonneDTO(DepartmentPersonneDTO dto, List<DepartmentPersonneDTO> list) {
        for (int i = 0; i < list.size(); i++) {
            if (dto.getId().toString().equals(list.get(i).getPid())) {
                DepartmentPersonneDTO cu = list.get(i);
                if (dto.getChildren() == null) {
                    dto.setChildren(new ArrayList<Object>());
                }
                dto.getChildren().add(cu);
                this.getDepartmentPersonneDTO(cu, list);
            }

        }
        return dto;
    }

    @Override
    public DepartmentPersonneDTO getDepartmentPersonneDTO() {
        DepartmentPersonneDTO dto = new DepartmentPersonneDTO();
        //获取所有组织部门
        DepartmentExample de = new DepartmentExample();
        de.setOrderByClause(" id asc ");
        List<DepartmentPersonneDTO> deptlist = departmentMapper.getDepartmentPersonneDTOList(de);
        //获取所有部门员工
        PersonnelExample pe = new PersonnelExample();
        pe.setOrderByClause(" ordernum asc ");
        List<PersonneDTO> personnellist = personnelMapper.getDepartmentPersonneDTOList(pe);
        //构造数据
        for (int i = 0; i < deptlist.size(); i++) {
            if ("0".equals(deptlist.get(i).getPid())) {
                dto = deptlist.get(i);
                break;
            }
        }
        //首先将人员放到部门下
        for (int i = 0; i < deptlist.size(); i++) {
            DepartmentPersonneDTO dtoa = deptlist.get(i);
            String id = dtoa.getId().toString();
            List<Object> childlist = new ArrayList<Object>();
            for (int k = 0; k < personnellist.size(); k++) {
                List<String> result = Arrays.asList(personnellist.get(k).getPid().split(","));
                for (int j = 0; j < result.size(); j++) {
                    if (id.equals(result.get(j))) {
                        PersonneBaseDTO baseDTO = new PersonneBaseDTO(personnellist.get(k));
                        childlist.add(baseDTO);
                        personnellist.remove(personnellist.get(k));
                        k--;
                    }
                }

            }
            dtoa.setChildren(childlist);
        }

        //将部门放在部门下
        dto = this.getDepartmentPersonneDTO(dto, deptlist);
        return dto;
    }

    @Override
    public void wixinAvatar2loaclFileBatch() {
        //获取全部用户
        PlatformPersonnelExample platformPersonnelExample = new PlatformPersonnelExample();
        List<PlatformPersonnel> list = platformPersonnelMapper.selectByExample(platformPersonnelExample);
        for (PlatformPersonnel platformPersonnel : list) {
            platformPersonnel.setAvatar(DownImageUtil.saveAvatar2File(platformPersonnel.getAvatar(), platformPersonnel.getAccount()));
        }
        if (!CollectionUtils.isEmpty(list)) {
            platformPersonnelMapper.updateBatchAvatar(list);
        }

    }

    /**
     * 更新用户的后来增加的中心
     */
    @Override
    public void updateMetroCenter() {
        //所有部门
        DepartmentExample de = new DepartmentExample();
        de.setOrderByClause(" id asc ");
        List<DepartmentPersonneDTO> deptlist = departmentMapper.getDepartmentPersonneDTOList(de);
        //所有人
        PlatformPersonnelExample platformPersonnelExample = new PlatformPersonnelExample();
        List<PlatformPersonnel> list = platformPersonnelMapper.selectByExample(platformPersonnelExample);
        for (PlatformPersonnel platformPersonnel : list) {
            String deptId = platformPersonnel.getDepartment();
            if (StringUtils.isEmpty(deptId)) {
                continue;
            }
            Map<String, String> map = getCenterIdStr(deptId, deptlist);
            String centerId = map.get("centerid");
            String centerName = map.get("centername");
            platformPersonnel.setMetrocenterid(centerId);
            platformPersonnel.setMetrocentername(centerName);
        }

        //更新中心
        platformPersonnelMapper.centerUpdateBatch(list);

    }

    /**
     * zhouhaifeng20201022
     * 根据部门ID获得用户的中心ID
     *
     * @param dept
     * @return
     */

    public Map<String, String> getCenterIdStr(String dept, List<DepartmentPersonneDTO> deptlist) {
        Map<String, String> res = new HashMap<>(2);
        res.put("centerid", "");
        res.put("centername", "");
        if (org.springframework.util.StringUtils.isEmpty(dept)) {
            return res;
        }
        if (!"1".equals(dept)) {
            String[] id = dept.split(",");
            List<String> result = Arrays.asList(id);
            List<String> centeridlist = new ArrayList<>();
            List<String> centerNamelist = new ArrayList<>();
            result.forEach(t -> {
                DepartmentPersonneDTO department = getCenter(t, deptlist);
                if (department != null) {
                    String centerId = department.getId().toString();
                    String centerName = department.getLabel();
                    if (!org.springframework.util.StringUtils.isEmpty(centerId) && !centeridlist.contains(centerId)) {//中心不空
                        centeridlist.add(centerId);
                        centerNamelist.add(centerName);
                    }
                }
            });
            String centerid = centeridlist.stream().collect(Collectors.joining(","));
            String centerName = centerNamelist.stream().collect(Collectors.joining(","));
            res.put("centerid", centerid);
            res.put("centername", centerName);

        }
        return res;
    }

    /**
     * 根据部门id返回中心
     *
     * @param dept
     * @return
     */

    public DepartmentPersonneDTO getCenter(String dept, List<DepartmentPersonneDTO> deptlist) {
        Integer in = Integer.parseInt(dept);
        Optional<DepartmentPersonneDTO> optional = deptlist.stream().filter(item -> in.equals(item.getId())).findFirst();
        if (!optional.isPresent()) {
            return null;
        }
        DepartmentPersonneDTO dpt = optional.get();
        if ("1".equals(dpt.getPid()) || "0".equals(dpt.getPid())) {
            return dpt;
        } else {
            dpt = this.getCenter(dpt.getPid(), deptlist);
        }
        return dpt;
    }

    @Override
    public PlatformPersonnel getPlatformPersonnelByUserid(int userid) {
        PlatformPersonnel entity = platformPersonnelMapper.selectByPrimaryKey(userid);
        return entity;
    }

    /**
     * 企业微信异步请求，更新通讯录信息
     * 3m23d
     *
     * @param UserID
     * @param ChangeType
     * @return
     */
    @Override
    public int updatePlatformpersonnelFromweixin(String UserID, String NewUserID, String ChangeType, Integer insertUserId, String branchCompanyId) {
        int flag = 0;
        //ChangeType: update_user 更新信息  delete_user 删除信息  create_user 新创建
        if (ChangeType.equals("create_user")) {

            //微信新增，系统内存在。则重新启用
            PlatformPersonnel personnel = platformPersonnelMapper.selectByAccount(UserID);
            if(null!=personnel){
                platformPersonnelMapper.updateStatusByAccount(personnel.getAccount());
            }else{
                //1.根据工号创建基本账户
                PlatformPersonnel platformPersonnel = getPlatformPersonnel(UserID);
                platformPersonnel.setId(insertUserId);
                platformPersonnel.setSynchronous("1");
                final String rawPassword = platformPersonnel.getPassword();
                //BCryptMD5为自定义加密处理
                platformPersonnel.setPassword(BCryptMD5.encode(rawPassword));
                platformPersonnel.setAddtime(DateUtil.smartFormat(new Date()));
                if(StringUtils.isNotEmpty(branchCompanyId)) {
                    platformPersonnel.setBranchCompanyId(branchCompanyId);
                }

                platformPersonnelMapper.insert(platformPersonnel);

                //默认赋予新用户普通用户角色
                platformSysUserRoleMapper.insert(new PlatformSysUserRole(StrUtil.makePramykey(), insertUserId, "1"));

                //给副表新增，避免定时任务表任务弄重复
//            int res2=0;
//            if (res>0){
//                PlatformPersonnel platformPersonnel2=platformPersonnelMapper.selectTemByAccount(platformPersonnel.getAccount());
//                if (platformPersonnel2==null){
//                     res2=platformPersonnelMapper.insert_tmp(platformPersonnel);
//                    log.info("副表新增用户"+UserID+"新增结果===="+res2);
//                }else{
//                    log.info("副表已有用户"+UserID+"新增结果失败====");
//                }
//
//            }
//            if (res2>0){
//                platformPersonnel=platformPersonnelMapper.selectByAccount(platformPersonnel.getAccount());
//                //根据工号重新拉取微信信息，密码未更新默认12345678
//                boolean res1=this.updateUserinfoByUserid(String.valueOf(platformPersonnel.getId()));
//                log.info("新增用户"+UserID+"同步结果===="+res1);
//            }

                platformPersonnel=platformPersonnelMapper.selectByAccount(platformPersonnel.getAccount());
                //根据工号重新拉取微信信息，密码未更新默认12345678
               this.updateUserinfoByUserid(String.valueOf(platformPersonnel.getId()), branchCompanyId);
            }
        } else if (ChangeType.equals("update_user")) {
            PlatformPersonnel entity = platformPersonnelMapper.findUserInfoByAccount(UserID);
            if(StringUtils.isNotEmpty(NewUserID)){
                // 更改主表account 工号
                entity.setAccount(NewUserID);
                if (StringUtils.isNotEmpty(branchCompanyId)) {
                    entity.setBranchCompanyId(branchCompanyId);
                }
                platformPersonnelMapper.updateByPrimaryKey(entity);
            }
            this.updateUserinfoByUserid(entity.getId().toString(), branchCompanyId);//account 工号未变更，直接拉取信息
//            if (entity != null) {
//                // 先判断是否更换工号，先更换工号，在更新基本信息
//                if (!StringUtils.isEmpty(NewUserID)) {
//                    entity.setAccount(NewUserID);
//                    int re = platformPersonnelMapper.updateByPrimaryKey(entity);// 更改主表account 工号
//                    int re4 = platformPersonnelMapper.updateTemporaryAccountByid(entity.getId(), NewUserID);// 更改临时表account 工号
//                    log.info("工号变更 " + UserID + "====>" + NewUserID + "结果：" + re + "===" + re4);
//                    if (re > 0) {
//                        flag = 1;
//                    }
//                } else {
//                    flag = 1;
//                }
//                if (flag > 0) {
//                    this.updateUserinfoByUserid(entity.getId().toString());//account 工号未变更，直接拉取信息
//                }
//            }
        } else if (ChangeType.equals("delete_user")) {
            int re1 = platformPersonnelMapper.updateDelstatusByAccount(UserID);// 更新主表，改为不启用，标注为删除
//            int re2 = platformPersonnelMapper.updateTemporaryDelstatusByAccount(UserID);// 更新临时表，改为不启用，标注为删除
//            if (re1 > 0 && re2 > 0) {
//                flag = 1;
//                log.info("更具userid删除主、附表数据 re1 re2" + UserID + ":" + re1 + "====" + re2);
//            }
        }
        Weixinuserupdateinfo weixinuserupdateinfo = new Weixinuserupdateinfo();
        weixinuserupdateinfo.setId(DateUtil.getNumberByDateTime());
        weixinuserupdateinfo.setUpdatetime(DateUtil.getCurTime());
        weixinuserupdateinfo.setCount("1");
        weixinuserupdateinfo.setType(ChangeType);
        weixinuserupdateinfo.setMemo(UserID);
        weixinuserupdateinfoMapper.insert(weixinuserupdateinfo);
        return flag;
    }

    @NotNull
    private PlatformPersonnel getPlatformPersonnel(String UserID) {
        PlatformPersonnel platformPersonnel=new PlatformPersonnel();
        platformPersonnel.setAccount(UserID);
        platformPersonnel.setUsername("新增");
        platformPersonnel.setBirthday("");
        platformPersonnel.setPassword("SYdite@!QAZ2022");
        platformPersonnel.setEmail("sydt@163.com");
        platformPersonnel.setDepartment("");
        platformPersonnel.setDepartmentname("");
        platformPersonnel.setPaizhu("0");
        platformPersonnel.setSynchronous("1");
        platformPersonnel.setStatus("0");
        platformPersonnel.setIsadmin(0);
        return platformPersonnel;
    }
}
