package com.metro.auth.platform.wxmessage;

import com.alibaba.fastjson.JSONObject;

import com.metro.auth.platform.domain.WebUserToken;
import com.metro.auth.platform.http.HttpAPIService;
import com.metro.auth.platform.utils.EmptyUtilHelper;
import com.metro.auth.platform.utils.JSONMap;
import com.metro.auth.platform.utils.JSONUtil;
import com.metro.auth.platform.utils.SpringUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * @ClassName: GetWxUserinfo
 * @Description: ${description}
 * @Authror zhouy
 * @Date 2019-07-23 19:34
 */
@Slf4j
@RestController
public class GetWxUserinfo {
    //中心
    private static final String CENTER_ID="cid";
    private static final String CENTER_NAME="cname";
    //部门
    private static final String DEPT_ID="did";
    private static final String DEPT_NAME="dname";

    @Value("${weixin-params.wx_getuserinfo}")
    private String WX_GETUSERINFO;
    @Value("${weixin-params.wx_all_userinfo}")
    private  String WX_ALL_USERINFO;


    /**
     *  #创建微信用户
     */
    @Value("${weixin-params.wx_user_create}")
    private  String WX_USER_CREATE;
    @Value("${weixin-params.wx_user_get}")
    private  String WX_USER_GET;
    @Value("${weixin-params.wx_user_delete}")
    private  String WX_USER_DELETE;
    @Value("${weixin-params.wx_user_update}")
    private  String WX_USER_UPDATE;
    @Value("${weixin-params.wx_user_dept_detail}")
    private  String WX_USER_DEPT_DETAIL;

    @Resource
    public HttpAPIService httpAPIService;

    /**
     * 功能描述: <br>微信获得用户、角色信息
     * 〈〉
     * @Param: [code]
     * @Return: [code]
     * @Author: zhouy
     * @Date: 2019-07-23 20:21
     */
    @GetMapping("/weixin/wxuserinfo/{code}")
    public @ResponseBody
    JSONMap<String,Object> wxuserinfo(@PathVariable String code){
        JSONMap<String,Object> model = new JSONMap<String,Object>();
        String url = WX_GETUSERINFO+ SpringUtil.getBean(ApiConfig.class).getAccessToken()+"&code="+code;
        log.info("构建URL为=="+url);
        String userId= "";
        try{
            String wxuserinfo = httpAPIService.doGet(url);
            log.info("wxuserinf 为===" +wxuserinfo);
            String errmsg = (String) JSONUtil.getStringFromJSONObject(wxuserinfo,"errmsg");
            if("ok".equals(errmsg)){
                userId = (String) JSONUtil.getStringFromJSONObject(wxuserinfo,"UserId");
            }
            model.put("opflag", Boolean.valueOf(true));
            model.put("userid", userId);
        }catch(Exception e){
            model.put("opflag", Boolean.valueOf(false));
            model.put("opmessage", "获取用户信息失败");
            e.printStackTrace();
        }
        return model;
    }

    /**
     * 功能描述: <br>根据用户ID获得用户信息
     * 〈〉
     * @Param: []
     * @Return: []
     * @Author: zhouy
     * @Date: 2019-07-29 15:33
     */
    @GetMapping("/weixin/information/{userId}")
    public WebUserToken getWeixinUserByUserId(@PathVariable String userId){

        WebUserToken webUserToken = new WebUserToken();
        String token = SpringUtil.getBean(ApiConfig.class).getAccessToken();
        String url =WX_ALL_USERINFO+token+"&userid="+userId;
        try {
            String wxuserinfo = httpAPIService.doGet(url);
            log.info("用户微信端信息为===="+wxuserinfo);
            JSONObject json = JSONUtil.getJSONFromString(wxuserinfo);
            webUserToken.setPlatformUsernum(json.getString("userid"));
            webUserToken.setUsername(json.getString("name"));
            webUserToken.setPosition(json.getString("position"));
            webUserToken.setPhoneNumber(json.getString("mobile"));
            String department= json.getString("department");
            if(!EmptyUtilHelper.isEmpty(department)){
                department= department.substring(1,department.length()-1);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return webUserToken;
    }
    /**
     * 新增微信用户
     */
    @PostMapping("/weixin/wxuserinfo/add")
    public @ResponseBody
    JSONMap<String,Object> wxuserinfo(WebUserToken webUserToken){
        JSONMap<String,Object> model = new JSONMap<String,Object>();
        JSONObject object = new JSONObject();
        object.put("userid",webUserToken.getUserId());//成员UserID。对应管理端的帐号，企业内必须唯一。不区分大小写，长度为1~64个字节。只能由数字、字母和“_-@.”四种字符组成，且第一个字符必须是数字或字母。*
        object.put("name",webUserToken.getName());//成员名称。长度为1~64个utf8字符*
        object.put("alias",webUserToken.getAlias());//成员别名。长度1~32个utf8字符
        object.put("mobile",webUserToken.getMobile());//手机号码。企业内必须唯一，mobile/email二者不能同时为空
        object.put("department",webUserToken.getDepartment());//成员所属部门id列表,不超过20个 *
        object.put("order",webUserToken.getOrder());//部门内的排序值，默认为0，成员次序以创建时间从小到大排列。数量必须和department一致，数值越大排序越前面。有效的值范围是[0, 2^32)
        object.put("position",webUserToken.getPosition());//职务信息。长度为0~128个字符
        object.put("gender",webUserToken.getGender());//性别。1表示男性，2表示女性
        object.put("email",webUserToken.getEmail());//邮箱 长度6~64个字节，且为有效的email格式
        object.put("telephone",webUserToken.getTelephone());//座机。32字节以内，由纯数字或’-‘号组成。
        object.put("is_leader_in_dept",webUserToken.getIs_leader_in_dept());//个数必须和department一致，表示在所在的部门内是否为上级。1表示为上级，0表示非上级。在审批等应用里可以用来标识上级审批人
        object.put("avatar_mediaid",webUserToken.getAvatar_mediaid());//成员头像的mediaid，通过素材管理接口上传图片获得的mediaid
        object.put("enable",webUserToken.getEnable());//启用/禁用成员。1表示启用成员，0表示禁用成员
        object.put("extattr",webUserToken.getExtattr());//自定义字段。
        object.put("to_invite",webUserToken.getTo_invite());//是否邀请该成员使用企业微信。
        object.put("external_profile",webUserToken.getExternal_profile());//成员对外属性，字段详情见对外属性。
        object.put("external_position",webUserToken.getExternal_position());//对外职务，如果设置了该值，则以此作为对外展示的职务，否则以position来展示。长度12个汉字内。
        object.put("address",webUserToken.getAddress());//地址。长度最大128个字符
        String url = WX_USER_CREATE+ SpringUtil.getBean(ApiConfig.class).getAccessToken_Tx();
        log.info("构建URL为=="+url);
        log.info("构建object为=="+object);
        String userId= "";
        try{
            JSONObject wxuserinfo = httpAPIService.doPost(url,object.toString());
            log.info("wxuserinf 为===" +wxuserinfo);
            String errmsg = wxuserinfo.getString("errmsg");
            if("created".equals(errmsg)){
                log.info("创建微信信息状态===="+errmsg);
            }
        }catch(Exception e){
            e.printStackTrace();

        }
        return model;
    }
    /**
     * 读取微信用户
     */
    @GetMapping("/weixin/wxuserinfo/get")
    public @ResponseBody
    JSONMap<String,Object> getwxuserinfo(WebUserToken webUserToken) {
        JSONMap<String,Object> model = new JSONMap<String,Object>();
        String url = WX_USER_GET + SpringUtil.getBean(ApiConfig.class).getAccessToken_Tx() + "&userid=" + webUserToken.getUserId();
        log.info("构建URL为==" + url);
        try {
            String wxuserinfo = httpAPIService.doGet(url);
            JSONObject json = JSONUtil.getJSONFromString(wxuserinfo);
            log.info("wxuserinfo 为===" + wxuserinfo);
            model.put("wxuserinfo",wxuserinfo);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return model;
    }
    /**
     * 更新微信用户
     */
    @PostMapping("/weixin/wxuserinfo/update")
    public @ResponseBody
    JSONMap<String,Object> updatewxuserinfo(WebUserToken webUserToken){
        JSONMap<String,Object> model = new JSONMap<String,Object>();
        JSONObject object = new JSONObject();
        object.put("userid",webUserToken.getUserId());//成员UserID。对应管理端的帐号，企业内必须唯一。不区分大小写，长度为1~64个字节。只能由数字、字母和“_-@.”四种字符组成，且第一个字符必须是数字或字母。*
        object.put("name",webUserToken.getName());//成员名称。长度为1~64个utf8字符*
        object.put("alias",webUserToken.getAlias());//成员别名。长度1~32个utf8字符
        object.put("mobile",webUserToken.getMobile());//手机号码。企业内必须唯一，mobile/email二者不能同时为空
        object.put("department",webUserToken.getDepartment());//成员所属部门id列表,不超过20个 *
        object.put("order",webUserToken.getOrder());//部门内的排序值，默认为0，成员次序以创建时间从小到大排列。数量必须和department一致，数值越大排序越前面。有效的值范围是[0, 2^32)
        object.put("position",webUserToken.getPosition());//职务信息。长度为0~128个字符
        object.put("gender",webUserToken.getGender());//性别。1表示男性，2表示女性
        object.put("email",webUserToken.getEmail());//邮箱 长度6~64个字节，且为有效的email格式
        object.put("telephone",webUserToken.getTelephone());//座机。32字节以内，由纯数字或’-‘号组成。
        object.put("is_leader_in_dept",webUserToken.getIs_leader_in_dept());//个数必须和department一致，表示在所在的部门内是否为上级。1表示为上级，0表示非上级。在审批等应用里可以用来标识上级审批人
        object.put("avatar_mediaid",webUserToken.getAvatar_mediaid());//成员头像的mediaid，通过素材管理接口上传图片获得的mediaid
        object.put("enable",webUserToken.getEnable());//启用/禁用成员。1表示启用成员，0表示禁用成员
        object.put("extattr",webUserToken.getExtattr());//自定义字段。
        object.put("to_invite",webUserToken.getTo_invite());//是否邀请该成员使用企业微信。
        object.put("external_profile",webUserToken.getExternal_profile());//成员对外属性，字段详情见对外属性。
        object.put("external_position",webUserToken.getExternal_position());//对外职务，如果设置了该值，则以此作为对外展示的职务，否则以position来展示。长度12个汉字内。
        object.put("address",webUserToken.getAddress());//地址。长度最大128个字符
        String url = WX_USER_UPDATE+ SpringUtil.getBean(ApiConfig.class).getAccessToken_Tx();
        log.info("构建URL为=="+url);
        log.info("构建object为=="+object);
        String userId= "";
        try{
            JSONObject wxuserinfo = httpAPIService.doPost(url,object.toString());
            log.info("wxuserinfo 为===" +wxuserinfo);
            String errmsg = wxuserinfo.getString("errmsg");
            if("updated".equals(errmsg)){
                log.info("创建微信信息状态===="+errmsg);
            }
            model.put("errmsg",errmsg);
        }catch(Exception e){
            e.printStackTrace();

        }
        return model;
    }
    /**
     * 删除微信用户
     */
    @GetMapping("/weixin/wxuserinfo/delete")
    public @ResponseBody
    JSONMap<String,Object> deletewxuserinfo(WebUserToken webUserToken) {
        JSONMap<String,Object> model = new JSONMap<String,Object>();
        String url = WX_USER_DELETE + SpringUtil.getBean(ApiConfig.class).getAccessToken_Tx() + "&userid=" + webUserToken.getUserId();
        log.info("构建URL为==" + url);
        try {
            String wxuserinfo = httpAPIService.doGet(url);
            JSONObject json = JSONUtil.getJSONFromString(wxuserinfo);
            log.info("errmsg 为===" + json.get("errmsg"));
            model.put("wxuserinfo",wxuserinfo);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return model;
    }
    /**
     * 批量删除用户
     */
    /**
     * 获取部门成员
     */

    /**
     * 获取部门成员详情
     */
    @GetMapping("/weixin/wxuserinfo/list_deptid")
    public @ResponseBody
    JSONMap<String,Object> wxuserinfolist(WebUserToken webUserToken) {
        JSONMap<String,Object> model = new JSONMap<String,Object>();
        String url = WX_USER_DEPT_DETAIL + SpringUtil.getBean(ApiConfig.class).getAccessToken_Tx() + "&department_id=" + webUserToken.getDepartment()+"&fetch_child=1";
        log.info("构建URL为==" + url);
        try {
            String wxuserinfo = httpAPIService.doGet(url);
            JSONObject json = JSONUtil.getJSONFromString(wxuserinfo);
            log.info("errmsg 为===" + json.get("errmsg"));
            model.put("wxuserinfo",wxuserinfo);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return model;
    }
}
