package com.metro.auth.platform.metrointerface;

import com.alibaba.fastjson.JSONObject;
import com.metro.auth.platform.domain.ResultJson;
import com.metro.auth.platform.domain.dto.MeetingDTO;
import com.metro.auth.platform.http.HttpAPIService;
import com.metro.auth.platform.outlineapi.PlatformUrlManager;
import com.metro.auth.platform.utils.SpringUtil;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * .::::.
 * .::::::::.
 * :::::::::::    佛主保佑、永无Bug
 * ..:::::::::::'
 * '::::::::::::'
 * .::::::::::
 * '::::::::::::::..
 * ..::::::::::::.
 * ``::::::::::::::::
 * ::::``:::::::::'        .:::.
 * ::::'   ':::::'       .::::::::.
 * .::::'      ::::     .:::::::'::::.
 * .:::'       :::::  .:::::::::' ':::::.
 * .::'        :::::.:::::::::'      ':::::.
 * .::'         ::::::::::::::'         ``::::.
 * ...:::           ::::::::::::'              ``::.
 * ```` ':.          ':::::::::'                  ::::..
 * '.:::::'                    ':'````..
 */

@RestController
@RequestMapping("/meeting")
public class MeetingController {

    @Resource
    private HttpAPIService httpAPIService;

    /**
     * 功能描述: <br>获取当天会议信息集合
     * 〈〉
     * @Author: lx
     */
    @GetMapping("/new")
    public ResultJson queryMeetingPageList(MeetingDTO meetingDTO){

        String url = SpringUtil.getBean(PlatformUrlManager.class).getPlatformURI(PlatformUrlManager.MEETING_NEW_URL);

        String result = null;
        try {
            result = httpAPIService.doGet(url + "?pageSize=" + meetingDTO.getPageSize() + "&pageIndex=" + meetingDTO.getPageIndex() + "&theme=" + meetingDTO.getTheme() + "&time=" + meetingDTO.getTime());
            if(!"".equals(result) && result != null){
                return ResultJson.ok(JSONObject.parseObject(result));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ResultJson.ok(result);
    }

    /**
     * 功能描述: <br>获取会议信息详情
     * 〈〉
     * @Author: lx
     */
    @GetMapping("/detail/{mtid}/{userid}")
    public ResultJson getMeetingInfoByMrid(@PathVariable String mtid,@PathVariable String userid){

        String url = SpringUtil.getBean(PlatformUrlManager.class).getPlatformURI(PlatformUrlManager.MEETING_DETAIL_URL);

        String result = null;
        try {
            result = httpAPIService.doGet(url + "/" + mtid + "/" + userid);
            if(!"".equals(result) && result != null){
                return ResultJson.ok(JSONObject.parseObject(result));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ResultJson.ok(result);
    }

    /**
     * 功能描述: <br>获取会议室信息集合
     * 〈〉
     * @Author: lx
     */
    @GetMapping("/room/{date}")
    public ResultJson queryMeetingRoomPageList(@PathVariable String date){

        String url = SpringUtil.getBean(PlatformUrlManager.class).getPlatformURI(PlatformUrlManager.CONFERENCE_ROOM_URL);

        String result = null;
        try {
            result = httpAPIService.doGet(url + "&date=" + date);
            if(!"".equals(result) && result != null){
                return ResultJson.ok(JSONObject.parseObject(result));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ResultJson.ok(result);
    }
    /**
     * 功能描述: <br>更新审批树缓存
     * 〈202-03-27〉
     * @Author: wy
     */
    @GetMapping("/updateRedis")
    public ResultJson updateRedis(){

        String url = SpringUtil.getBean(PlatformUrlManager.class).getPlatformURI(PlatformUrlManager.APPROVAL_URL);

        String result = null;
        try {
            result = httpAPIService.doGet(url );
            if(!"".equals(result) && result != null){
                return ResultJson.ok(JSONObject.parseObject(result));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ResultJson.ok(result);
    }

}
