package com.metro.auth.platform.service;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.domain.WebDeptToken;
import com.metro.auth.platform.domain.auth.*;
import com.metro.auth.platform.http.HttpAPIService;
import com.metro.auth.platform.mapper.PlatformPersonnelMapper;
import com.metro.auth.platform.mapper.PlatformSysAdvMapper;
import com.metro.auth.platform.mapper.PlatformNumberMapper;
import com.metro.auth.platform.utils.DateUtil;
import com.metro.auth.platform.utils.EmptyUtilHelper;
import com.metro.auth.platform.utils.JwtUtils;
import com.metro.auth.platform.utils.SpringUtil;
import com.metro.auth.platform.viewformat.DataDictClass;
import com.metro.auth.platform.wxmessage.ApiConfig;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

@Slf4j
@Service
public class PlatformSysAdvServiceImpl implements PlatformSysAdvService{
    @Resource
    private PlatformSysAdvMapper platformSysAdvMapper;
    private final JwtUtils jwtTokenUtil;
    public PlatformSysAdvServiceImpl(JwtUtils jwtTokenUtil) {
        this.jwtTokenUtil = jwtTokenUtil;
    }
    @Resource
    public HttpAPIService httpAPIService;
    @Override
    @DataDictClass
    public List<PlatformSysAdv> selectByExample(PlatformSysAdv platformSysAdv) {
        PlatformSysAdvExample example = new PlatformSysAdvExample();
        PlatformSysAdvExample.Criteria criteria=example.createCriteria();
        criteria.andTypeEqualTo(platformSysAdv.getType());
        example.setNum(Integer.parseInt( platformSysAdv.getNum()));
        return platformSysAdvMapper.selectByExample(example);
    }
    @Override
    @DataDictClass
    public List<PlatformSysAdv> selectByExampleForinterface(PlatformSysAdv platformSysAdv) {
        PlatformSysAdvExample example = new PlatformSysAdvExample();
        PlatformSysAdvExample.Criteria criteria=example.createCriteria();
        criteria.andTypeEqualTo(platformSysAdv.getType());
        criteria.andStatusEqualTo(platformSysAdv.getStatus());
        example.setOrderByClause("ctime desc");
        example.setNum(Integer.parseInt( platformSysAdv.getNum()));
        return platformSysAdvMapper.selectByExampleForinterface(example);
    }
    @Override
    public  int savePlatformSysAdv(PlatformSysAdv entity){
        int flag=0;
        Date d = new Date();
       //获取最新id
        String uuid = UUID.randomUUID().toString();
        uuid = uuid.replace("-", "");
        entity.setId(uuid);
        entity.setCtime(DateUtil.getCurTime());
            flag=platformSysAdvMapper.insert(entity);
        return flag;
        }
    /**
     *
     * @param entity
     * @return
     */
    @Override
    public  int saveUpdatePlatformSysAdv(PlatformSysAdv entity){
        int flag=0;
         flag=platformSysAdvMapper.updateByPrimaryKey(entity);
        return flag;
    }

    /**
     *
     * @param id
     * @return
     */
        @Override
        public int delPlatformSysAdv(String id){
            int flag=platformSysAdvMapper.deleteByPrimaryKey(id);

            return flag;
            }

    /**
     *根据id更新启用状态
     * @param entity
     * @return
     */
    @Override
            public  int updatePlatformSysAdvStatusById(PlatformSysAdv entity){
            int flag=0;
                //更改状态
               flag= platformSysAdvMapper.updateStatusByPrimaryKey(entity);
            return  flag;
            }

    /**
     *
     * @param platformSysAdv
     * @param pageNum
     * @param pageSize
     * @return
     */
    @Override
    @DataDictClass
        public PageInfo<PlatformSysAdv> pagedlist(PlatformSysAdv platformSysAdv, int pageNum, int pageSize) {

            PageHelper.startPage(pageNum, pageSize);
        PlatformSysAdvExample platformSysAdvExample = new PlatformSysAdvExample();
        PlatformSysAdvExample.Criteria criteria = platformSysAdvExample.createCriteria();
            //搜索
            if (platformSysAdv!=null){
                if (!EmptyUtilHelper.isEmpty(platformSysAdv.getTitle())){
                    criteria.andTitleLike( "%"+platformSysAdv.getTitle()+"%");
                }
            }
        platformSysAdvExample.setOrderByClause(" ctime desc");
            List<PlatformSysAdv> list=platformSysAdvMapper.selectByExample(platformSysAdvExample);
            PageInfo<PlatformSysAdv> pageInfo = new PageInfo<>(list);

            return pageInfo;
        }
        @Override
        public  PlatformSysAdv load(String id){
            PlatformSysAdv platformSysAdv=platformSysAdvMapper.selectByPrimaryKey(id);
            return  platformSysAdv;
        }
    /**
     * 批量启停，微信无操作
     * @param status
     * @param ids
     */
    @Override
    public void updateSysAdvStatus(String status,String ids) {

        String[] id = ids.split(",");
        for (int i=0;i<id.length;i++ ) {
            PlatformSysAdv platformSysAdv=platformSysAdvMapper.selectByPrimaryKey(id[i]);
            platformSysAdv.setStatus(status);
            int flag=platformSysAdvMapper.updateStatusByPrimaryKey(platformSysAdv);

        }
    }

}
