package com.metro.auth.platform.service;

import com.alibaba.fastjson.JSONObject;
import com.ctc.wstx.util.DataUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.config.BCryptMD5;
import com.metro.auth.platform.config.MyPasswordEncoder;
import com.metro.auth.platform.domain.WebUserToken;
import com.metro.auth.platform.domain.auth.*;
import com.metro.auth.platform.domain.dto.DepartmentPersonneDTO;
import com.metro.auth.platform.domain.dto.PersonneBaseDTO;
import com.metro.auth.platform.domain.dto.PersonneDTO;
import com.metro.auth.platform.domain.dto.ResultDTO;
import com.metro.auth.platform.domain.entity.DepartmentExample;
import com.metro.auth.platform.domain.entity.PersonnelExample;
import com.metro.auth.platform.http.HttpAPIService;
import com.metro.auth.platform.mapper.*;
import com.metro.auth.platform.utils.*;
import com.metro.auth.platform.viewformat.DataDictClass;
import com.metro.auth.platform.wxmessage.ApiConfig;
import com.metro.auth.platform.wxmessage.MessageSendType;
import com.metro.auth.platform.wxmessage.Messagesend;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

@Slf4j
@Service
public class WeixinUserUpdateInfoServiceImpl implements WeixinUserUpdateInfoService {
    private final JwtUtils jwtTokenUtil;
    @Resource
    private PlatformPersonnelMapper platformPersonnelMapper;
    @Resource
    private PlatformNumberMapper platformNumberMapper;
    @Resource
    private PlatformSysUserRoleMapper platformSysUserRoleMapper;
    @Resource
    private Messagesend messagesend;
    @Resource
    private PlatformPersonnelManagerdeptMapper platformPersonnelManagerdeptMapper;
    @Resource
    private PlatformPersonnelDepartmentMapper platformPersonnelDepartmentMapper;
    @Resource
    public HttpAPIService httpAPIService;
    @Resource
    private WeixinUserUpdateInfoService weixinUserUpdateInfoService;
    @Resource
    private WeixinuserupdateinfoMapper weixinuserupdateinfoMapper;

    public WeixinUserUpdateInfoServiceImpl(JwtUtils jwtTokenUtil) {
        this.jwtTokenUtil = jwtTokenUtil;
    }



    @Override
    public List<Weixinuserupdateinfo> selectByExample() {
        WeixinuserupdateinfoExample example = new WeixinuserupdateinfoExample();
        return weixinuserupdateinfoMapper.selectByExample(example);
    }

    @Override
    public Weixinuserupdateinfo selectOrderByUpdateDesc(String type) {
        return weixinuserupdateinfoMapper.selectOrderByUpdateDesc(type);
    }


    @Override
    public int saveAdd(Weixinuserupdateinfo weixinuserupdateinfo) {
        int count=0;
        count=weixinuserupdateinfoMapper.insert(weixinuserupdateinfo);

        return count;
    }

}