package com.metro.auth.platform.upload;

import com.metro.auth.platform.domain.dto.FileInfoDTO;
import com.metro.auth.platform.domain.dto.FileInfouploadDTO;
import com.metro.auth.platform.utils.CommonUtil;
import com.metro.auth.platform.utils.DownImageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import sun.misc.BASE64Decoder;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.nio.charset.StandardCharsets;

/**
 * @author jennifer
 */
@Slf4j
@Controller
@RequestMapping("/znzl/file")
public class FileController {

    public static  String FILE_MANAGER = "filemanager";

    /**
     * 文件上传
     * @author qijj
     * @param file
     * @param type
     * @return
     * @throws Exception
     */
    @PostMapping("/upload")
    public @ResponseBody
    FileInfoDTO upload(@RequestParam("file") MultipartFile file, @RequestParam("type") String type) throws Exception {
        type = type.toUpperCase();
        if("TEMP".equals(type)||"FOREVER".equals(type))
        {
            String fileRealName = file.getOriginalFilename();
            String filename=System.currentTimeMillis()+"."+file.getOriginalFilename().split("\\.")[1];
            String localPath = "/upload/img/";
            if("TEMP".equals(type))
            {
                localPath = "/upload/temp/";
            }
            File localFile = new File(CommonUtil.UPLOADFILEURL+"/"+FILE_MANAGER+"/"+localPath);
            String filePath= CommonUtil.WEBSITE+"/"+FILE_MANAGER+"/"+localPath+filename;//文件真实路径返回
            if (!localFile.exists()) {
                localFile.mkdirs();
            }
            localFile = new File(CommonUtil.UPLOADFILEURL+"/"+FILE_MANAGER+"/"+localPath, filename);
            file.transferTo(localFile);
            return new FileInfoDTO(filePath,localFile.getPath(),filename,fileRealName);
        }else {
            throw new Exception("上传参数type值错误，当前为"+type+"，期望值为TEMP 或 FOREVER，TEMP代表上传至临时目录，FOREVER 代表上传至持久保存目录！");
        }
    }

    /**
     * 根据文件在磁盘上的真实路径下载文件
     * @author qijj
     * @param fileRealPath
     * @param request
     * @param response
     * @return
     * @throws IOException
     */
    @PostMapping("/downFile")
    public ResponseEntity<byte[]> downFile(@RequestParam("fileRealPath") String fileRealPath, HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
        	File file=new File(fileRealPath);
        	HttpHeaders headers = new HttpHeaders();
            //为了解决中文名称乱码问题
        	String newFileName=new String(fileRealPath.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
        	headers.setContentDispositionFormData("attachment", newFileName);
        	headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        	return new ResponseEntity<byte[]>(FileUtils.readFileToByteArray(file),  headers, HttpStatus.CREATED);
		} catch (Exception e) {
			log.info("--------------------不存在路径为："+fileRealPath+"的文件--------------------");
		}
        return null;
    }  

    @GetMapping("/{id}")
    public void download(@PathVariable String id, HttpServletRequest request, HttpServletResponse response) {
        try (InputStream inputStream = new FileInputStream(new File(CommonUtil.UPLOADFILEURL, id + ".jpg"));
                OutputStream outputStream = response.getOutputStream()) {

            response.setContentType("application/x-download");
            response.addHeader("Content-Disposition", "attachment;filename=" + id + ".jpg");

            IOUtils.copy(inputStream, outputStream);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    
    /**
     * 上传文件，可自定义文件路径与文件名
     * @author lht
     * @param file
     * @param uploadPar  文件路径
     * @param filename   文件名
     * @return
     * @throws Exception
     */
    @PostMapping("/upload/videoandimgurl")
    public @ResponseBody FileInfoDTO uploadVideoandimgurl(@RequestParam("file") MultipartFile file,String uploadPar,String filename) throws Exception {
        if(uploadPar==null|| "".equals(uploadPar)){
            uploadPar = "file/";
        }
        if(filename==null|| "".equals(filename)){
            filename=String.valueOf(System.currentTimeMillis());
        }
        String name=file.getOriginalFilename();
        int index=name.lastIndexOf(".");
        String filetype=name.substring(index+1);
        filename=filename+"."+filetype;
        String uploadDir = CommonUtil.UPLOADFILEURL+"/"+FILE_MANAGER+"/"+uploadPar;
        File localFile = new File(uploadDir);
        //文件真实路径返回
        String fileRealPath=CommonUtil.WEBSITE+FILE_MANAGER+"/"+uploadPar+"/"+filename;

        if (!localFile.exists()) {
            localFile.mkdirs();
        }
        localFile = new File(uploadDir, filename);
        log.info(fileRealPath);
        file.transferTo(localFile);
        return new FileInfoDTO(fileRealPath,localFile.getPath(),filename,file.getOriginalFilename());
    }
    /**
     * 视频、图片转文件并上传服务器方法 wy
     * @param fileInfouploadDTO
     * @param request
     * @return
     */

    @PostMapping("/upload/uploadScanForNewClient")
    public @ResponseBody  String  uploadScanForNewClient(FileInfouploadDTO fileInfouploadDTO, HttpServletRequest request) {
        if (fileInfouploadDTO.getUploadPar() == null || "".equals(fileInfouploadDTO.getUploadPar())) {
            fileInfouploadDTO.setUploadPar("file");
        }
        String filename = System.currentTimeMillis() + "";
        filename= fileInfouploadDTO.getFilename();
        //文件真实路径返回
        String fileRealPath = CommonUtil.WEBSITE +FILE_MANAGER+ fileInfouploadDTO.getUploadPar() +"/"+ filename ;
        byte[] buffer;
        try {
            if (fileInfouploadDTO.getFileocode() == null || "".equals(fileInfouploadDTO.getFileocode())) {
                return "";
            }
            String imgBase64 = fileInfouploadDTO.getFileocode().replaceAll("data:image/png;base64,","");
            BASE64Decoder d = new BASE64Decoder();
            buffer = d.decodeBuffer(imgBase64);

            String uploadDir = CommonUtil.UPLOADFILEURL+"/"+FILE_MANAGER+ fileInfouploadDTO.getUploadPar()+"/";
            File file = new File(uploadDir);
            String filepath = uploadDir + filename ;
            System.out.println(fileRealPath);
            System.out.println(filepath);
            if (!file.exists()) {
                file.mkdirs();
            }
            FileOutputStream outputStream = new FileOutputStream(filepath);
            outputStream.write(buffer);
            outputStream.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return fileRealPath;
    }


//    @PostMapping("/test")
//    public @ResponseBody String test() {
//        String urlStr = "http://wework.qpic.cn/wwhead/duc2TvpEgSTPk74IwG7Bs3Mibxs9gMgPQ2OVLFuaQssbyCYTRkiau4s6icjCf3dcEL9aghWFU8ibTLc/0";
//        String url =  DownImageUtil.saveAvatar2File(urlStr,"");
//        return url;
//    }



}
