package com.metro.auth.platform.generallog;

import com.alibaba.fastjson.JSON;
import com.metro.auth.platform.domain.ResultJson;
import com.metro.auth.platform.domain.auth.SysLogInfo;
import com.metro.auth.platform.domain.auth.UserDetail;
import com.metro.auth.platform.utils.DateUtil;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.CodeSignature;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

@Slf4j
@Aspect
@Component
public class LogAspectClass {

    @Autowired
    LogAddService logAddService;

    // 这里定义下切点的位置,也就是刚才我们自定义的注解.
    @Pointcut("@annotation(com.metro.auth.platform.generallog.LogAnnotation)")
    public void mypointcut(){}


    //消息通知 @AfterReturning,在切点方法运行之后触发returning 为目标函数返回值
    @AfterReturning(returning = "result",value = "mypointcut()")
    public void addlog(JoinPoint joinPoint,Object result){
        ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        //从切面织入点处通过反射机制获取织入点处的方法
        MethodSignature signature = (MethodSignature) joinPoint.getSignature();
        //获取切入点所在的方法
        Method method = signature.getMethod();

        String operatetype ="";         //  定义操作方式
        String operatecontent="";       //  定义操作内容

        // 获取注解中的操作方式
        if(method!=null&&!"".equals(method)){
            // 获取自定义注解操作
            LogAnnotation  logAnnotation = method.getAnnotation(LogAnnotation.class);
            // 获取用户操作方式
            operatetype = logAnnotation.operateType();
            // 获取用户操作内容
            operatecontent = logAnnotation.operateContent();
        }

        // 获取请求的类名
        String classname = joinPoint.getTarget().getClass().getName();
        // 获取请求的方法名
        String methodname = classname+"."+method.getName();
        // 获取请求方式
        String Method = request.getMethod();
        // 获取请求url
        String URL = request.getRequestURI();
        // 获取请求的ip地址
        String IP  = request.getRemoteAddr();
        // 获取请求的参数
        String[] argsname = ((CodeSignature) joinPoint.getSignature()).getParameterNames();
        Map<String,Object> parammap = new HashMap<>();
        if(argsname.length>0){
            parammap= getParam(joinPoint,argsname,methodname);
        }
        String detail = JSON.toJSONString(parammap);
        ResultJson statusmap = (ResultJson) result;
        UserDetail userDetail = null;
        // 获取操作状态
        String status=statusmap.getMsg();
        try {
            userDetail = (UserDetail) SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            log.info("日志处理 userDetail 值为："+userDetail);
            // 日志实体类封装
            SysLogInfo logEntity = new SysLogInfo();
            if(userDetail!=null){
                logEntity.setUsername(userDetail.getUsername());
                logEntity.setUserid(userDetail.getId()+"");
            }
            logEntity.setUuid(logAddService.getUUid());
            logEntity.setIp(IP);
            logEntity.setStatus(status);
            logEntity.setOperatetype(operatetype);
            logEntity.setOperatecontent(operatecontent);
            logEntity.setDetail(detail);
            logEntity.setOperatetime(DateUtil.getCurTime());

            logAddService.addLogInfo(logEntity);
            log.info("aop+++++++++++++++++++++切面++++++++++++++++++++");
        }catch (Exception e){
            log.info("未获得userDetail值，亦或是用户正在进行扫码登录！");
        }


    }


    // 处理参数格式,并返回需要的参数
    public static Map<String, Object> getParam(JoinPoint joinPoint, String[] argsname, String methodname) {
        Map<String,Object> detailmap = new HashMap<>();
        Map<String, Object> map = new HashMap<>();
        Map<String, Object> mapCODE = new HashMap<>();
        // 获取参数值

        Object[] args = joinPoint.getArgs();
        // 获取参数名
        argsname = ((CodeSignature) joinPoint.getSignature()).getParameterNames();
        String paramsString = "";
        for(int i=0; i < argsname.length; i++) {
            if (!"model".equals(argsname[i])) {
                map.put(argsname[i], args[i]);
            }
        }
        detailmap.put("method",methodname);
        detailmap.put("params",map);
        log.info("detail:====="+ detailmap);
        return  detailmap;
    }
}
