package com.metro.auth.platform.metrointerface;

import com.alibaba.fastjson.JSONObject;
import com.metro.auth.platform.domain.ResultJson;
import com.metro.auth.platform.domain.dto.DailyDTO;
import com.metro.auth.platform.http.HttpAPIService;
import com.metro.auth.platform.outlineapi.PlatformUrlManager;
import com.metro.auth.platform.utils.SpringUtil;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * .::::.
 * .::::::::.
 * :::::::::::    佛主保佑、永无Bug
 * ..:::::::::::'
 * '::::::::::::'
 * .::::::::::
 * '::::::::::::::..
 * ..::::::::::::.
 * ``::::::::::::::::
 * ::::``:::::::::'        .:::.
 * ::::'   ':::::'       .::::::::.
 * .::::'      ::::     .:::::::'::::.
 * .:::'       :::::  .:::::::::' ':::::.
 * .::'        :::::.:::::::::'      ':::::.
 * .::'         ::::::::::::::'         ``::::.
 * ...:::           ::::::::::::'              ``::.
 * ```` ':.          ':::::::::'                  ::::..
 * '.:::::'                    ':'````..
 */

@RestController
@RequestMapping("/daily")
public class DailyController {

    @Resource
    private HttpAPIService httpAPIService;

    /**
     * 功能描述: <br>获取日报信息分页列表
     * 〈〉
     * @Author: lx
     */
    @GetMapping("/new")
    public ResultJson queryDailyPageList(DailyDTO dailyDTO){

        String url = SpringUtil.getBean(PlatformUrlManager.class).getPlatformURI(PlatformUrlManager.DAILY_NEW_URL);

        String result = null;
        try {
            result = httpAPIService.doGet(url + "?pageIndex=" + dailyDTO.getPageIndex() + "&pageSize=" + dailyDTO.getPageSize() + "&content=" + dailyDTO.getContent() + "&state=" + dailyDTO.getState());
            if(!"".equals(result) && result != null){
                return ResultJson.ok(JSONObject.parseObject(result));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ResultJson.ok(result);
    }

    /**
     * 功能描述: <br>获取日报信息详情
     * 〈〉
     * @Author: lx
     */
    @GetMapping("/detail/{assembleid}")
    public ResultJson getDailyInfoByAssembleid(@PathVariable String assembleid){

        String url = SpringUtil.getBean(PlatformUrlManager.class).getPlatformURI(PlatformUrlManager.DAILY_DETAIL_URL);

        String result = null;
        try {
            result = httpAPIService.doGet(url + "/" + assembleid);
            if(!"".equals(result) && result != null){
                return ResultJson.ok(JSONObject.parseObject(result));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ResultJson.ok(result);
    }

    /**
     * 功能描述: <br>获取日报信息实体
     * 〈〉
     * @Author: lx
     */
    @GetMapping("/entity/{id}")
    public ResultJson getDailyInfoById(@PathVariable String id){

        String url = SpringUtil.getBean(PlatformUrlManager.class).getPlatformURI(PlatformUrlManager.DAILY_ENTITY_URL);

        String result = null;
        try {
            result = httpAPIService.doGet(url + "?id=" + id);
            if(!"".equals(result) && result != null){
                return ResultJson.ok(JSONObject.parseObject(result));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ResultJson.ok(result);
    }
}
