package com.metro.auth.platform.metrointerface;

import com.alibaba.fastjson.JSONObject;
import com.metro.auth.platform.domain.ResultCode;
import com.metro.auth.platform.domain.ResultJson;
import com.metro.auth.platform.domain.auth.PlatformPersonnel;
import com.metro.auth.platform.domain.auth.ResponseUserToken;
import com.metro.auth.platform.domain.auth.User;
import com.metro.auth.platform.outlineapi.PlatformUrlManager;
import com.metro.auth.platform.service.AuthService;
import com.metro.auth.platform.utils.MailUtil;
import com.metro.auth.platform.utils.SpringUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

@Slf4j
@RestController
@RequestMapping("/auth/user")
public class UserController {

    @Value("${jwt.header}")
    private String tokenHeader;
    private final AuthService authService;
    public UserController(AuthService authService) {
        this.authService = authService;
    }

//    private final AuthService authService;
    /**
     * 接口1：
     * 功能描述: <br>获取栏目信息集合
     * 〈〉
     * @Author: lx
     */
    @PostMapping(value = "/login")
    public ResultJson<ResponseUserToken> login( @Valid @RequestBody User user){
        String url = SpringUtil.getBean(PlatformUrlManager.class).getPlatformURI(PlatformUrlManager.API_USER_LOGIN_URL);
        String result = null;
        try {
            result = this.doPost_user(url, user);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ResultJson.ok(result);
    }
    /**
     * 功能描述: <br>扫码登录
     * 〈〉
     * @Param: [userId]
     * @Return: [userId]
     * @Author: zhouy
     * @Date: 2019-10-23 13:06
     */

    @GetMapping(value = "/qrcodelogin/{userId}")
    public ResultJson<ResponseUserToken> qrcodelogin(@PathVariable String userId){
        String url = SpringUtil.getBean(PlatformUrlManager.class).getPlatformURI(PlatformUrlManager.API_USER_LOGIN_URL);
        String result = null;
        try {
//            result = this.doPost_user(url, user);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ResultJson.ok(result);
    }
    /**
     *根据随机码登录
     * @param user
     * @return
     */
    @PostMapping(value = "/logincode")
//    @ApiOperation(value = "登录", notes = "根据随机码登录")
    public ResultJson<ResponseUserToken> logincode(@Valid @RequestBody User user){
        String url = SpringUtil.getBean(PlatformUrlManager.class).getPlatformURI(PlatformUrlManager.API_USER_LOGIN_URL);
        String result = null;
        try {
//            result = this.doPost_user(url, user);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ResultJson.ok(result);
    }

    /**
     * 企业微信授权，根据用户account 保存随机码
     * @param user
     * @return
     */
    @PostMapping(value = "/savecode")
    public ResultJson savecode(@Valid @RequestBody User user){
//        int flag= authService.updateCodeByUserid(user.getAccount() ,user.getCode());
        int flag=0;
        if (flag>0){
            return ResultJson.ok(ResultCode.SUCCESS);
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }

    /**
     * 根据邮箱保存code
     * @param user
     * @return
     */
    @PostMapping(value = "/savecodeByemail")
    public ResultJson savecodeByemail(@Valid @RequestBody User user){
//        int flag= authService.updateCodeByUserid(user.getAccount() ,user.getCode());
        int flag=0;
        if (flag>0){
            return ResultJson.ok(ResultCode.SUCCESS);
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }

    /**
     * 检验邮箱，如果存在发送邮件验证码
     * @param user
     * @return
     */
    @PostMapping(value = "/sendcodeToEmail")
    public ResultJson sendcodeToEmail(@Valid @RequestBody User user){
        //查询email是否存在，存在则把验证码发送到邮箱
        String email=user.getAccount();
        boolean sendstatus=false;
        PlatformPersonnel platformPersonnel=new PlatformPersonnel();
//                = authService.findUserInfoByemail(email);
        if (platformPersonnel !=null){
            //发送邮件
            String url = PlatformUrlManager.EMAIL_URL +"?account="+platformPersonnel.getAccount()+"&code=" + user.getCode();
            String emailMsg = "<h3>授权请点击下面的超链接</h3><a href='" + url + "'> 点击授权 </a>";
            MailUtil.sendMail(email,"内网平台登录授权",emailMsg,new String[]{""});
            sendstatus=true;
            if (sendstatus){
                return ResultJson.ok(ResultCode.SEND_SUCCESS);
            }else{
                return ResultJson.ok(ResultCode.SEND_ERROR);
            }

        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }

    /**
     * 根据用户id获取用户所有部门id
     * @param userId
     * @return
     */
    @GetMapping(value = "/userdepartment/{userId}")
    public ResultJson getUser(@PathVariable String userId){
        PlatformPersonnel patformPersonnel = authService.getUserByUserid((Integer.parseInt(userId)));
        return ResultJson.ok(patformPersonnel);
    }

    private String doPost_user(String httpurl, User user) throws IOException {
        StringBuffer sbf = new StringBuffer();
        String strRead = null;
        URL url = new URL(httpurl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");//请求post方式
        connection.setDoInput(true);
        connection.setDoOutput(true);
        //header内的的参数在这里set    connection.setRequestProperty("健, "值");
        connection.setRequestProperty("Content-Type", "application/json");
//        connection.setRequestProperty("token", userid);
        connection.connect();
        OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8);
        //body参数在这里put到JSONObject中
        JSONObject parm = new JSONObject();
        Map<String, Object> pagemap = new HashMap<>();
        parm.put("username", user.getAccount());
        parm.put("password", user.getPassword());
        writer.write(parm.toString());
        writer.flush();
        InputStream is = connection.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        while ((strRead = reader.readLine()) != null) {
            sbf.append(strRead);
            sbf.append("\r\n");
        }
        reader.close();
        connection.disconnect();
        String results = sbf.toString();
        return results;
    }


}
