package com.metro.auth.platform.service;

import com.metro.auth.platform.domain.auth.PlatformApplications;
import com.metro.auth.platform.domain.auth.PlatformApplicationsExample;
import com.metro.auth.platform.domain.auth.PlatformRoleApplicationApp;
import com.metro.auth.platform.mapper.PlatformApplicationsMapper;
import com.metro.auth.platform.mapper.PlatformRoleApplicationAppMapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class PlatformRoleApplicationAppServiceImpl implements PlatformRoleApplicationAppService {

    @Resource
    PlatformApplicationsMapper platformApplicationsMapper;

    @Resource
    PlatformRoleApplicationAppMapper platformRoleApplicationAppMapper;

    @Override
    public List<PlatformApplications> getPlatformApplicationsListApp() {
        return platformApplicationsMapper.getPlatformApplicationsList();
    }

    @Override
    public List<PlatformApplications> getPlatformApplicationsListByRoleApp(String roleid) {
        PlatformApplicationsExample platformApplicationsExample = new PlatformApplicationsExample();
        //所有应用
        List<PlatformApplications> alllist = platformApplicationsMapper.selectByExample(platformApplicationsExample);

        // 查询当前角色的 App 应用权限关联
        List<PlatformApplications> roleApps = platformApplicationsMapper.getPlatformApplicationsListByRoleApp(roleid);

        // 首先将所有应用的 roleUseStatue 设置为 0（不可见）
        alllist.stream().forEach(t -> {
            t.setRoleUseStatue(0);
        });

        // 然后将可见应用的 roleUseStatue 设置为该应用的ID
        if (roleApps != null && roleApps.size() > 0) {
            for (PlatformApplications roleApp : roleApps) {
                alllist.stream().forEach(t -> {
                    if (t.getId().equals(roleApp.getId())) {
                        t.setRoleUseStatue(t.getId());
                    }
                });
            }
        }
        return alllist;
    }

    @Override
    public int deleteByRoleid(String roleid) {
        return platformRoleApplicationAppMapper.deleteByRoleid(roleid);
    }

    @Override
    public int insertRoleApplicationApp(PlatformRoleApplicationApp platformRoleApplicationApp) {
        return platformRoleApplicationAppMapper.insertRoleApplicationApp(platformRoleApplicationApp);
    }
}
