package com.metro.auth.platform.utils;

import com.metro.auth.platform.qyweixin.model.*;

import javax.net.ssl.HttpsURLConnection;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;


/**
 * post�ύxml��ʽ�Ĳ���
 * @author iYjrg_xiebin
 * @date 2015��11��25������3:33:38
 */
public class HttpXmlUtils {

	/**
	 * 构造xml参数
	 * @param url
	 * @param xml
	 * @param method
	 * @param contentType
	 * @return
	 */
	public static String xmlHttpProxy(String url,String xml,String method,String contentType){
		InputStream is = null;
		OutputStreamWriter os = null;

		try {
			URL _url = new URL(url);
			HttpURLConnection conn = (HttpURLConnection) _url.openConnection();
			conn.setDoInput(true);   
			conn.setDoOutput(true);   
			conn.setRequestProperty("Content-type", "text/xml");
			conn.setRequestProperty("Pragma:", "no-cache");  
			conn.setRequestProperty("Cache-Control", "no-cache");  
			conn.setRequestMethod("POST");
			os = new OutputStreamWriter(conn.getOutputStream());
			os.write(new String(xml.getBytes(contentType)));
			os.flush();

			//����ֵ
			is = conn.getInputStream();
			return getContent(is, "utf-8");
		} catch (MalformedURLException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} finally{
			try {
				if(os!=null){os.close();}
				if(is!=null){is.close();}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return null;
	}

	/**
	 * �������ص�ֵ
	 * @param is
	 * @param charset
	 * @return
	 */
	public static String getContent(InputStream is, String charset) {
		String pageString = null;
		InputStreamReader isr = null;
		BufferedReader br = null;
		StringBuffer sb = null;
		try {
			isr = new InputStreamReader(is, charset);
			br = new BufferedReader(isr);
			sb = new StringBuffer();
			String line = null;
			while ((line = br.readLine()) != null) {
				sb.append(line + "\n");
			}
			pageString = sb.toString();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				if (is != null){
					is.close();
				}
				if(isr!=null){
					isr.close();
				}
				if(br!=null){
					br.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
			sb = null;
		}
		return pageString;
	}

	/**
	 * ����xml����
	 * @param //xml
	 * @return
	 */
	public static String xmlInfo(Unifiedorder unifiedorder){
		//����xml�����ʱ���������Ǹ��ش�����
		/*
		 * <xml>
			   <appid>wx2421b1c4370ec43b</appid>
			   <attach>֧������</attach>
			   <body>JSAPI֧������</body>
			   <mch_id>10000100</mch_id>
			   <nonce_str>1add1a30ac87aa2db72f57a2375d8fec</nonce_str>
			   <notify_url>http://wxpay.weixin.qq.com/pub_v2/pay/notify.v2.php</notify_url>
			   <openid>oUpF8uMuAJO_M2pxb1Q9zNjWeS6o</openid>
			   <out_trade_no>1415659990</out_trade_no>
			   <spbill_create_ip>14.23.150.211</spbill_create_ip>
			   <total_fee>1</total_fee>
			   <trade_type>JSAPI</trade_type>
			   <sign>0CB01533B8C1EF103065174F50BCA001</sign>
			</xml>
		 */

		if(unifiedorder!=null){
			StringBuffer bf = new StringBuffer();
			bf.append("<xml>");

			bf.append("<appid><![CDATA[");
			bf.append(unifiedorder.getAppid());
			bf.append("]]></appid>");
//			
			bf.append("<attach><![CDATA[");
			bf.append(unifiedorder.getAttach());
			bf.append("]]></attach>");
			
			bf.append("<mch_id><![CDATA[");
			bf.append(unifiedorder.getMch_id());
			bf.append("]]></mch_id>");

			bf.append("<nonce_str><![CDATA[");
			bf.append(unifiedorder.getNonce_str());
			bf.append("]]></nonce_str>");

			bf.append("<sign><![CDATA[");
			bf.append(unifiedorder.getSign());
			bf.append("]]></sign>");

			bf.append("<body><![CDATA[");
			bf.append(unifiedorder.getBody());
			bf.append("]]></body>");

//			bf.append("<detail><![CDATA[");
//			bf.append(unifiedorder.getDetail());
//			bf.append("]]></detail>");
//
//			bf.append("<timeStamp><![CDATA[");
//			bf.append(unifiedorder.getTimeStamp());
//			bf.append("]]></timeStamp>");

			bf.append("<out_trade_no><![CDATA[");
			bf.append(unifiedorder.getOut_trade_no());
			bf.append("]]></out_trade_no>");

			bf.append("<total_fee><![CDATA[");
			bf.append(unifiedorder.getTotal_fee());
			bf.append("]]></total_fee>");

			bf.append("<spbill_create_ip><![CDATA[");
			bf.append(unifiedorder.getSpbill_create_ip());
			bf.append("]]></spbill_create_ip>");

			bf.append("<time_start><![CDATA[");
			bf.append(unifiedorder.getTime_start());
			bf.append("]]></time_start>");

			bf.append("<time_expire><![CDATA[");
			bf.append(unifiedorder.getTime_expire());
			bf.append("]]></time_expire>");

			bf.append("<notify_url><![CDATA[");
			bf.append(unifiedorder.getNotify_url());
			bf.append("]]></notify_url>");

			bf.append("<trade_type><![CDATA[");
			bf.append(unifiedorder.getTrade_type());
			bf.append("]]></trade_type>");
			
			bf.append("</xml>");
			return bf.toString();
		}

		return "";
	}
	/**
	 * 根据微信订单查询对象构造查询订单请求XML
	 * @author qijj
	 * @param orderQueryParam
	 * @return
	 */
	public static String xmlInfo(OrderQueryParam orderQueryParam)
	{
		if(orderQueryParam!=null){
			StringBuffer bf = new StringBuffer();
			bf.append("<xml>");

			bf.append("<appid><![CDATA[");
			bf.append(orderQueryParam.getAppid());
			bf.append("]]></appid>");
			
			bf.append("<mch_id><![CDATA[");
			bf.append(orderQueryParam.getMch_id());
			bf.append("]]></mch_id>");
			
			bf.append("<out_trade_no><![CDATA[");
			bf.append(orderQueryParam.getOut_trade_no());
			bf.append("]]></out_trade_no>");

			bf.append("<nonce_str><![CDATA[");
			bf.append(orderQueryParam.getNonce_str());
			bf.append("]]></nonce_str>");

			bf.append("<sign><![CDATA[");
			bf.append(orderQueryParam.getSign());
			bf.append("]]></sign>");

			bf.append("</xml>");
			return bf.toString();
		}
		return "";
	}
	/**
	 * 根据微信撤销订单对象构造撤销订单请求XML
	 * @author qijj
	 * @param reverseParam
	 * @return
	 */
	public static String xmlInfo(ReverseParam reverseParam)
	{
		if(reverseParam!=null){
			StringBuffer bf = new StringBuffer();
			bf.append("<xml>");

			bf.append("<appid><![CDATA[");
			bf.append(reverseParam.getAppid());
			bf.append("]]></appid>");
			
			bf.append("<mch_id><![CDATA[");
			bf.append(reverseParam.getMch_id());
			bf.append("]]></mch_id>");
			
			bf.append("<out_trade_no><![CDATA[");
			bf.append(reverseParam.getOut_trade_no());
			bf.append("]]></out_trade_no>");

			bf.append("<nonce_str><![CDATA[");
			bf.append(reverseParam.getNonce_str());
			bf.append("]]></nonce_str>");

			bf.append("<sign><![CDATA[");
			bf.append(reverseParam.getSign());
			bf.append("]]></sign>");

			bf.append("</xml>");
			return bf.toString();
		}

		return "";
	}
	/**
	 * 根据微信刷卡支付对象构造刷卡支付请求XML
	 * @author qijj
	 * @param microPayParam
	 * @return
	 */
	public static String xmlInfo(MicroPayParam microPayParam){
		if(microPayParam!=null){
			StringBuffer bf = new StringBuffer();
			bf.append("<xml>");

			bf.append("<appid><![CDATA[");
			bf.append(microPayParam.getAppid());
			bf.append("]]></appid>");
			
			bf.append("<mch_id><![CDATA[");
			bf.append(microPayParam.getMch_id());
			bf.append("]]></mch_id>");
			
			bf.append("<device_info><![CDATA[");
			bf.append(microPayParam.getDevice_info());
			bf.append("]]></device_info>");
			
			bf.append("<nonce_str><![CDATA[");
			bf.append(microPayParam.getNonce_str());
			bf.append("]]></nonce_str>");

			bf.append("<sign><![CDATA[");
			bf.append(microPayParam.getSign());
			bf.append("]]></sign>");

			bf.append("<body><![CDATA[");
			bf.append(microPayParam.getBody());
			bf.append("]]></body>");

			bf.append("<out_trade_no><![CDATA[");
			bf.append(microPayParam.getOut_trade_no());
			bf.append("]]></out_trade_no>");

			bf.append("<total_fee><![CDATA[");
			bf.append(microPayParam.getTotal_fee());
			bf.append("]]></total_fee>");

			bf.append("<spbill_create_ip><![CDATA[");
			bf.append(microPayParam.getSpbill_create_ip());
			bf.append("]]></spbill_create_ip>");

			bf.append("<auth_code><![CDATA[");
			bf.append(microPayParam.getAuth_code());
			bf.append("]]></auth_code>");
			
			bf.append("</xml>");
			return bf.toString();
		}

		return "";
	}
	/**
	 * @author 周海峰
	 * @param wxRefundParam
	 * @return
	 */
	public static String xmlInfo(WxRefundParam wxRefundParam){
		if(wxRefundParam!=null){
			StringBuffer bf = new StringBuffer();
			bf.append("<xml>");

			bf.append("<appid><![CDATA[");
			bf.append(wxRefundParam.getAppid());
			bf.append("]]></appid>");
			
			bf.append("<mch_id><![CDATA[");
			bf.append(wxRefundParam.getMch_id());
			bf.append("]]></mch_id>");
			
			bf.append("<nonce_str><![CDATA[");
			bf.append(wxRefundParam.getNonce_str());
			bf.append("]]></nonce_str>");

			bf.append("<sign><![CDATA[");
			bf.append(wxRefundParam.getSign());
			bf.append("]]></sign>");

			bf.append("<out_trade_no><![CDATA[");
			bf.append(wxRefundParam.getOut_trade_no());
			bf.append("]]></out_trade_no>");

			bf.append("<out_refund_no><![CDATA[");
			bf.append(wxRefundParam.getOut_refund_no());
			bf.append("]]></out_refund_no>");
			
			bf.append("<total_fee><![CDATA[");
			bf.append(wxRefundParam.getTotal_fee());
			bf.append("]]></total_fee>");
			
			bf.append("<refund_fee><![CDATA[");
			bf.append(wxRefundParam.getRefund_fee());
			bf.append("]]></refund_fee>");
			
			bf.append("<notify_url><![CDATA[");
			bf.append(wxRefundParam.getNotify_url());
			bf.append("]]></notify_url>");
			
			
			bf.append("</xml>");
			return bf.toString();
		}

		return "";
	}
	
	/**
	 * 根据微信退款查询对象构造查询请求XML
	 * @author 周海峰
	 * @param //orderQueryParam
	 * @return
	 */
	public static String xmlInfo(WxRefundOrderParam wxRefundOrderParam)
	{
		if(wxRefundOrderParam!=null){
			StringBuffer bf = new StringBuffer();
			bf.append("<xml>");

			bf.append("<appid><![CDATA[");
			bf.append(wxRefundOrderParam.getAppid());
			bf.append("]]></appid>");
			
			bf.append("<mch_id><![CDATA[");
			bf.append(wxRefundOrderParam.getMch_id());
			bf.append("]]></mch_id>");
			
			bf.append("<out_refund_no><![CDATA[");
			bf.append(wxRefundOrderParam.getOut_refund_no());
			bf.append("]]></out_refund_no>");

			bf.append("<nonce_str><![CDATA[");
			bf.append(wxRefundOrderParam.getNonce_str());
			bf.append("]]></nonce_str>");

			bf.append("<sign><![CDATA[");
			bf.append(wxRefundOrderParam.getSign());
			bf.append("]]></sign>");

			bf.append("</xml>");
			return bf.toString();
		}
		return "";
	}
	
	
	/**
	 * 
	 * @param requestUrl
	 * @param requestMethod
	 * @param output
	 * @return
	 */
	public static String httpsRequest(String requestUrl, String requestMethod, String output) {
		try{
			URL url = new URL(requestUrl);
			HttpsURLConnection connection = (HttpsURLConnection) url.openConnection();
			connection.setDoOutput(true);
			connection.setDoInput(true);
			connection.setUseCaches(false);
			connection.setRequestMethod(requestMethod);
			if (null != output) {
				OutputStream outputStream = connection.getOutputStream();
				outputStream.write(output.getBytes(StandardCharsets.UTF_8));
				outputStream.close();
			}
			// 读取流
			InputStream inputStream = connection.getInputStream();
			InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
			BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
			String str = null;
			StringBuffer buffer = new StringBuffer();
			while ((str = bufferedReader.readLine()) != null) {
				buffer.append(str);
			}
			bufferedReader.close();
			inputStreamReader.close();
			inputStream.close();
			inputStream = null;
			connection.disconnect();
			return buffer.toString();
		}catch(Exception ex){
			ex.printStackTrace();
		}

		return "";
	}

}
