package com.metro.auth.platform.controller;

/**
 * .::::.
 * .::::::::.
 * :::::::::::    佛主保佑、永无Bug
 * ..:::::::::::'
 * '::::::::::::'
 * .::::::::::
 * '::::::::::::::..
 * ..::::::::::::.
 * ``::::::::::::::::
 * ::::``:::::::::'        .:::.
 * ::::'   ':::::'       .::::::::.
 * .::::'      ::::     .:::::::'::::.
 * .:::'       :::::  .:::::::::' ':::::.
 * .::'        :::::.:::::::::'      ':::::.
 * .::'         ::::::::::::::'         ``::::.
 * ...:::           ::::::::::::'              ``::.
 * ```` ':.          ':::::::::'                  ::::..
 * '.:::::'                    ':'````..
 */

import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.domain.ResultCode;
import com.metro.auth.platform.domain.ResultJson;
import com.metro.auth.platform.domain.auth.PlatformSysButton;
import com.metro.auth.platform.domain.auth.PlatformSysRole;
import com.metro.auth.platform.service.PlatformButtonService;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * @ClassName: PlatformButtonController
 * @Description: ${description}  
 * @Authror zhouy
 * @Date 2019-09-12 17:28
 */

@RestController
@RequestMapping("/function")
public class PlatformButtonController {

    @Resource
    PlatformButtonService platformButtonService;
    /**
     * 功能描述: <br>功能清单
     * 〈〉
     * @Param: [pageNum, pageSize, platformSysRole]
     * @Return: [pageNum, pageSize, platformSysRole]
     * @Author: zhouy
     * @Date: 2019-09-11 18:22
     */

    @GetMapping("/pagedlist")
    public ResultJson pagedlist(@RequestParam(required=true,value="pageNum",defaultValue="1") int pageNum,
                                @RequestParam(required=true,value="pageSize",defaultValue="15") int pageSize,
                                PlatformSysButton platformSysButton){
        PageInfo<PlatformSysButton> page =  platformButtonService.pageButtonslist(platformSysButton,pageNum,pageSize);
        return ResultJson.ok(page);
    }

    /**
     * 功能描述: <br>保存功能菜单信息
     * 〈〉
     * @Param: [platformSysRole]
     * @Return: [platformSysRole]
     * @Author: zhouy
     * @Date: 2019-09-11 15:13
     */
    @PostMapping("/save")
    public ResultJson  saveRole(@RequestBody PlatformSysButton platformSysButton){

        int count = platformButtonService.saveButtons(platformSysButton);
        if(count>0){
            return ResultJson.ok();
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }

    @DeleteMapping("/del")
    public ResultJson  deleRole(@RequestParam String id){

        int count = platformButtonService.delButton(id);
        if(count>0){
            return ResultJson.ok();
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }

    @DeleteMapping("/batchdel/{ids}")
    public ResultJson  delRoles(@PathVariable String ids){
        platformButtonService.delButtons(ids);
        return ResultJson.ok();
    }
}
