package com.metro.auth.platform.utils;


import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

/**
 * 签名算法sign
 * @author superma
 */
@Component
public class WXSignUtils {
	//----------app参数--------------
	// 商户api密钥 校家云通
	public static String Key;
	// 商户号 appid
	public static String APPID;
	// 商户号 校家云通
	public static String MCH_ID;

	public static String API_KEY;

	public static String APP_SECRET;

	public static final String WX_APICLIENT_CERT_PATH ="/Users/zhouhaifeng/wxcert/apiclient_cert.p12";//"/home/website/zhiliang/zlmall/cert/wxreverse_cert/apiclient_cert.p12";

	public static final String TRADE_TYPE="APP";
	//----------app参数--------------

	
	//微信公众号商户退款回调路径
	public static final String REFUND_NOTIFY_URL= CommonUtil.WEBSITE+"weixin/WxNotifyUrlController/refundNotifyUrl";
	//支付回调路径
	public static final String PAY_NOTIFY_URL=CommonUtil.WEBSITE+"weixin/WxNotifyUrlController/payNotifyUrl";
	public static final String NATIVE_NOTIFY_URL=CommonUtil.WEBSITE+"weixin/WxNativeController/nativeNotifyUrl";
	public static final String NATIVE_BROADCAST_NOTIFY_URL=CommonUtil.WEBSITE+"weixin/WxNativeController/nativeBroadcastNotifyUrl";
	public static final String WXURL="https://api.mch.weixin.qq.com/pay/unifiedorder";
	public static final String WX_MICROPAY_URL = "https://api.mch.weixin.qq.com/pay/micropay";
	public static final String WX_ORDERQUERY_URL = "https://api.mch.weixin.qq.com/pay/orderquery";
	public static final String WX_REVERSE_URL = "https://api.mch.weixin.qq.com/secapi/pay/reverse";
	public static final String WX_REFUND_URL = "https://api.mch.weixin.qq.com/secapi/pay/refund";
	public static final String WX_REFUNDQUERY_URL ="https://api.mch.weixin.qq.com/pay/refundquery";
	public static final String METHOD="POST";

	@Value("${weixin-params.wx_corpid}")
	public void setMchid(String mchid) {
		MCH_ID = mchid;
	}
	@Value("${weixin-params.wx_secret}")
	public void setKey(String key) {
		Key = key;
	}

	@Value("${weixin-params.wx_agentid}")
	public void setAppid(String appid) {
		APPID = appid;
	}

	@Value("${weixin-params.wx_agentid}")
	public void setApiKey(String apikey) {
		API_KEY = apikey;
	}

	@Value("${weixin-params.wx_tx_secret}")
	public void setAppSecret(String appSecret) {
		APP_SECRET = appSecret;
	}

	/**
	 * 微信支付签名算法sign
	 * @param characterEncoding
	 * @param parameters
	 * @return
	 */
	@SuppressWarnings("rawtypes")
	public static String createSign(String characterEncoding,SortedMap<Object,Object> parameters){
		StringBuffer sb = new StringBuffer();
		Set es = parameters.entrySet();  //所有参与传参的参数按照accsii排序（升序）
		Iterator it = es.iterator();
		while(it.hasNext()) {
			Map.Entry entry = (Map.Entry)it.next();
			String k = (String)entry.getKey();
			Object v = entry.getValue();
			if(null != v && !"".equals(v) 
					&& !"sign".equals(k) && !"key".equals(k)) {
				sb.append(k + "=" + v + "&");
			}
		}
		sb.append("key=" + Key);
		System.out.println("字符串拼接后是:"+ sb);
		String sign = MD5Util.MD5Encode(sb.toString(), characterEncoding).toUpperCase();
		return sign;
	}

	
}
