package com.metro.auth.platform.wxmessage;

import com.metro.auth.platform.utils.JSONUtil;
import com.metro.auth.platform.utils.StrUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpStatus;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.concurrent.atomic.AtomicBoolean;

/**
 * @ClassName: ApiConfig
 * @Description: ${description}  
 * @Authror zhouy
 * @Date 2019-07-23 13:29
 */
@Slf4j
@Component
public class ApiConfig {

    @Value("${weixin-params.wx_secret}")
    private String WX_SECRET;

    @Value("${weixin-params.wx_token_url}")
    private String WX_TOKEN_URL;

    @Value("${weixin-params.wx_corpid}")
    private String WX_CORPID;

    @Value("${weixin-params.wx_jstiket}")
    private String WX_JSTIKET;

    //通讯录secret
    @Value("${weixin-params.wx_tx_secret}")
    private String WX_TX_SECRET;

    @Value("${weixin-params.wx_tb_corpid}")
    private String WX_TX_CORPID;


    private final AtomicBoolean tokenRefreshing = new AtomicBoolean(false);
    private final AtomicBoolean jsRefreshing    = new AtomicBoolean(false);
    private final AtomicBoolean tokenTxRefreshing = new AtomicBoolean(false);
    private       String  accessToken;
    private       long    weixinTokenStartTime;
    private       String  jsApiTicket;
    private       boolean enableJsApi;
    private       long    jsTokenStartTime;

    private       String accessToken_Tx;
    private        long  WeixinTokenStartTime_Tx;

    public void  ApiConfigInit(boolean enableJsApi) {
        log.info("开始获取微信token...");
        long now = System.currentTimeMillis();
        initToken(now);
        log.info("Token获取完成,当前token ["+getAccessToken()+"]...");
        log.info("开始获取微信token_tx...");
        initToken_Tx(now);
        log.info("token_tx获取完成,当前token_tx ["+getAccessToken_Tx()+"]...");
        this.enableJsApi = enableJsApi;
        if (enableJsApi){ initJSToken(now);}

    }

    public void setAccessToken_Tx(String accessToken_Tx) {
        this.accessToken_Tx = accessToken_Tx;
    }
    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }
    public String getAccessToken() {
        long now = System.currentTimeMillis();
        long time = now - this.weixinTokenStartTime;
        try {
            //官方给出的超时时间是7200秒，这里用7100秒来做，防止出现已经过期的情况
            if (time > 7100000 && tokenRefreshing.compareAndSet(false, true)) {
                log.debug("准备刷新token.............");
                initToken(now);
            }
        } finally {
            tokenRefreshing.set(false);
        }
        return accessToken;
    }

    public String getJsApiTicket() {
        if (enableJsApi) {
            long now = System.currentTimeMillis();
            try {
                //官方给出的超时时间是7200秒，这里用7100秒来做，防止出现已经过期的情况
                if (now - this.jsTokenStartTime > 7100000 && jsRefreshing.compareAndSet(false, true)) {
                    getAccessToken();
                    initJSToken(now);
                    jsRefreshing.set(false);
                }
            } finally {
                jsRefreshing.set(false);
            }
        } else {
            jsApiTicket = null;
        }
        return jsApiTicket;
    }

    /**
     *
     * @return
     */
    public String getAccessToken_Tx() {
        long now = System.currentTimeMillis();
        long time = now - this.WeixinTokenStartTime_Tx;
        try {
            //官方给出的超时时间是7200秒，这里用7100秒来做，防止出现已经过期的情况
            if (time > 7100000 && tokenTxRefreshing.compareAndSet(false, true)) {
                log.debug("准备刷新token.............");
                initToken_Tx(now);
            }
        } finally {
            tokenTxRefreshing.set(false);
        }
        return accessToken_Tx;
    }

    public boolean isEnableJsApi() {
        return enableJsApi;
    }

    public void setEnableJsApi(boolean enableJsApi) {
        this.enableJsApi = enableJsApi;
        if (!enableJsApi) {this.jsApiTicket = null;}
    }

    /**
     * 功能描述: <br> 获取token
     * 〈〉
     * @Param: [refreshTime]
     * @Return: [refreshTime]
     * @Author: zhouy
     * @Date: 2019-07-23 18:59
     */

    private void initToken(final long refreshTime) {
        log.debug("开始初始化access_token........");
        //记住原本的时间，用于出错回滚
        final long oldTime = this.weixinTokenStartTime;
        this.weixinTokenStartTime = refreshTime;
        String url = WX_TOKEN_URL +"?corpid="+WX_CORPID + "&corpsecret=" + WX_SECRET;

        NetWorkCenter.get(url, null, new NetWorkCenter.ResponseCallback() {
            @Override
            public void onResponse(int resultCode, String resultJson) {
                if (HttpStatus.SC_OK == resultCode) {
                    GetTokenResponse response = JSONUtil.toBean(resultJson, GetTokenResponse.class);
                    log.debug("获取access_token:{}", response.getAccessToken());
                    if (null == response.getAccessToken()) {
                        //刷新时间回滚
                        weixinTokenStartTime = oldTime;
                        log.error("微信公众号token获取出错，错误信息:" + response.getErrcode() + "," + response.getErrmsg());
                    }
                    accessToken = response.getAccessToken();
                }
            }
        });

    }

    /**
     * 功能描述: <br>初始化微信JS-SDK，获取JS-SDK token
     * 〈〉
     * @Param: [refreshTime]
     */
    private void initJSToken(final long refreshTime) {
        log.debug("初始化 jsapi_ticket........");
        //记住原本的时间，用于出错回滚
        final long oldTime = this.jsTokenStartTime;
        this.jsTokenStartTime = refreshTime;
        String url = WX_JSTIKET + accessToken;
        NetWorkCenter.get(url, null, new NetWorkCenter.ResponseCallback() {
            @Override
            public void onResponse(int resultCode, String resultJson) {
                if (HttpStatus.SC_OK == resultCode) {
                    GetJsApiTicketResponse response = JSONUtil.toBean(resultJson, GetJsApiTicketResponse.class);
                    log.debug("获取jsapi_ticket:{}", response.getTicket());
                    if (StrUtil.isBlank(response.getTicket())) {
                        //刷新时间回滚
                        jsTokenStartTime = oldTime;
                        log.error("微信公众号jsToken获取出错，错误信息:" + response.getErrcode() + "," + response.getErrmsg());
                    }
                    jsApiTicket = response.getTicket();
                }
            }
        });
    }

    /**
     * 功能描述: <br>获取token,通讯录使用
     * @param refreshTime
     */
    private void initToken_Tx(final long refreshTime) {
            log.debug("开始初始化accessToken_Tx.......");
            //记住原本的时间，用于出错回滚
            final long oldTime = this.WeixinTokenStartTime_Tx;
            this.WeixinTokenStartTime_Tx = refreshTime;
            String url = WX_TOKEN_URL +"?corpid="+WX_TX_CORPID + "&corpsecret=" + WX_TX_SECRET;

            NetWorkCenter.get(url, null, new NetWorkCenter.ResponseCallback() {
                @Override
                public void onResponse(int resultCode, String resultJson) {
                    if (HttpStatus.SC_OK == resultCode) {
                        GetTokenResponse response = JSONUtil.toBean(resultJson, GetTokenResponse.class);
                        log.debug("获取accessToken_Tx:{}", response.getAccessToken());
                        if (null == response.getAccessToken()) {
                            //刷新时间回滚
                            WeixinTokenStartTime_Tx = oldTime;
                            log.error("微信公众号token获取出错，错误信息:" + response.getErrcode() + "," + response.getErrmsg());
                        }
                        accessToken_Tx = response.getAccessToken();
                    }
                }
            });

        }
}
