package com.metro.auth.platform.utils;

/**
 * .::::.
 * .::::::::.
 * :::::::::::    佛主保佑、永无Bug
 * ..:::::::::::'
 * '::::::::::::'
 * .::::::::::
 * '::::::::::::::..
 * ..::::::::::::.
 * ``::::::::::::::::
 * ::::``:::::::::'        .:::.
 * ::::'   ':::::'       .::::::::.
 * .::::'      ::::     .:::::::'::::.
 * .:::'       :::::  .:::::::::' ':::::.
 * .::'        :::::.:::::::::'      ':::::.
 * .::'         ::::::::::::::'         ``::::.
 * ...:::           ::::::::::::'              ``::.
 * ```` ':.          ':::::::::'                  ::::..
 * '.:::::'                    ':'````..
 */

import java.util.*;
import java.util.stream.Collectors;

/**
 * @ClassName: StrUtil
 * @Description: ${description}  
 * @Authror zhouy
 * @Date 2019-07-23 16:36
 */
public class StrUtil {

    /**
     * 此类不需要实例化
     */
    private StrUtil() {
    }

    /**
     * 判断一个字符串是否为空，null也会返回true
     *
     * @param str 需要判断的字符串
     * @return 是否为空，null也会返回true
     */
    public static boolean isBlank(String str) {
        return null == str || "".equals(str.trim());
    }

    /**
     * 判断一个字符串是否不为空
     *
     * @param str 需要判断的字符串
     * @return 是否为空
     */
    public static boolean isNotBlank(String str) {
        return !isBlank(str);
    }

    /**
     * 判断一组字符串是否有空值
     *
     * @param strs 需要判断的一组字符串
     * @return 判断结果，只要其中一个字符串为null或者为空，就返回true
     */
    public static boolean hasBlank(String... strs) {
        if (null == strs || 0 == strs.length) {
            return true;
        } else {
            //这种代码如果用java8就会很优雅了
            for (String str : strs) {
                if (isBlank(str)) {
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * 功能描述: <br>生成UUID
     * 〈〉
     * @Param: []
     * @Return: []
     * @Author: zhouy
     * @Date: 2019-09-10 23:35
     */

    public static String makePramykey() {
        UUID uuid = UUID.randomUUID();
        String uuidStr=uuid.toString();
        //去除需要的横线
        return uuidStr.replaceAll( "-", "");
    }

    /**
     * 判断一个含有逗号的字符串中是否含有逗号截取的字符串
     * @return
     */
    public static boolean strContains(String str1 ,String  str2){
        if(!str1.contains(",")){
            return str1.equals(str2);
        }
        String[] arr = str1.split(",");
        for (int i = 0; i < arr.length; i++) {
            if(arr[i].equals(str2)){
                return true;
            }
        }
        return false;
    }

    /**
     * zhf
     *比较两个带有逗号的字符串，逗号分割的数组是否相同
     * @return
     */
    public static boolean strEqual(String str1 ,String  str2){

        if(str1.equals(str2)){
            return true;
        }

        if(str1.contains(",") && !str2.contains(",")){
            return false;
        }

        if(!str1.contains(",") && str2.contains(",")){
            return false;
        }

        String[] str1_arr = str1.split(",");
        String[] str2_arr = str2.split(",");
        if(str1_arr.length!=str2_arr.length){
            return false;
        }
        List<String> list1 = new ArrayList<String>(Arrays.asList(str1_arr));
        List<String> list2 = new ArrayList<String>(Arrays.asList(str2_arr));
        list1  = list1.stream().sorted(Comparator.comparing(String::toString)).collect(Collectors.toList());
        list2  = list2.stream().sorted(Comparator.comparing(String::toString)).collect(Collectors.toList());
        for(int i=0;i<list1.size();i++){
            if(!list1.get(i).equals(list2.get(i))){
                return false;
            }
        }

        return true;

    }

    public static String padLeftZeros(int i, int i1) {
        StringBuilder str = new StringBuilder(String.valueOf(i));
        while (str.length() < i1) {
            str.insert(0, "0");
        }
        return str.toString();
    }

//    public static void main(String[] args) {
//        String str1 = "9,72";
//        String str2 = "72,9";
//        boolean bl = strEqual(str1,str2);
//        System.out.println(bl);
//
//    }

}
