import axios from '@/libs/api.request'

// ===== 权限类型枚举 =====
const permissionType = {
  // 键：枚举名，值：枚举值（可以是数字/字符串）
  LEAVEAPPROVAL: 'leave_approval', // 请假审核
  LEAVEVIEW: 'leave_view', // 请假查询统计
  SUPPLYAPPROVAL: 'supply_approval', // 用品审核
  SUPPLYVIEW: 'supply_view' // 用品查询统计
}

// ===== 人员权限配置 =====
export const getPermissionConfigList = () => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/selectPermissionConfigList',
    method: 'post'
  })
}

export const getUserDmPermissionList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/selectUserDmPermissionList',
    method: 'post',
    data: param
  })
}

export const savePermissionUsers = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/savePermissionUsers',
    method: 'post',
    data: param
  })
}

// 获取请假审批权限
export const getLeaveApprovalPermission = () => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/selectOrgPermission',
    method: 'post',
    data: {
      permissionType: permissionType.LEAVEAPPROVAL
    }
  })
}

// 获取请假查看权限
export const getLeaveView = () => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/selectOrgPermission',
    method: 'post',
    data: {
      permissionType: permissionType.LEAVEVIEW
    }
  })
}

// 获取用品审批权限
export const getSupplyApproval = () => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/selectOrgPermission',
    method: 'post',
    data: {
      permissionType: permissionType.SUPPLYAPPROVAL
    }
  })
}

// 获取用品查看权限
export const getSupplyView = () => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategoryPermission/selectOrgPermission',
    method: 'post',
    data: {
      permissionType: permissionType.SUPPLYVIEW
    }
  })
}

// ===== 请假类型管理 =====
export const getLeaveTypeList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/selectLeaveTypeList',
    method: 'post',
    data: param
  })
}

export const saveLeaveType = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/saveLeaveType',
    method: 'post',
    data: param
  })
}

export const deleteLeaveType = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/deleteLeaveType',
    method: 'post',
    data: param
  })
}

export const findLeaveTypeList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/findLeaveTypeList',
    method: 'post',
    data: param
  })
}

// ===== 请假申请管理 =====
// 列表查询（支持分页与筛选）
export const getLeaveList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmLeave/selectList',
    method: 'post',
    data: param
  })
}

// 列表查询（支持分页与筛选）
export const getLeaveListByUserId = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmLeave/selectListByUserId',
    method: 'post',
    data: param
  })
}

// 获取待审核列表
export const getPendingLeaveList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmLeave/selectPendingList',
    method: 'post',
    data: param
  })
}

// 保存（新增/修改）请假申请
export const saveLeaveApplication = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmLeave/save',
    method: 'post',
    data: param
  })
}

// 提交请假申请进入审批
export const submitLeaveApplication = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmLeave/submit',
    method: 'post',
    data: param
  })
}

// 撤回请假申请
export const revokeLeaveApplication = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmLeave/revoke',
    method: 'post',
    data: param
  })
}

// 审批通过
export const approveLeave = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmLeave/approve',
    method: 'post',
    data: param
  })
}

// 驳回
export const rejectLeave = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmLeave/reject',
    method: 'post',
    data: param
  })
}

// 获取某申请的详情（含审批记录）
export const getLeaveById = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmLeave/getById',
    method: 'post',
    data: param
  })
}

// 审批历史（用于历史查询）
export const getLeaveApprovalHistory = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmLeave/selectApprovalHistory',
    method: 'post',
    data: param
  })
}

// 请假统计
export const getLeaveStats = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmLeave/selectStats',
    method: 'post',
    data: param
  })
}

// 转交审批人（前端发起将当前待审批任务转给其他审批人）
export const transferLeaveApproval = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmLeave/transferApproval',
    method: 'post',
    data: param
  })
}

// 选择转审核审批人列表
export const selectTransferApprovalList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmLeave/selectTransferApprovalList',
    method: 'post',
    data: param
  })
}

// 删除数据
export const deleteLeaveById = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmLeave/deleteById',
    method: 'post',
    data: param
  })
}

// ===== 办公用品分类管理 =====
export const getMaterialCategoryList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/selectMaterialCategoryList',
    method: 'post',
    data: param
  })
}

export const saveMaterialCategory = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/saveMaterialCategory',
    method: 'post',
    data: param
  })
}

export const deleteMaterialCategory = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/deleteMaterialCategory',
    method: 'post',
    data: param
  })
}

export const findMaterialCategoryList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/findMaterialCategoryList',
    method: 'post',
    data: param
  })
}

// ===== 办公用品管理 =====
export const getMaterialList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/selectMaterialList',
    method: 'post',
    data: param
  })
}

export const saveMaterial = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/saveMaterial',
    method: 'post',
    data: param
  })
}

export const deleteMaterial = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/deleteMaterial',
    method: 'post',
    data: param
  })
}

// 导入物料（Excel）
export const importMaterial = (formData) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/importMaterial',
    method: 'post',
    data: formData
  })
}

// 下载物料导入模板
export const materialTemplateDownload = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/templateDownload',
    method: 'post',
    data: param
  })
}

// ===== 入库管理 =====
// 入库列表
export const getInboundList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmInbound/selectList',
    method: 'post',
    data: param
  })
}

// 保存入库（含明细）
export const saveInbound = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmInbound/save',
    method: 'post',
    data: param
  })
}

// 删除入库记录
export const deleteInbound = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmInbound/delete',
    method: 'post',
    data: param
  })
}

// 执行入库（生成库存变更与日志）
export const doInbound = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmInbound/doInbound',
    method: 'post',
    data: param
  })
}

// 待归还列表（从申领中查询）
export const getPendingReturnList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmInbound/selectPendingReturnList',
    method: 'post',
    data: param
  })
}

// 处理归还（生成入库单并更新库存）
export const processReturn = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmInbound/processReturn',
    method: 'post',
    data: param
  })
}

// 库存查询
export const getInventoryList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmInbound/selectInventoryList',
    method: 'post',
    data: param
  })
}

// 入库详情
export const getInboundById = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmInbound/getById',
    method: 'post',
    data: param
  })
}

// 归还详情
export const getPendingReturnById = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmInbound/getPendingReturnById',
    method: 'post',
    data: param
  })
}

// 导入入库（Excel）
export const importInbound = (formData) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmInbound/importInbound',
    method: 'post',
    data: formData
  })
}

// ===== 申领管理 =====
// 申领列表（包含历史与查询）
export const getBorrowList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmBorrow/selectList',
    method: 'post',
    data: param
  })
}

// 待审核列表
export const getPendingBorrowList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmBorrow/selectPendingList',
    method: 'post',
    data: param
  })
}

// 获取历史列表
export const getHistoryBorrowList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmBorrow/selectHistoryList',
    method: 'post',
    data: param
  })
}

// 保存申请（含明细）
export const saveBorrowApplication = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmBorrow/save',
    method: 'post',
    data: param
  })
}

// 提交
export const submitBorrow = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmBorrow/submit',
    method: 'post',
    data: param
  })
}

// 撤回
export const revokeBorrow = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmBorrow/revoke',
    method: 'post',
    data: param
  })
}

// 审批通过（内部生成出库、更新库存）
export const approveBorrow = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmBorrow/approve',
    method: 'post',
    data: param
  })
}

// 驳回
export const rejectBorrow = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmBorrow/reject',
    method: 'post',
    data: param
  })
}

// 查询申请及明细/日志
export const getBorrowById = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmBorrow/getById',
    method: 'post',
    data: param
  })
}

// --统计部分---------------------------------------------------------------------------------------------
// 使用统计
export const getUsageStats = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/selectUsageStats',
    method: 'post',
    data: param
  })
}

export const getUsageDetails = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/selectUsageDetails',
    method: 'post',
    data: param
  })
}

// 工作量统计
export const getWorkloadStats = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/selectWorkloadStats',
    method: 'post',
    data: param
  })
}

export const getWorkloadDetails = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/selectWorkloadDetails',
    method: 'post',
    data: param
  })
}

// ===== 图表分析 =====
// 汇总统计数据
export const getSummaryStats = () => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/getSummaryStats',
    method: 'post'
  })
}

// 请假类型统计
export const getLeaveTypeStats = () => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/getLeaveTypeStats',
    method: 'post'
  })
}

// 人员请假统计
export const getLeaveUserStats = () => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/getLeaveUserStats',
    method: 'post'
  })
}

// 用品领用统计
export const getMaterialUsageStats = () => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/getMaterialUsageStats',
    method: 'post'
  })
}

// 库存预警列表
export const getStockWarningList = () => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/getStockWarningList',
    method: 'post'
  })
}

// ===== 部门管理 =====
export const getOrgList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/selectOrgList',
    method: 'post',
    data: param
  })
}

export const saveOrg = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/saveOrg',
    method: 'post',
    data: param
  })
}

export const deleteOrg = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/deleteOrg',
    method: 'post',
    data: param
  })
}

export const assignUsersToOrg = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/assignUsersToOrg',
    method: 'post',
    data: param
  })
}

// ===== 用户管理 =====
// 获取日常人员列表
export const getDmUserList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUser/selectList',
    method: 'post',
    data: param
  })
}

// 根据机构编码同步本级及下属机构用户（存在则更新、不存在则新增；null 不覆盖）
export const syncDmUsersByOffice = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUser/syncByOffice',
    method: 'post',
    data: param
  })
}

// 保存单个日常人员（前端编辑后保存）
export const saveDmUser = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUser/save',
    method: 'post',
    data: param
  })
}

// 获取人员选择器列表（根据机构和权限过滤）
export const getUserSelectorList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUser/selectUserSelectorList',
    method: 'post',
    data: param
  })
}

// 分页查询日常人员可选上级部门列表
export const dmUserOffice = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUser/dmUserOffice',
    method: 'post',
    data: param
  })
}

// 获取人员类型列表
export const getUserTypeList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/selectList',
    method: 'post',
    data: param
  })
}

// 获取人员多选器列表（所有在职人员）
export const getUserMultiSelectorList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUser/selectUserMultiSelectorList',
    method: 'post',
    data: param
  })
}

// 根据ID获取单个用户信息
export const getDmUserById = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUser/getById',
    method: 'post',
    data: param
  })
}
