import axios from '@/libs/api.request'

const permissionType = {
  // 键：枚举名，值：枚举值（可以是数字/字符串）
  LEAVEAPPROVAL: 'leave_approval', // 请假审核
  LEAVEVIEW: 'leave_view', // 请假查询统计
  SUPPLYAPPROVAL: 'supply_approval', // 用品审核
  SUPPLYVIEW: 'supply_view' // 用品查询统计
}

// 获取日常人员列表
export const getLeaveApprovalPermission = () => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/selectOrgPermission',
    method: 'post',
    data: {
      permissionType: permissionType.LEAVEAPPROVAL
    }
  })
}

// 根据机构编码同步本级及下属机构用户（存在则更新、不存在则新增；null 不覆盖）
export const getLeaveView = () => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/selectOrgPermission',
    method: 'post',
    data: {
      permissionType: permissionType.LEAVEVIEW
    }
  })
}

// 保存单个日常人员（前端编辑后保存）
export const getSupplyApproval = () => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/selectOrgPermission',
    method: 'post',
    data: {
      permissionType: permissionType.SUPPLYAPPROVAL
    }
  })
}

// 分页查询日常人员可选上级领导列表
export const getSupplyView = () => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategoryPermission/selectOrgPermission',
    method: 'post',
    data: {
      permissionType: permissionType.SUPPLYVIEW
    }
  })
}
