/* eslint-disable */
export function normalizeVisitTimeValue (value) {
  if (!value && value !== 0) return ''
  if (value instanceof Date) {
    return Number.isNaN(value.getTime()) ? '' : formatDateSegments(value)
  }
  if (typeof value === 'number' && !Number.isNaN(value)) {
    const fromNumber = new Date(value)
    return Number.isNaN(fromNumber.getTime()) ? '' : formatDateSegments(fromNumber)
  }
  if (typeof value === 'string') {
    const trimmed = value.trim()
    if (!trimmed) return ''
    const direct = new Date(trimmed)
    if (!Number.isNaN(direct.getTime())) return formatDateSegments(direct)
    const withSlash = new Date(trimmed.replace(/-/g, '/'))
    if (!Number.isNaN(withSlash.getTime())) return formatDateSegments(withSlash)
    const match = trimmed.match(/^(\d{4})-(\d{2})-(\d{2})(?:[ T](\d{2}):(\d{2})(?::(\d{2}))?)?$/)
    if (match) {
      const [, y, m, d, hh = '00', mm = '00', ss = '00'] = match
      return `${y}-${m}-${d} ${hh}:${mm}:${ss}`
    }
    return ''
  }
  if (value && typeof value === 'object' && typeof value.valueOf === 'function') {
    const timestamp = value.valueOf()
    if (!Number.isNaN(timestamp)) {
      const fromValue = new Date(timestamp)
      return Number.isNaN(fromValue.getTime()) ? '' : formatDateSegments(fromValue)
    }
  }
  return ''
}
function formatDateSegments (d) {
  const y = d.getFullYear()
  const mm = String(d.getMonth() + 1).padStart(2, '0')
  const dd = String(d.getDate()).padStart(2, '0')
  const HH = String(d.getHours()).padStart(2, '0')
  const MM = String(d.getMinutes()).padStart(2, '0')
  const SS = String(d.getSeconds()).padStart(2, '0')
  return `${y}-${mm}-${dd} ${HH}:${MM}:${SS}`
}
