import axios from '@/libs/api.request'

// 列表查询（支持分页与筛选）
export const getLeaveList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmLeave/selectList',
    method: 'post',
    data: param
  })
}

// 获取待审核列表
export const getPendingList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmLeave/selectPendingList',
    method: 'post',
    data: param
  })
}

// 保存（新增/修改）请假申请
export const saveLeaveApplication = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmLeave/save',
    method: 'post',
    data: param
  })
}

// 提交请假申请进入审批
export const submitLeaveApplication = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmLeave/submit',
    method: 'post',
    data: param
  })
}

// 撤回请假申请
export const revokeLeaveApplication = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmLeave/revoke',
    method: 'post',
    data: param
  })
}

// 审批通过
export const approveLeave = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmLeave/approve',
    method: 'post',
    data: param
  })
}

// 驳回
export const rejectLeave = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmLeave/reject',
    method: 'post',
    data: param
  })
}

// 获取某申请的详情（含审批记录）
export const getLeaveById = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmLeave/getById',
    method: 'post',
    data: param
  })
}

// 审批历史（用于历史查询）
export const getApprovalHistory = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmLeave/selectApprovalHistory',
    method: 'post',
    data: param
  })
}

// 请假统计
export const getLeaveStats = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmLeave/selectStats',
    method: 'post',
    data: param
  })
}


