import axios from '@/libs/api.request'
export const insertEvent = (param) => { // 事件上报
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/insertEvent',
    method: 'post',
    data: param
  })
}
export const selectDictList = (param) => { // 字典
  return axios.request({
    url: '/api/as/jilinsscgsdp/sys/selectDictList',
    method: 'post',
    data: param
  })
}
// 我的工作台总数统计
export const selectTitleMap = (param) => {
  return axios.request({
    url: '/api/as/jilinsscgsdp/statistics/selectTitleMap',
    method: 'post',
    data: param
  })
}
// 4类纠纷总数
export const getFourType = (param) => {
  return axios.request({
    url: '/api/as/jilinsscgsdp/statistics/getFourType',
    method: 'post',
    data: param
  })
}
// 我的工作台预警列表
export const selectEarlyWarningList = (param) => {
  return axios.request({
    url: '/api/as/jilinsscgsdp/statistics/selectEarlyWarningList',
    method: 'post',
    data: param
  })
}
// 我的工作台待处理列表
export const selectAgencyHandlingList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/statisticsService/selectAgencyHandlingList',
    method: 'post',
    data: param
  })
}
// 我的工作台纠纷排名
export const selectLabelList = (param) => {
  return axios.request({
    url: '/api/as/jilinsscgsdp/statistics/selectLabelList',
    method: 'post',
    data: param
  })
}

export const findEventLogByOfficeStatusList = (param) => { // 事件查询列表
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/findEventLogByOfficeStatusList',
    method: 'post',
    data: param
  })
}
export const findEarlyWarningList = (param) => { // 超期事件查询列表
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/findEarlyWarningList',
    method: 'post',
    data: param
  })
}
export const findEarlyWarningStatusList = (param) => { // 超期事件查询列表
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/findEarlyWarningStatusList',
    method: 'post',
    data: param
  })
}
export const selectCityList = (param) => { // 事件城市层级
  return axios.request({
    url: '/api/as/jilinsscgsdp/sys/selectCityList',
    method: 'post',
    data: param
  })
}
export const findEventLogByCreateList = (param) => { // 网格员查询事件列表
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/findEventLogByCreateList',
    method: 'post',
    data: param
  })
}
export const updateEventCompletion = (param) => { // 网格员办结
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/updateEventCompletion',
    method: 'post',
    data: param
  })
}
export const insertEventEnd = (param) => { // 网格员直接办结
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/insertEventEnd',
    method: 'post',
    data: param
  })
}
export const updateEventAcceptance = (param) => { // 更改事件受理状态
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/updateEventAcceptance',
    method: 'post',
    data: param
  })
}
export const insertEventFlowLog = (param) => { // 事件上报审批 办结 驳回
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/insertEventFlowLog',
    method: 'post',
    data: param
  })
}
export const getEventLogByCreateId = (param) => { // 查询网格员事件详情
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/getEventLogByCreateId',
    method: 'post',
    data: param
  })
}
export const getEventLogById = (param) => { // 查询事件详情
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/getEventLogById',
    method: 'post',
    data: param
  })
}
export const selectOfficeList = (param) => { // 查询分派机构列表
  return axios.request({
    url: '/api/as/jilinsscgsdp/sys/selectOfficeList',
    method: 'post',
    data: param
  })
}
export const insertEventFlowLogAssignment = (param) => { // 分派
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/insertEventFlowLogAssignment',
    method: 'post',
    data: param
  })
}
export const findFlowLogProcessList = (param) => { // 流程详情
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/findFlowLogProcessList',
    method: 'post',
    data: param
  })
}
export const insertOffice = (param) => { // 添加机构及同时创建用户
  return axios.request({
    url: '/api/ac/jilinsscgsdp/sysService/insertOffice',
    method: 'post',
    data: param
  })
}
export const selectOfficeParentList = (param) => { // 机构列表
  return axios.request({
    url: '/api/as/jilinsscgsdp/sys/selectOfficeParentList',
    method: 'post',
    data: param
  })
}
export const selectOfficeParentInfo = (param) => { // 机构详情
  return axios.request({
    url: '/api/as/jilinsscgsdp/sys/selectOfficeParentInfo',
    method: 'post',
    data: param
  })
}
export const updateSysOffice = (param) => { // 机构删除
  return axios.request({
    url: '/api/as/jilinsscgsdp/sys/updateSysOffice',
    method: 'post',
    data: param
  })
}
export const insertUser = (param) => { // 添加用户及角色
  return axios.request({
    url: '/api/ac/jilinsscgsdp/sysService/insertUser',
    method: 'post',
    data: param
  })
}
export const selectUserCompanyList = (param) => { // 用户列表
  return axios.request({
    url: '/api/as/jilinsscgsdp/sys/selectUserCompanyList',
    method: 'post',
    data: param
  })
}
export const findEventPageList = (param) => { // 政法委和综治中心数据列表
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/findEventPageList',
    method: 'post',
    data: param
  })
}
export const findEventAllList = (param) => { // 矛盾纠纷列表查询
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/findEventAllList',
    method: 'post',
    data: param
  })
}
export const findSafeSoundEventLogByOfficeStatusList = (param) => { // 政法委和综治中心数据列表
  return axios.request({
    url: '/api/ac/jilinsscgsdp/safeSound/findSafeSoundEventLogByOfficeStatusList',
    method: 'post',
    data: param
  })
}
export const insertSafeSoundEvent = (param) => { // 政法委和综治中心数据列表
  return axios.request({
    url: '/api/ac/jilinsscgsdp/safeSound/insertSafeSoundEvent',
    method: 'post',
    data: param
  })
}
export const getEventAllAsc = (param) => { // 政法委和综治中心数据详情
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/getEventAllAsc',
    method: 'post',
    data: param
  })
}
export const selectOfficeTypeParentList = (param) => { // 查询单位下拉数据
  return axios.request({
    url: '/api/as/jilinsscgsdp/sys/selectOfficeTypeParentList',
    method: 'post',
    data: param
  })
}
export const updateUser = (param) => { // 需改删除用户
  return axios.request({
    url: '/api/as/jilinsscgsdp/sys/updateUser',
    method: 'post',
    data: param
  })
}
export const uploadFile = (param) => { // 上传图片（文件流）
  return axios.request({
    url: '/api/ac/jilinsscgsdp/uploadService/uploadFile',
    method: 'post',
    data: param
  })
}
export const selectEventIdByAttachList = (param) => { // 查询图片文件流uuid
  return axios.request({
    url: '/api/as/jilinsscgsdp/attach/selectEventIdByAttachList',
    method: 'post',
    data: param
  })
}
export const selectNoticeIdByAttachList = (param) => { // 查询通知公告图片文件流uuid
  return axios.request({
    url: '/api/as/jilinsscgsdp/attach/selectNoticeIdByAttachList',
    method: 'post',
    data: param
  })
}
export const getObsObject = (data) => { // 根据uuid获取图片
  return axios.request({
    url: '/api/ac/jilinsscgsdp/uploadService/getObsObject?uuid=' + data,
    method: 'get',
    dataType: 'blob'
  })
}
export const insertEventOpinion = (param) => { // 添加超期预警处置
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/insertEventOpinion',
    method: 'post',
    data: param
  })
}
export const selectOpinionList = (param) => { // 查询超期预警处置
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/selectOpinionList',
    method: 'post',
    data: param
  })
}
export const updateEventOpinion = (param) => { // 修改超期预警处置
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/updateEventOpinion',
    method: 'post',
    data: param
  })
}
export const insertGridUser = (param) => { // 社区添加网格员用户及角色
  return axios.request({
    url: '/api/ac/jilinsscgsdp/sysService/insertGridUser',
    method: 'post',
    data: param
  })
}
export const findGridUserList = (param) => { // 查询当前社区网格员
  return axios.request({
    url: '/api/as/jilinsscgsdp/sys/findGridUserList',
    method: 'post',
    data: param
  })
}
export const updateGridUser = (param) => { // 修改网格员信息
  return axios.request({
    url: '/api/as/jilinsscgsdp/sys/updateGridUser',
    method: 'post',
    data: param
  })
}
export const insertGridSpecialTask = (param) => { // 添加专项任务
  return axios.request({
    url: '/api/as/jilinsscgsdp/special/insertGridSpecialTask',
    method: 'post',
    data: param
  })
}
export const findGridSpecialTaskList = (param) => { // 查询专项任务
  return axios.request({
    url: '/api/as/jilinsscgsdp/special/findGridSpecialTaskList',
    method: 'post',
    data: param
  })
}
export const findGridSpecialTaskHandlingList = (param) => { // 查询处置专项任务列表
  return axios.request({
    url: '/api/as/jilinsscgsdp/special/findGridSpecialTaskHandlingList',
    method: 'post',
    data: param
  })
}
export const updateGridSpecialTask = (param) => { // 专项任务处置
  return axios.request({
    url: '/api/as/jilinsscgsdp/special/updateGridSpecialTask',
    method: 'post',
    data: param
  })
}
export const selectRiskLevelList = (param) => { // 风险情况详情展示
  return axios.request({
    url: '/api/as/jilinsscgsdp/eventflow/selectRiskLevelList',
    method: 'post',
    data: param
  })
}
export const getImToken = (param) => { // 获取token接口
  return axios.request({
    url: '/api/ac/jilinsscgsdp/sysService/getImToken',
    method: 'post',
    data: param
  })
}
export const selectUserAppIdList = (param) => { // 获取用户userId接口
  return axios.request({
    url: '/api/as/jilinsscgsdp/sys/selectUserAppIdList',
    method: 'post',
    data: param
  })
}
export const getUserAppidByCode = (param) => { // 获取当前登录用户userId接口
  return axios.request({
    url: '/api/as/jilinsscgsdp/sys/getUserAppidByCode',
    method: 'post',
    data: param
  })
}
export const selectEventList = (param) => { // 统计接口
  return axios.request({
    url: '/api/as/jilinsscgsdp/statistics/selectEventList',
    method: 'post',
    data: param
  })
}
export const findTriggerEventList = (param) => { // 风险预警（风险预警历史type=2）接口
  return axios.request({
    url: '/api/as/jilinsscgsdp/eventuser/findTriggerEventList',
    method: 'post',
    data: param
  })
}
export const findFocusAreasTypeList = (param) => { // 风险预警（重点领域）接口
  return axios.request({
    url: '/api/as/jilinsscgsdp/focusareas/findFocusAreasTypeList',
    method: 'post',
    data: param
  })
}
export const getFocusAreaPage = (param) => { // 风险预警（重点领域）接口 最新版
  return axios.request({
    url: '/api/ac/jilinsscgsdp/FocusAreaNewForManage/getFocusAreaPage',
    method: 'post',
    data: param
  })
}
export const findEventFocusAreasList = (param) => { // 风险预警（重点领域详情列表）接口
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/findEventFocusAreasList',
    method: 'post',
    data: param
  })
}
export const getEventaPageList = (param) => { // 风险预警（重点领域详情列表）接口  最新版
  return axios.request({
    url: '/api/ac/jilinsscgsdp/FocusRegionNewForManage/getEventaPageList',
    method: 'post',
    data: param
  })
}
export const getAreaEventaPageList = (param) => { // 风险预警（重点领域详情列表）接口  最新版
  return axios.request({
    url: '/api/ac/jilinsscgsdp/FocusAreaNewForManage/getEventaPageList',
    method: 'post',
    data: param
  })
}

export const findFocusAreasCityList = (param) => { // 风险预警（重点地区）接口
  return axios.request({
    url: '/api/as/jilinsscgsdp/focusareas/findFocusAreasCityList',
    method: 'post',
    data: param
  })
}
export const getFocusRegionPage = (param) => { // 风险预警（重点地区）接口 //最新版
  return axios.request({
    url: '/api/ac/jilinsscgsdp/FocusRegionNewForManage/getFocusRegionPage',
    method: 'post',
    data: param
  })
}
export const updateFocusAreasType = (param) => { // 风险预警（重点领域解除风险）接口
  return axios.request({
    url: '/api/as/jilinsscgsdp/focusareas/updateFocusAreasType',
    method: 'post',
    data: param
  })
}
export const updateFocusAreasCity = (param) => { // 风险预警（重点地区解除风险）接口
  return axios.request({
    url: '/api/as/jilinsscgsdp/focusareas/updateFocusAreasCity',
    method: 'post',
    data: param
  })
}
export const findTriggerEventIdList = (param) => { // 风险预警触发矛盾列表接口
  return axios.request({
    url: '/api/as/jilinsscgsdp/eventuser/findTriggerEventIdList',
    method: 'post',
    data: param
  })
}
export const selectJuniorList = (param) => { // 下派查询机构接口
  return axios.request({
    url: '/api/as/jilinsscgsdp/sys/selectJuniorList',
    method: 'post',
    data: param
  })
}
export const selectOfficeFaxList = (param) => { // 下派横传机构接口
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/selectOfficeFaxList',
    method: 'post',
    data: param
  })
}
export const getFaxById = (param) => { // 查询是否为单位 num=1则为单位 等于0是综治中心
  return axios.request({
    url: '/api/as/jilinsscgsdp/sys/getFaxById',
    method: 'post',
    data: param
  })
}

// 首页统计
export const getStatisticsTriggerNumber = (param) => {
  return axios.request({
    url: '/api/as/jilinsscgsdp/event/getStatisticsTriggerNumber',
    method: 'post',
    data: param
  })
}

export const countEventTrigger = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/countEventTrigger',
    method: 'post',
    data: param
  })
}
export const findEventTrigger = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/findEventTriggerList',
    method: 'post',
    data: param
  })
}
export const findTriggerEventIdListForTriggerList = (param) => {
  return axios.request({
    url: '/api/as/jilinsscgsdp/eventuser/findTriggerEventIdListForTriggerList',
    method: 'post',
    data: param
  })
}

// 权限菜单
export const selectRoleMenuList = (param) => {
  return axios.request({
    url: '/api/as/jilinsscgsdp/sys/selectRoleMenuList',
    method: 'post',
    data: param
  })
}

// 权限菜单
export const selectCommunityCode = (param) => {
  return axios.request({
    url: '/api/as/jilinsscgsdp/sys/selectCommunityCode',
    method: 'post',
    data: param
  })
}

// 权限菜单
export const getJobDuty = (param) => {
  return axios.request({
    url: '/api/as/jilinsscgsdp/sys/getJobDuty',
    method: 'post',
    data: param
  })
}

// 根据人员id查询身份证号码
export const getCardNoById = (param) => {
  return axios.request({
    url: '/api/as/jilinsscgsdp/peopleInfo/getCardNoById',
    method: 'post',
    data: param
  })
}

// 首页查总数
export const getCountNumber = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/statisticsService/getCountNumber',
    method: 'post',
    data: param
  })
}

export const newGetCompanyInfo = (data) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/newGridLevelService/getCompantInfo',
    method: 'post',
    data: data
  })
}

export const newFindGridChildrenList = (data) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/newGridLevelService/findGridChildrenList',
    method: 'post',
    data: data
  })
}
// 查询总机构下级机构
export const findOfficeChildrenList = (data) => { // 2025-07-09
  return axios.request({
    url: '/api/as/jilinsscgsdp/sys/findOfficeChildrenList',
    method: 'post',
    data: data
  })
}

export const selectOfficeUserList = (data) => {
  return axios.request({
    url: '/api/as/jilinsscgsdp/sys/selectOfficeUserList',
    method: 'post',
    data: data
  })
}

export const updateUserById = (data) => {
  return axios.request({
    url: '/api/as/jilinsscgsdp/sys/updateUserById',
    method: 'post',
    data: data
  })
}

export const updateLoginFlagByUserId = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/sysService/updateLoginFlagByUserId',
    method: 'post',
    data: param
  })
}
// 风险因子列表（用户主动添加的）
export const selectARiskFactorList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/RiskFactorManagement/selectARiskFactorList',
    method: 'post',
    data: param
  })
}
export const deleteRiskFactorById = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/RiskFactorManagement/deleteRiskFactorById',
    method: 'post',
    data: param
  })
}
// 风险因子-添加（用户主动添加）
export const insertRiskFactor = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/RiskFactorManagement/insertRiskFactor',
    method: 'post',
    data: param
  })
}
// 风险因子-删除（用户主动添加的）
export const updateRiskFactor = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/RiskFactorManagement/updateRiskFactor',
    method: 'post',
    data: param
  })
}
// 风险因子
export const selectConflictWarningList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/ConflictWarningManagement/selectConflictWarningList',
    method: 'post',
    data: param
  })
}
export const updateConflictWarning = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/ConflictWarningManagement/updateConflictWarning',
    method: 'post',
    data: param
  })
}
export const getDictInfoList = (param) => {
  return axios.request({
    url: '/api/as/sc/dict/getDictInfoList',
    method: 'post',
    data: param
  })
}
export const selectDisputeResolutionList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/DisputeResolution/selectDisputeResolutionList',
    method: 'post',
    data: param
  })
}
export const insertDisputeResolution = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/DisputeResolution/insertDisputeResolution',
    method: 'post',
    data: param
  })
}
export const deleteDisputeResolutionById = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/DisputeResolution/deleteDisputeResolutionById',
    method: 'post',
    data: param
  })
}
export const updateDisputeResolution = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/DisputeResolution/updateDisputeResolution',
    method: 'post',
    data: param
  })
}
// 回访记录
export const selectFollowUpRecordsList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/selectFollowUpRecordsList',
    method: 'post',
    data: param
  })
}
export const deleteFollowUpRecords = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/deleteFollowUpRecords',
    method: 'post',
    data: param
  })
}
export const insertFollowUpRecords = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/insertFollowUpRecords',
    method: 'post',
    data: param
  })
}
export const updateFollowUpRecords = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/updateFollowUpRecords',
    method: 'post',
    data: param
  })
}
// 查询通告列表
export const selectListPage = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/noticeService/selectListPage',
    method: 'post',
    data: param
  })
}
// 删除通知
export const deleteNotice = (data) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/noticeService/updateDelData',
    data: data,
    method: 'post'
  })
}
// 查询通知
export const getNotice = (data) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/noticeService/getObject',
    data: data,
    method: 'post'
  })
}
// 修改通知
export const updateNotice = (data) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/noticeService/updateData',
    data: data,
    method: 'post'
  })
}
// 新增通知
export const addNotice = (data) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/noticeService/insertData',
    data: data,
    method: 'post'
  })
}
export const uploadObjectBase64Neo = (param) => {
  return axios.request({
    url: '/api/ac/hdplugin/ossService/uploadObjectBase64Neo',
    method: 'post',
    data: param
  })
}
export const getSignNeo = (param) => {
  return axios.request({
    url: '/api/ac/hdplugin/ossService/getSignNeo',
    method: 'post',
    data: param
  })
}
export const getViewFile = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/uploadService/getViewFile',
    method: 'post',
    data: param
  })
}
// 重点行业领域矛盾纠纷情况统计表
export const eventCategoryStatisticsServiceImpl = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/EventStatisticsServiceImpl/eventCategoryStatisticsServiceImpl',
    method: 'post',
    data: param
  })
}
// 矛盾纠纷排查化解情况统计表
export const eventResolveStatisticsServiceImpl = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/EventStatisticsServiceImpl/eventResolveStatisticsServiceImpl',
    method: 'post',
    data: param
  })
}
// 纠纷类型列表
export const selectEventCategoryList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/EventCategoryServiceImpl/selectEventCategoryList',
    method: 'post',
    data: param
  })
}
// 添加纠纷类型
export const insertEventCategory = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/EventCategoryServiceImpl/insertEventCategory',
    method: 'post',
    data: param
  })
}
// 修改纠纷类型
export const updateEventCategory = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/EventCategoryServiceImpl/updateEventCategory',
    method: 'post',
    data: param
  })
}
// 手动填报的纠纷类型列表
export const selectEventCategoryOtherList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/EventCategoryServiceImpl/selectEventCategoryOtherList',
    method: 'post',
    data: param
  })
}
// 删除/修改手动填报纠纷类型
export const updateEventCategoryOther = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/EventCategoryServiceImpl/updateEventCategoryOther',
    method: 'post',
    data: param
  })
}

// 数据导出通用   刑满释放人员==2，严重精神障碍患者==3，涉重点信访事项人员==4，涉重点涉法涉诉类人员==5，"三失一偏"人员==1
export const findKeyPersonListExport = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/murderManagementService/findKeyPersonListExport',
    method: 'post',
    data: param
  })
}
// 系统去重-列表
export const selectEventRepeatbleList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/EventDealRepeatableServiceImpl/selectEventRepeatbleList',
    method: 'post',
    data: param
  })
}
// 系统去重-详情
export const eventRepeatbleInfoList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/EventDealRepeatableServiceImpl/eventRepeatbleInfoList',
    method: 'post',
    data: param
  })
}
// 系统去重-删除重复项
export const updateEventRepeatbleInfo = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/EventDealRepeatableServiceImpl/updateEventRepeatbleInfo',
    method: 'post',
    data: param
  })
}
// 获取超期预警管理配置列表
export const getEventOverdueWarningConfigList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/jlEventOverdueWarningConfigService/findList',
    method: 'get',
    data: param
  })
}
// 保存超期预警管理配置
export const saveEventOverdueWarningConfigList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/jlEventOverdueWarningConfigService/update',
    method: 'post',
    data: param
  })
}
export const getTriggerEventHistory = (param) => { // 获取重点人触发历史
  return axios.request({
    url: '/api/as/jilinsscgsdp/eventuser/getTriggerEventHistoryList',
    method: 'post',
    data: param
  })
}

export const getGroupEventWarningCount = (param) => { // 获取群体性事件预警数据
  return axios.request({
    url: '/api/ac/jilinsscgsdp/waringService/getGroupEventWarningCount',
    method: 'post',
    data: param
  })
}

export const getWarningStatisticsCount = (param) => { // 获取预警统计数据
  return axios.request({
    url: '/api/ac/jilinsscgsdp/waringService/getWarningStatisticsCount',
    method: 'post',
    data: param
  })
}

export const getHomeWarningStatisticsCount = (param) => { // 获取首页预警统计数据
  return axios.request({
    url: '/api/ac/jilinsscgsdp/waringService/getHomeWarningStatisticsCount',
    method: 'post',
    data: param
  })
}

export const findOverdueEventPageList = (param) => { // 获取矛盾超期预警列表
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/findOverdueEventPageList',
    method: 'post',
    data: param
  })
}

export const findEventRiskFactorPageList = (param) => { // 获取风险因子预警列表
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/findEventRiskFactorPageList',
    method: 'post',
    data: param
  })
}

export const fousAreaWarringPageList = (param) => { // 获取重点领域预警列表
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/fousAreaWarringPageList',
    method: 'post',
    data: param
  })
}

export const findInvolveEveryonePageList = (param) => { // 获取重点领域预警列表(新)
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/findInvolveEveryonePageList',
    method: 'post',
    data: param
  })
}
export const insertSocialSecurity = (param) => { // 社会治安管理-添加
  return axios.request({
    url: '/api/ac/jilinsscgsdp/SocialSecurityServiceImpl/insertSocialSecurity',
    method: 'post',
    data: param
  })
}
export const updateSocialSecurity = (param) => { // 社会治安管理-修改
  return axios.request({
    url: '/api/ac/jilinsscgsdp/SocialSecurityServiceImpl/updateSocialSecurity',
    method: 'post',
    data: param
  })
}
export const selectSocialSecurityInfo = (param) => { // 社会治安管理-详情
  return axios.request({
    url: '/api/ac/jilinsscgsdp/SocialSecurityServiceImpl/selectSocialSecurityInfo',
    method: 'post',
    data: param
  })
}
export const selectSocialSecurityPageList = (param) => { // 社会治安管理-列表
  return axios.request({
    url: '/api/ac/jilinsscgsdp/SocialSecurityServiceImpl/selectSocialSecurityPageList',
    method: 'post',
    data: param
  })
}

export const selectWarningAreaPageList = (param) => { // 获取重点领域预警列表(新版)
  return axios.request({
    url: '/api/as/jilinsscgsdp/event/selectWarningAreaPageList',
    method: 'post',
    data: param
  })
}

export const getIsHXOffice = (param) => { // u67e5u8be2u662fu5426u662fu8f85u8bafu5355u4f4d
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/getIsHXOffice',
    method: 'post',
    data: param
  })
}
export const updateUserInfoById = (param) => { // 修改用户信息
  return axios.request({
    url: '/api/as/jilinsscgsdp/sys/updateUserInfoById',
    method: 'post',
    data: param
  })
}
export const createUser = (param) => { // 添加用户账号信息
  return axios.request({
    url: '/api/ac/jilinsscgsdp/sysService/createUser',
    method: 'post',
    data: param
  })
}
export const updateOfficeInfoById = (param) => { // 修改机构信息
  return axios.request({
    url: '/api/as/jilinsscgsdp/sys/updateOfficeInfoById',
    method: 'post',
    data: param
  })
}
export const createOffice = (param) => { // 添加机构信息
  return axios.request({
    url: '/api/ac/jilinsscgsdp/sysService/createOffice',
    method: 'post',
    data: param
  })
}

export const deleteEvent = (param) => { // 添加机构信息
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/deleteEvent',
    method: 'post',
    data: param
  })
}

export const getReportUnitStatisticCountList = (param) => { // 添加机构信息
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/getReportUnitStatisticCountList',
    method: 'post',
    data: param
  })
}

export const getReportUnitStatisticTotalCount = (param) => { // 添加机构信息
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/getReportUnitStatisticTotalCount',
    method: 'post',
    data: param
  })
}
export const selectCreateByList = (param) => { // 添加机构信息
  return axios.request({
    url: '/api/as/jilinsscgsdp/event/selectCreateByList',
    method: 'post',
    data: param
  })
}
export const getSafeSoundEvent = (param) => { // 添加机构信息
  return axios.request({
    url: '/api/ac/jilinsscgsdp/safeSound/getSafeSoundEvent',
    method: 'post',
    data: param
  })
}

export const rejectSafeSoundEvent = (param) => { // 驳回事件
  return axios.request({
    url: '/api/ac/jilinsscgsdp/safeSound/updateSafeSoundEventTypeNum',
    method: 'post',
    data: param
  })
}

// 区划树
export const findNodes = (data) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/noticeService/findNodes',
    data: data,
    method: 'post'
  })
}

export const updateStatus = (data) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/noticeService/updateStatus',
    data: data,
    method: 'post'
  })
}

// 综治中心规范化建设运行情况表相关接口
export const getComprehensiveCenterList = (param) => { // 获取列表
  return axios.request({
    url: '/api/ac/jilinsscgsdp/constructionSelection/selectComprehensiveGovernanceList',
    method: 'post',
    data: param
  })
}

export const getComprehensiveCenterById = (param) => { // 根据ID获取详情
  return axios.request({
    url: '/api/ac/jilinsscgsdp/constructionSelection/getComprehensiveGovernance',
    method: 'post',
    data: param
  })
}

export const insertComprehensiveCenter = (param) => { // 新增
  return axios.request({
    url: '/api/ac/jilinsscgsdp/constructionSelection/insertComprehensiveGovernance',
    method: 'post',
    data: param
  })
}

export const updateComprehensiveCenter = (param) => { // 更新
  return axios.request({
    url: '/api/ac/jilinsscgsdp/constructionSelection/updateComprehensiveGovernance',
    method: 'post',
    data: param
  })
}

export const deleteComprehensiveCenter = (param) => { // 删除
  return axios.request({
    url: '/api/ac/jilinsscgsdp/constructionSelection/updateComprehensiveGovernance',
    method: 'post',
    data: param
  })
}

export const getOtherOptions = (param) => { // 获取"其他"选项列表（用于动态加载）
  return axios.request({
    url: '/api/ac/jilinsscgsdp/comprehensiveCenter/getOtherOptions',
    method: 'post',
    data: param
  })
}

// 综合谈判预警历史-卡片统计
export const getWarningStatisticsCountHistory = (param) => { // 获取预警统计数据
  return axios.request({
    url: '/api/ac/jilinsscgsdp/waringService/getWarningStatisticsCountHistory',
    method: 'post',
    data: param
  })
}

// 综合谈判预警历史列表-风险因子预警历史
export const findEventRiskFactorHistoryPageList = (param) => { // 获取预警统计数据
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/findEventRiskFactorHistoryPageList',
    method: 'post',
    data: param
  })
}
// 综合谈判预警历史列表-群体性事件预警历史
export const findEventTriggerHistoryPageList = (param) => { // 获取预警统计数据
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/findEventTriggerHistoryPageList',
    method: 'post',
    data: param
  })
}
// 综合谈判预警历史列表-涉众预警历史
export const findInvolveEveryoneHistoryPageList = (param) => { // 获取预警统计数据
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/findInvolveEveryoneHistoryPageList',
    method: 'post',
    data: param
  })
}
// 综合谈判预警历史列表-重点人历史
export const findImportantUserHistoryPageList = (param) => { // 获取预警统计数据
  return axios.request({
    url: '/api/ac/jilinsscgsdp/waringService/findImportantUserHistoryPageList',
    method: 'post',
    data: param
  })
}
// 综合谈判预警历史列表-矛盾超期历史
export const findOverdueEventHistoryPageList = (param) => { // 获取预警统计数据
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/findOverdueEventHistoryPageList',
    method: 'post',
    data: param
  })
}
// 综合谈判预警历史列表-重点领域预警历史
export const selectWarningAreaPageHistoryList = (param) => { // 获取重点领域预警列表(新版)
  return axios.request({
    url: '/api/as/jilinsscgsdp/event/selectWarningAreaPageHistoryList',
    method: 'post',
    data: param
  })
}
// 综合谈判预警历史列表-重点领域预警历史-详情列表
export const fousAreaWarringPageHistoryList = (param) => { // 获取重点领域预警列表(新版)
  return axios.request({
    url: '/api/ac/jilinsscgsdp/eventService/fousAreaWarringPageHistoryList',
    method: 'post',
    data: param
  })
}
