import axios from '@/libs/api.request'

// ===== 人员权限配置 =====
export const getPermissionConfigList = () => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/selectPermissionConfigList',
    method: 'post'
  })
}

export const getUserDmPermissionList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/selectUserDmPermissionList',
    method: 'post',
    data: param
  })
}

export const savePermissionUsers = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/savePermissionUsers',
    method: 'post',
    data: param
  })
}

// ===== 请假类型管理 =====
export const getLeaveTypeList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/selectLeaveTypeList',
    method: 'post',
    data: param
  })
}

export const saveLeaveType = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/saveLeaveType',
    method: 'post',
    data: param
  })
}

export const deleteLeaveType = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/deleteLeaveType',
    method: 'post',
    data: param
  })
}

export const findLeaveTypeList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/findLeaveTypeList',
    method: 'post',
    data: param
  })
}

// ===== 办公用品分类管理 =====
export const getMaterialCategoryList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/selectMaterialCategoryList',
    method: 'post',
    data: param
  })
}

export const saveMaterialCategory = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/saveMaterialCategory',
    method: 'post',
    data: param
  })
}

export const deleteMaterialCategory = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/deleteMaterialCategory',
    method: 'post',
    data: param
  })
}

export const findMaterialCategoryList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/findMaterialCategoryList',
    method: 'post',
    data: param
  })
}

// ===== 办公用品管理 =====
export const getMaterialList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/selectMaterialList',
    method: 'post',
    data: param
  })
}

export const saveMaterial = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/saveMaterial',
    method: 'post',
    data: param
  })
}

export const deleteMaterial = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/deleteMaterial',
    method: 'post',
    data: param
  })
}

// 导入物料（Excel）
export const importMaterial = (formData) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/importMaterial',
    method: 'post',
    data: formData
  })
}

// 下载物料导入模板
export const materialTemplateDownload = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/templateDownload',
    method: 'post',
    data: param
  })
}

// --统计部分---------------------------------------------------------------------------------------------
// 使用统计
export const getUsageStats = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/selectUsageStats',
    method: 'post',
    data: param
  })
}

export const getUsageDetails = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/selectUsageDetails',
    method: 'post',
    data: param
  })
}

// 工作量统计
export const getWorkloadStats = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/selectWorkloadStats',
    method: 'post',
    data: param
  })
}

export const getWorkloadDetails = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/selectWorkloadDetails',
    method: 'post',
    data: param
  })
}

// ===== 图表分析 =====
// 汇总统计数据
export const getSummaryStats = () => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/getSummaryStats',
    method: 'post'
  })
}

// 请假类型统计
export const getLeaveTypeStats = () => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/getLeaveTypeStats',
    method: 'post'
  })
}

// 人员请假统计
export const getLeaveUserStats = () => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/getLeaveUserStats',
    method: 'post'
  })
}

// 用品领用统计
export const getMaterialUsageStats = () => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/getMaterialUsageStats',
    method: 'post'
  })
}

// 库存预警列表
export const getStockWarningList = () => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/getStockWarningList',
    method: 'post'
  })
}

// ===== 部门管理 =====
export const getOrgList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/selectOrgList',
    method: 'post',
    data: param
  })
}

export const saveOrg = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/saveOrg',
    method: 'post',
    data: param
  })
}

export const deleteOrg = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/deleteOrg',
    method: 'post',
    data: param
  })
}

export const assignUsersToOrg = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/assignUsersToOrg',
    method: 'post',
    data: param
  })
}
