import axios from '@/libs/api.request'

// 入库列表
export const getInboundList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmInbound/selectList',
    method: 'post',
    data: param
  })
}

// 保存入库（含明细）
export const saveInbound = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmInbound/save',
    method: 'post',
    data: param
  })
}

// 删除入库记录
export const deleteInbound = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmInbound/delete',
    method: 'post',
    data: param
  })
}

// 执行入库（生成库存变更与日志）
export const doInbound = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmInbound/doInbound',
    method: 'post',
    data: param
  })
}

// 待归还列表（从申领中查询）
export const getPendingReturnList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmInbound/selectPendingReturnList',
    method: 'post',
    data: param
  })
}

// 处理归还（生成入库单并更新库存）
export const processReturn = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmInbound/processReturn',
    method: 'post',
    data: param
  })
}

// 库存查询
export const getInventoryList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmInbound/selectInventoryList',
    method: 'post',
    data: param
  })
}

// 详情
export const getInboundById = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmInbound/getById',
    method: 'post',
    data: param
  })
}
